/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.ByteColumn;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.Importer;
import db.IntegerColumn;
import db.LongColumn;
import db.StringColumn;
import db.Table;
import db.Transaction;
import db.matchedTokens;
import db.tokenList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

class FileImporter
implements Importer {
    boolean fixedLength = false;
    String delimiter = ",";
    Vector lengths = null;
    boolean strict = false;
    String curLine = null;
    boolean headersPresent = false;
    BufferedReader dataSource = null;
    int numRows;
    tokenList tokens;
    matchedTokens matched;
    int[] offsets = null;
    boolean moreAvailable;
    Table tab;
    Vector cols;

    File getFilePath(String string, String string2) throws SQLException {
        String string3 = "Unable to find file: " + string + "\n";
        File file = new File(string);
        String string4 = file.getAbsolutePath();
        String string5 = file.getName();
        try {
            String string6 = file.getCanonicalPath();
            file = new File(string6);
        }
        catch (IOException iOException) {
            throw new SQLException(string3 + iOException.toString());
        }
        if (file.exists()) {
            return file;
        }
        if (string4.length() == string.length()) {
            throw new SQLException(string3);
        }
        string = string2 + File.separatorChar + string5;
        file = new File(string);
        if (file.exists()) {
            return file;
        }
        throw new SQLException(string3);
    }

    void getAutoLine(Vector vector, int n) {
        Integer n2 = new Integer(n - 1);
        int n3 = 1;
        while (n3 < this.cols.size()) {
            Column column = (Column)this.cols.elementAt(n3);
            Object object = column.toObject(n2);
            vector.setElementAt(object, n3);
            ++n3;
        }
        if (n >= this.numRows) {
            this.moreAvailable = false;
        }
    }

    public void getNextRow(Vector vector, int n) throws SQLException, IOException {
        if (this.cols == null) {
            this.cols = this.tab.getColList();
        }
        if (this.numRows > 0) {
            this.getAutoLine(vector, n);
            return;
        }
        this.curLine = this.dataSource.readLine();
        if (!this.fixedLength) {
            if (this.tokens == null) {
                this.tokens = new tokenList("", false);
            }
            this.tokens.reset(this.curLine, this.delimiter, this.dataSource, this.strict);
        }
        int n2 = 1;
        while (n2 < vector.size()) {
            CurrencyColumn currencyColumn;
            String string = null;
            Column column = (Column)this.cols.elementAt(n2);
            if (!this.fixedLength) {
                string = this.tokens.getNext();
            } else {
                int n3 = this.offsets[n2 + 1];
                int n4 = this.curLine.length();
                if (n3 > n4) {
                    n3 = n4;
                }
                if (this.offsets[n2] < n4) {
                    string = this.curLine.substring(this.offsets[n2], n3);
                    if (column.type != 3) {
                        string = string.trim();
                    }
                } else {
                    string = null;
                }
            }
            if (column.type == 6 && (currencyColumn = (CurrencyColumn)column).isUnitChar(string)) {
                string = this.tokens.getNext();
            }
            if (string == null) {
                vector.setElementAt(null, n2);
            } else if (string.equals(this.delimiter)) {
                vector.setElementAt(null, n2);
            } else {
                vector.setElementAt(string, n2);
                if (!this.fixedLength) {
                    this.tokens.getNext();
                }
            }
            ++n2;
        }
        this.moreAvailable = this.dataSource.ready();
    }

    public boolean hasMoreRows() throws SQLException, IOException {
        return this.moreAvailable;
    }

    public void close() throws SQLException, IOException {
        this.dataSource.close();
    }

    public String getCurLine() throws SQLException, IOException {
        return this.curLine;
    }

    FileImporter(Table table, String string, String string2, Transaction transaction, Database database) throws SQLException, IOException {
        int n;
        boolean bl;
        FileReader fileReader;
        File file;
        BufferedReader bufferedReader = null;
        if (string2 != null) {
            file = this.getFilePath(string2, database.propertiesPath);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        file = this.getFilePath(string, database.propertiesPath);
        fileReader = new FileReader(file);
        this.dataSource = new BufferedReader(fileReader);
        String string3 = file.getName();
        this.tab = table;
        boolean bl2 = bl = table.getColCount() > 1;
        if (!bl && bufferedReader == null) {
            throw new SQLException("IMPORT must use a schema file for non-existent tables");
        }
        if (bufferedReader != null) {
            n = 0;
            while (bufferedReader.ready() && n < 2) {
                String string4;
                if (this.matched != null) {
                    this.matched.finalize();
                }
                this.curLine = bufferedReader.readLine();
                this.tokens = new tokenList(this.curLine, false);
                if (this.tokens.size() == 0) continue;
                this.matched = new matchedTokens(this.tokens, Database.SQLsyntax, database);
                if (n == 0) {
                    String string5;
                    if (!this.matched.containsKey("header") || !(string4 = (string5 = (String)this.matched.get("tableName")) + "." + (String)this.matched.get("extension")).equalsIgnoreCase(string3)) continue;
                    n = 1;
                    continue;
                }
                if (n != 1) continue;
                if (this.matched.containsKey("header")) {
                    n = 2;
                    break;
                }
                if (this.matched.containsKey("header_spec") && this.matched.containsKey("TRUE")) {
                    this.headersPresent = true;
                }
                if (this.matched.containsKey("format_spec")) {
                    if (this.matched.containsKey("FIXEDLENGTH")) {
                        this.fixedLength = true;
                        this.lengths = new Vector(10, 5);
                    }
                    if (this.matched.containsKey("DELIMITED")) {
                        this.delimiter = (String)this.matched.get("delimiter");
                    }
                    if (this.matched.containsKey("CSVDELIMITED")) {
                        this.delimiter = ",";
                    }
                    if (this.matched.containsKey("TABDELIMITED")) {
                        this.delimiter = "\t";
                    }
                    if (this.matched.containsKey("AUTO")) {
                        this.delimiter = "AUTO";
                    }
                    if (this.matched.containsKey("STRICT")) {
                        this.strict = true;
                    }
                }
                if (!this.matched.containsKey("col_spec")) continue;
                int n2 = 1;
                if (this.matched.containsKey("WIDTH")) {
                    string4 = (String)this.matched.get("length");
                    n2 = Integer.parseInt(string4);
                    if (this.fixedLength) {
                        this.lengths.addElement(new Integer(n2));
                    }
                }
                if (bl) continue;
                string4 = (String)this.matched.get("colname");
                if (this.matched.containsKey("BYTE") || this.matched.containsKey("BIT")) {
                    new ByteColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("INTEGER")) {
                    new IntegerColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("DATE")) {
                    new DateColumn(table, string4, transaction.dateFormat);
                    continue;
                }
                if (this.matched.containsKey("CHAR")) {
                    new StringColumn(table, string4, n2);
                    continue;
                }
                if (this.matched.containsKey("CURRENCY")) {
                    new CurrencyColumn(table, string4, transaction.currencySymbol, transaction.currencyDecimal);
                    continue;
                }
                if (this.matched.containsKey("SHORT")) {
                    new IntegerColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("LONG")) {
                    new LongColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("FLOAT") || this.matched.containsKey("SINGLE")) {
                    new FloatColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("DOUBLE")) {
                    new DoubleColumn(table, string4);
                    continue;
                }
                if (this.matched.containsKey("BINARY") || this.matched.containsKey("VARBINARY") || this.matched.containsKey("LONGVARBINARY") || this.matched.containsKey("IMAGE") || this.matched.containsKey("OLE")) {
                    new BlobColumn(table, string4, BlobColumn.BINARY_BLOB);
                    continue;
                }
                if (!this.matched.containsKey("TEXT") && !this.matched.containsKey("LONGCHAR")) continue;
                new BlobColumn(table, string4, BlobColumn.STRING_BLOB);
            }
            if (n == 0) {
                throw new SQLException("No entry in schema, or file not found: " + table.getTableName());
            }
        }
        if (this.matched != null) {
            this.matched.finalize();
        }
        if (this.headersPresent && this.dataSource.ready()) {
            this.curLine = this.dataSource.readLine();
        }
        if (this.fixedLength) {
            n = 0;
            this.offsets = new int[this.lengths.size() + 2];
            int n3 = 1;
            while (n3 < this.offsets.length - 1) {
                this.offsets[n3] = n;
                n += ((Integer)this.lengths.elementAt(n3 - 1)).intValue();
                ++n3;
            }
            this.offsets[this.offsets.length - 1] = n;
            this.lengths = null;
        }
        this.moreAvailable = this.dataSource.ready();
        if (this.delimiter.equals("AUTO")) {
            this.curLine = this.dataSource.readLine();
            this.numRows = Integer.parseInt(this.curLine);
            this.moreAvailable = true;
        }
    }
}

