/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.Database;
import db.Journal;
import db.Table;
import db.Trace;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class Transaction {
    int isolation;
    boolean used;
    long ID;
    Vector blobCols;
    Vector blobOffsets;
    Database dbase;
    Transaction waitTrans;
    Thread waitThread;
    boolean timeoutExpired;
    Vector lockList;
    String dateFormat;
    char currencySymbol;
    int currencyDecimal;
    boolean inTriggers;
    boolean inToString;
    String sql;
    Journal journal;
    Connection con;
    int sqlID;
    long expiryTime;

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.used) {
            throw new SQLException("Cannot set isolation level in mid transaction");
        }
        if (n != 8 && n != 1) {
            throw new SQLException("Unrecognised isolation level: " + n);
        }
        this.isolation = n;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public int allocateSqlID() {
        return ++this.sqlID;
    }

    public int getSqlID() {
        return this.sqlID;
    }

    void deleteBlobs(boolean bl) throws SQLException {
        if (bl) {
            int n = 0;
            while (n < this.blobCols.size()) {
                BlobColumn blobColumn = (BlobColumn)this.blobCols.elementAt(n);
                long l = (Long)this.blobOffsets.elementAt(n);
                blobColumn.deleteBlob(l);
                ++n;
            }
        }
        this.blobCols.removeAllElements();
        this.blobOffsets.removeAllElements();
    }

    public synchronized void commit(int n) throws SQLException {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Committing trans ID " + this.ID + ", callersID=" + n + ", cur ID=" + this.sqlID);
        }
        if (n != this.sqlID) {
            return;
        }
        this.deleteBlobs(true);
        this.freeAllLocks(false);
        if (!this.used) {
            return;
        }
        this.journal.writeTransactionRecord(this, 1164275295, 1, null, null, null);
        this.journal.getNextTransactionID();
        if (this.ID < 1000L) {
            throw new SQLException("Internal error - illegal transaction ID: " + this.ID);
        }
        this.used = false;
        this.journal.updateTransactionCount(-1);
    }

    boolean checkDeadLock(Transaction transaction) {
        if (this.waitTrans == null) {
            return false;
        }
        if (this.waitTrans == transaction) {
            return true;
        }
        return this.waitTrans.checkDeadLock(transaction);
    }

    void addLock(Table table) {
        this.lockList.addElement(table);
    }

    void setWaitTransaction(Transaction transaction) {
        this.waitTrans = transaction;
    }

    int getLockCount() {
        return this.lockList.size();
    }

    void freeAllLocks(boolean bl) throws SQLException {
        int n = this.getLockCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            Table table = (Table)this.lockList.elementAt(n2);
            if (table.lockCount == 1) {
                this.inTriggers = true;
                if (bl) {
                    table.rollbackTriggers(this.ID);
                } else {
                    table.commitTriggers(this.ID);
                }
                this.inTriggers = false;
            }
            table.freeTable();
            --n2;
        }
        this.lockList.removeAllElements();
        this.waitTrans = null;
    }

    boolean obeysLocks() {
        return this.isolation == 8;
    }

    protected void finalize() {
        try {
            if (this.used) {
                this.journal.updateTransactionCount(-1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.inToString) {
            return "End of deadlock chain";
        }
        this.inToString = true;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Trans :");
        stringBuffer.append(this.ID);
        if (this.sql != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.sql);
        }
        stringBuffer.append('\n');
        stringBuffer.append("    Locked tables: ");
        int n = 0;
        while (n < this.lockList.size()) {
            Table table = (Table)this.lockList.elementAt(n);
            stringBuffer.append(table.getTableName());
            stringBuffer.append(' ');
            ++n;
        }
        if (this.lockList.size() == 0) {
            stringBuffer.append("none");
        }
        if (this.waitTrans != null) {
            stringBuffer.append("\n    Waiting on transaction...\n");
            stringBuffer.append(this.waitTrans.toString());
        }
        this.inToString = false;
        return stringBuffer.toString();
    }

    void setSQL(String string) {
        this.sql = string;
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    Connection getConnection() {
        return this.con;
    }

    boolean checkExpired() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (l > this.expiryTime) {
            this.dbase.removeFromTimerQueue(this);
            if (this.waitTrans != null) {
                this.waitTrans = null;
                this.waitThread.interrupt();
            } else {
                this.timeoutExpired = true;
            }
        }
        return bl;
    }

    Transaction(Database database) throws SQLException {
        this.dbase = database;
        this.journal = this.dbase.journal;
        this.lockList = new Vector(10, 10);
        this.isolation = 8;
        this.ID = this.journal.getNextTransactionID();
        if (this.ID < 1000L) {
            throw new SQLException("Internal error - illegal transaction ID: " + this.ID);
        }
        this.blobCols = new Vector(10, 10);
        this.blobOffsets = new Vector(10, 10);
        this.used = false;
        this.journal.addToTransactionList(this);
        this.dateFormat = database.defDateFormat;
        this.currencySymbol = database.defCurrencySymbol;
        this.currencyDecimal = database.defCurrencyDecimal;
    }
}

