/*
 * Decompiled with CFR 0.152.
 */
package de.ix.jspTutorial.model;

import de.ix.jspTutorial.database.DatabaseConnection;
import de.ix.jspTutorial.database.DatabaseException;
import de.ix.jspTutorial.database.DatabaseGenericModifier;
import de.ix.jspTutorial.database.DatabaseGenericObject;
import de.ix.jspTutorial.database.DatabaseRetriever;
import de.ix.jspTutorial.database.I_DatabaseGenericObject;
import de.ix.jspTutorial.model.Customer;
import de.ix.jspTutorial.model.Ingredient;
import de.ix.jspTutorial.model.Order;
import de.ix.jspTutorial.model.PersonalPizza;
import de.ix.jspTutorial.model.Pizza;
import de.ix.jspTutorial.model.PizzaBinder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PizzaAccessor {
    public static String vcid = "$Id:$";
    private DatabaseConnection myConnection;
    private DatabaseRetriever myRetriever;
    private DatabaseGenericModifier myModifier;
    private ServletContext myApplication;
    static /* synthetic */ Class class$de$ix$jspTutorial$model$PizzaAccessor;

    public PizzaAccessor(DatabaseConnection databaseConnection) {
        this.setConnection(databaseConnection);
        this.myRetriever = new DatabaseRetriever(databaseConnection);
    }

    public PizzaAccessor(ServletContext servletContext) {
        String string = "jdbc:idb:" + servletContext.getRealPath("") + "\\WEB-INF\\config\\idb\\jspTutorial.prp";
        Class clazz = class$de$ix$jspTutorial$model$PizzaAccessor != null ? class$de$ix$jspTutorial$model$PizzaAccessor : (class$de$ix$jspTutorial$model$PizzaAccessor = PizzaAccessor.class$("de.ix.jspTutorial.model.PizzaAccessor"));
        synchronized (clazz) {
            try {
                this.myApplication = servletContext;
                this.myConnection = new DatabaseConnection("jdbc.idbDriver", string, "jspTutorial");
                Properties properties = new Properties();
                ((Hashtable)properties).put("user", "jsp");
                ((Hashtable)properties).put("password", "tutorial");
                this.myConnection.connect(properties);
                this.myRetriever = new DatabaseRetriever(this.myConnection);
                this.myModifier = new DatabaseGenericModifier(this.myConnection);
            }
            catch (Exception exception) {
                this.log("Have problems to connect datasource " + string, exception);
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    public synchronized boolean checkCustomer(Customer customer) {
        boolean bl = false;
        try {
            this.myConnection.begin();
            List list = this.myRetriever.retrieve("SELECT * FROM customer WHERE id = " + customer.getId(), "customer", new PizzaBinder());
            boolean bl2 = bl = list != null && list.size() == 1;
            if (bl) {
                Customer customer2 = (Customer)list.get(0);
                customer.set(customer2);
            }
            this.log("Customer " + customer + "--" + bl);
            list = null;
            this.myConnection.commit();
        }
        catch (Exception exception) {
            bl = false;
            try {
                this.myConnection.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Customer generateCustomer(HttpServletRequest httpServletRequest) {
        Customer customer = new Customer();
        customer.setAddress1(httpServletRequest.getParameter("address1"));
        customer.setAddress2(httpServletRequest.getParameter("address2"));
        customer.setEmail(httpServletRequest.getParameter("eMail"));
        customer.setFirstname(httpServletRequest.getParameter("firstname"));
        String string = httpServletRequest.getParameter("id");
        if (string != null) {
            customer.setId(Long.parseLong(string));
        }
        customer.setLastname(httpServletRequest.getParameter("lastname"));
        customer.setTown(httpServletRequest.getParameter("town"));
        customer.setZip(httpServletRequest.getParameter("zip"));
        return customer;
    }

    public DatabaseConnection getConnection() {
        return this.myConnection;
    }

    public void log(String string) {
        this.myApplication.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.myApplication.log(string, throwable);
    }

    public synchronized boolean newCustomer(Customer customer) {
        boolean bl;
        block6: {
            bl = false;
            if (customer == null) break block6;
            try {
                this.myConnection.begin();
                customer.setId(this.myModifier.getNextSequenceNumber());
                DatabaseGenericObject databaseGenericObject = customer.getGenericObject();
                bl = this.myModifier.create(databaseGenericObject, "customer");
                this.log("new Customer " + databaseGenericObject + "--" + bl);
                if (bl) {
                    this.myConnection.commit();
                } else {
                    this.myConnection.rollback();
                }
                databaseGenericObject = null;
            }
            catch (Exception exception) {
                bl = false;
                try {
                    this.myConnection.rollback();
                }
                catch (DatabaseException databaseException) {
                    this.log("Can't rollback", databaseException);
                }
            }
        }
        return bl;
    }

    public synchronized boolean newOrder(Customer customer, PersonalPizza personalPizza) {
        if (customer == null || personalPizza == null) {
            throw new RuntimeException("Please setup Customer and Order");
        }
        boolean bl = false;
        try {
            this.myConnection.begin();
            Order order = new Order(this.myModifier.getNextSequenceNumber(), customer, personalPizza, personalPizza.calcTotalPrice());
            this.log("new Order " + order);
            I_DatabaseGenericObject i_DatabaseGenericObject = customer.getGenericObject();
            bl = this.myModifier.update(i_DatabaseGenericObject, "customer", "id");
            this.log("update DB Customer " + i_DatabaseGenericObject + "## " + bl);
            if (bl) {
                i_DatabaseGenericObject = order.getGenericObject();
                bl = this.myModifier.create(i_DatabaseGenericObject, "pizzaorder");
                this.log("new DB Order " + i_DatabaseGenericObject + "## " + bl);
                if (bl) {
                    i_DatabaseGenericObject = order.getPizzaGenericObject();
                    bl = false;
                    bl = this.myModifier.create(i_DatabaseGenericObject, "personalpizza");
                    this.log("new DB Pizza " + i_DatabaseGenericObject + "## " + bl);
                    if (bl) {
                        Iterator iterator = order.getIngredientGenericObjects().iterator();
                        while (bl && iterator.hasNext()) {
                            bl = false;
                            i_DatabaseGenericObject = (I_DatabaseGenericObject)iterator.next();
                            bl = this.myModifier.create(i_DatabaseGenericObject, "personalingredient");
                            this.log("new DB Ingredient " + i_DatabaseGenericObject + "## " + bl);
                        }
                    }
                }
            }
            if (bl) {
                this.myConnection.commit();
            } else {
                this.myConnection.rollback();
            }
            i_DatabaseGenericObject = null;
        }
        catch (Exception exception) {
            this.log("newOrder Error ", exception);
            bl = false;
            try {
                this.myConnection.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
        return bl;
    }

    public synchronized TreeMap readIngredientList(ServletContext servletContext) {
        TreeMap<Long, Ingredient> treeMap = new TreeMap<Long, Ingredient>();
        try {
            this.myConnection.begin();
            List list = this.myRetriever.retrieve("SELECT id,name,price FROM ingredient", "ingredient", new PizzaBinder());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Ingredient ingredient = (Ingredient)iterator.next();
                treeMap.put(new Long(ingredient.getId()), ingredient);
            }
            this.myConnection.commit();
        }
        catch (Exception exception) {
            try {
                this.myConnection.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
        return treeMap;
    }

    public synchronized TreeMap readPizzaList(ServletContext servletContext) {
        TreeMap<Long, Pizza> treeMap = new TreeMap<Long, Pizza>();
        try {
            this.myConnection.begin();
            List list = this.myRetriever.retrieve("SELECT id,name,size,baseprice FROM pizza", "pizza", new PizzaBinder());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Pizza pizza = (Pizza)iterator.next();
                treeMap.put(new Long(pizza.getId()), pizza);
            }
            this.myConnection.commit();
        }
        catch (Exception exception) {
            try {
                this.myConnection.rollback();
            }
            catch (DatabaseException databaseException) {}
        }
        return treeMap;
    }

    public void setConnection(DatabaseConnection databaseConnection) {
        this.myConnection = databaseConnection;
    }
}

