/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.ByteColumn;
import db.Char1Column;
import db.Char1String;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.IntegerColumn;
import db.LongColumn;
import db.Search;
import db.SqlFunction;
import db.StringColumn;
import db.Table;
import db.matchedTokens;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

class expression
implements Cloneable {
    static Integer int0 = new Integer(0);
    static Integer int1 = new Integer(1);
    static final String[] ops = new String[]{"null", "+", "-", "*", "/"};
    static final String[] funcs = new String[]{"null", "COUNT", "MAX", "MIN", "SUM", "AVG"};
    static final String[] rowFuncs = new String[]{"null", "TO_DATE", "UPPER", "LOWER", "TO_NUMBER"};
    static final int NUMERIC = 0;
    static final int STRING = 1;
    static final int OP_PLUS = 1;
    static final int OP_MINUS = 2;
    static final int OP_MUL = 3;
    static final int OP_DIV = 4;
    static final int X_COL = 1;
    static final int X_CONST = 2;
    static final int X_EXPR = 3;
    static final int X_SUBEXPR = 4;
    static final int X_FUNC = 5;
    static final int X_ROWFUNC = 6;
    static final int F_COUNT = 1;
    static final int F_MAX = 2;
    static final int F_MIN = 3;
    static final int F_SUM = 4;
    static final int F_AVG = 5;
    static final int F_TO_DATE = 1;
    static final int F_UPPER = 2;
    static final int F_LOWER = 3;
    static final int F_TO_NUMBER = 4;
    Database dbase;
    Column col;
    String pseudoTblName;
    Object value;
    String name;
    expression subExpr1;
    expression subExpr2;
    int operation;
    int exprType;
    int exprClass;
    int exprSubtype;
    expression otherExpr;
    int colLen;
    int tblIndex;
    int funcClass;
    Object funcValue;
    int funcCount;
    Vector valueList;
    char currencyChar;
    int currencyDecimals;
    String dateFormat;
    boolean strictLiterals;
    boolean exprContainsFunc;
    boolean isGroupBy;
    boolean isNull;
    SqlFunction sqlFunction;
    expression[] funcExprs;
    int[] parameterTypes;
    int oldExprClass;
    expression oldSubExpr1;
    Object oldValue;

    int getMinTableIndex() {
        int n;
        int n2 = Integer.MAX_VALUE;
        if (this.col != null) {
            n2 = this.tblIndex;
        }
        if (this.subExpr1 != null && (n = this.subExpr1.getMinTableIndex()) < n2) {
            n2 = n;
        }
        if (this.subExpr2 != null && (n = this.subExpr2.getMinTableIndex()) < n2) {
            n2 = n;
        }
        return n2;
    }

    boolean stringToNumber(String string) {
        Object object;
        Object object2;
        String string2 = null;
        if (this.otherExpr != null && (object2 = this.otherExpr.col) != null) {
            if (((Column)object2).type == 5) {
                object = (DateColumn)object2;
                string2 = ((DateColumn)object).preferredParseFormat;
            } else if (((Column)object2).type == 6 && (object = ((Column)object2).toObject(string)) != null) {
                this.exprSubtype = 4;
                this.value = object;
                this.exprClass = 2;
                this.exprType = 0;
                return true;
            }
        }
        if ((object2 = DateColumn.toDate(string2, string, this.dbase.milleniumBoundary, this.dbase.nowMeansTime)) != null) {
            this.exprSubtype = 5;
            this.value = object2;
            this.exprType = 0;
            return true;
        }
        if (this.strictLiterals) {
            return false;
        }
        boolean bl = true;
        try {
            object = new Double(string);
            this.exprType = 0;
            this.exprClass = 2;
            if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                boolean bl2 = false;
                if (this.otherExpr != null && this.otherExpr.exprSubtype == 8) {
                    bl2 = true;
                }
                if (Math.abs((Double)object) < 3.4028234663852886E38 && !bl2) {
                    this.value = new Float((Double)object);
                    this.exprSubtype = 7;
                } else {
                    this.value = object;
                    this.exprSubtype = 8;
                }
            } else {
                Long l = new Long(string);
                if (Math.abs(l) < Integer.MAX_VALUE) {
                    this.value = new Integer(l.intValue());
                    this.exprSubtype = 2;
                } else {
                    this.value = l;
                    this.exprSubtype = 4;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    boolean interpretColumn(Vector vector, Vector vector2, String string, String string2) throws SQLException {
        this.exprClass = 1;
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            Column column;
            Table table = (Table)vector.elementAt(n);
            String string3 = table.getTableName();
            String string4 = (String)vector2.elementAt(n);
            if (this.isGroupBy && string != null) {
                string2 = string + '.' + string2;
                string = null;
            }
            if ((column = table.getColByName(string2, true)) != null && (string == null || string.equalsIgnoreCase(string3) || string.equalsIgnoreCase(string4))) {
                if (bl && column != this.col) {
                    throw new SQLException("Column name is ambiguous: " + string2);
                }
                this.pseudoTblName = string4;
                this.col = column;
                bl = true;
                this.tblIndex = n;
            }
            ++n;
        }
        if (!bl) {
            return false;
        }
        this.value = this.col.getName();
        if (string != null) {
            this.value = string + "." + this.value;
        }
        if (this.col instanceof StringColumn || this.col instanceof BlobColumn) {
            this.exprType = 1;
            this.exprSubtype = this.col.type;
            this.colLen = this.col.getLength();
        } else {
            this.exprSubtype = this.col.type;
            if (this.exprSubtype == 6) {
                CurrencyColumn currencyColumn = (CurrencyColumn)this.col;
                this.currencyChar = currencyColumn.unitChar;
                this.currencyDecimals = currencyColumn.decimalPosn;
            }
            if (this.exprSubtype == 5) {
                DateColumn dateColumn = (DateColumn)this.col;
                this.dateFormat = dateColumn.formatStr;
            }
            if (this.exprSubtype == 9) {
                this.exprSubtype = 2;
            }
        }
        return true;
    }

    void interpretString(String string) {
        this.exprClass = 2;
        this.value = string;
        this.exprType = 1;
        this.colLen = string.length() * 2 + 4;
        if (this.otherExpr != null && this.otherExpr.exprType == 1) {
            return;
        }
        this.stringToNumber(string);
    }

    void constructExpr(matchedTokens matchedTokens2, Vector vector, Vector vector2) throws SQLException {
        this.dbase = matchedTokens2.dbase;
        String string = null;
        matchedTokens2.setSearchDepth(2);
        Object object = matchedTokens2.get("expr_item2");
        if (object != null) {
            matchedTokens2.setSearchDepth(2);
            this.operation = Search.pickString(ops, matchedTokens2);
            Object object2 = matchedTokens2.mark("expr_item");
            this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            matchedTokens2.mark(object2);
            matchedTokens2.mark("expr_item2");
            matchedTokens2.mark("expr_item");
            this.subExpr2 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            if (this.subExpr1.exprType != this.subExpr2.exprType) {
                throw new SQLException("Expressions different types: " + this);
            }
            this.exprType = this.subExpr1.exprType;
            expression expression2 = this.subExpr1;
            if (this.subExpr2.exprSubtype > this.subExpr1.exprSubtype) {
                expression2 = this.subExpr2;
            }
            this.exprSubtype = expression2.exprSubtype;
            this.currencyChar = expression2.currencyChar;
            this.currencyDecimals = expression2.currencyDecimals;
            this.dateFormat = expression2.dateFormat;
            if (this.exprType == 1 && this.operation != 1) {
                throw new SQLException("Operation: " + ops[this.operation] + ", undefined for strings, col: " + this.toString());
            }
            this.exprClass = 3;
            if (this.operation == 4 && this.exprSubtype != 7) {
                this.exprSubtype = 8;
            }
            if (this.subExpr1.exprClass == 2 && this.subExpr2.exprClass == 2) {
                this.value = this.evaluate(null);
                this.exprClass = 2;
                this.subExpr2 = null;
                this.subExpr1 = null;
                return;
            }
            this.value = this.subExpr1.toString() + ops[this.operation] + this.subExpr2.toString();
            return;
        }
        matchedTokens2.mark("expr_item");
        matchedTokens2.setSearchDepth(2);
        if (matchedTokens2.mark("function") != null) {
            matchedTokens2.setSearchDepth(3);
            this.exprClass = 5;
            this.funcClass = Search.pickString(funcs, matchedTokens2);
            if (this.funcClass == 4) {
                this.funcValue = int0;
            }
            String string2 = "";
            if (matchedTokens2.containsKey("DISTINCT")) {
                this.valueList = new Vector(100, 100);
                string2 = "DISTINCT ";
            }
            matchedTokens2.setSearchDepth(1);
            matchedTokens2.mark("expr_item");
            this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
            this.exprType = this.subExpr1.exprType;
            this.exprSubtype = this.subExpr1.exprSubtype;
            this.currencyChar = this.subExpr1.currencyChar;
            this.currencyDecimals = this.subExpr1.currencyDecimals;
            this.dateFormat = this.subExpr1.dateFormat;
            if (this.funcClass == 1) {
                this.exprType = 0;
                this.exprSubtype = 2;
            }
            if (this.exprType == 1) {
                if (this.funcClass == 4 || this.funcClass == 5) {
                    throw new SQLException("Function: " + funcs[this.funcClass] + ", undefined for strings");
                }
                this.colLen = 256;
                if (this.subExpr1.col != null) {
                    this.colLen = this.subExpr1.col.getLength();
                }
            }
            this.value = funcs[this.funcClass] + "(" + string2 + this.subExpr1.toString() + ")";
        } else if (matchedTokens2.mark("rowfunc") != null) {
            int n;
            Object object3;
            Object object4;
            this.exprClass = 6;
            this.name = (String)matchedTokens2.get("funcname");
            String string3 = "db." + this.name.toLowerCase();
            try {
                object4 = Class.forName(string3).newInstance();
                this.sqlFunction = (SqlFunction)object4;
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
            object4 = (Vector)matchedTokens2.get("parameter");
            int n2 = 0;
            if (object4 != null) {
                n2 = ((Vector)object4).size();
            }
            this.funcExprs = new expression[n2];
            this.parameterTypes = new int[n2];
            this.name = this.name + "(";
            int n3 = 0;
            while (n3 < n2) {
                matchedTokens2.mark(((Vector)object4).elementAt(n3));
                matchedTokens2.mark("expr");
                object3 = new expression(matchedTokens2, vector, vector2);
                if (n3 > 0) {
                    this.name = this.name + ",";
                }
                this.name = this.name + object3;
                n = ((expression)object3).exprSubtype;
                if (((expression)object3).exprType == 1 && ((expression)object3).exprSubtype != 10) {
                    n = 3;
                }
                if (n == 5) {
                    this.sqlFunction.setSpecialValue(100, new Integer(this.dbase.milleniumBoundary));
                }
                this.funcExprs[n3] = object3;
                this.parameterTypes[n3] = n;
                ++n3;
            }
            this.name = this.name + ")";
            n3 = this.sqlFunction.checkParameters(this.parameterTypes);
            if (n3 == 3 || n3 == 10) {
                this.exprType = 1;
                this.colLen = 64;
                int n4 = 0;
                while (n4 < n2) {
                    if (this.funcExprs[n4].exprType == 1 && this.funcExprs[n4].colLen > this.colLen) {
                        this.colLen = this.funcExprs[n4].colLen;
                    }
                    ++n4;
                }
            } else {
                this.exprType = 0;
                this.exprSubtype = n3;
                if (n3 == 5) {
                    this.sqlFunction.setSpecialValue(100, new Integer(this.dbase.milleniumBoundary));
                    object3 = this.sqlFunction.getSpecialValue(100);
                    if (object3 != null) {
                        try {
                            n = (Integer)object3;
                            this.dateFormat = (String)this.funcExprs[n].value;
                        }
                        catch (Exception exception) {
                            throw new SQLException("Invalid return from " + string3 + ".getSpecialValue");
                        }
                    }
                }
            }
        } else {
            if (matchedTokens2.mark("col_ref") != null) {
                Object object5 = matchedTokens2.get("colName", false);
                if (!(object5 instanceof String)) {
                    this.exprClass = 2;
                    if (object5 instanceof Date) {
                        Date date = (Date)object5;
                        this.value = new Long(date.getTime());
                        this.exprType = 0;
                        this.exprSubtype = 5;
                        return;
                    }
                    if (object5 instanceof StringBuffer) {
                        if (this.otherExpr != null && this.otherExpr.exprType == 0) {
                            this.strictLiterals = false;
                        }
                        this.interpretString(object5.toString());
                        return;
                    }
                    this.value = object5;
                    if (this.value instanceof Number) {
                        if (this.value instanceof Integer) {
                            this.exprSubtype = 2;
                        } else if (this.value instanceof Float) {
                            this.exprSubtype = 7;
                        } else if (this.value instanceof Long) {
                            this.exprSubtype = 4;
                        } else if (this.value instanceof Double) {
                            this.exprSubtype = 8;
                        }
                    }
                    if (this.otherExpr != null) {
                        this.exprType = this.otherExpr.exprType;
                        this.exprSubtype = this.otherExpr.exprSubtype;
                    }
                    return;
                }
                String string4 = (String)object5;
                String string5 = (String)matchedTokens2.get("tableName");
                boolean bl = this.interpretColumn(vector, vector2, string5, string4);
                if (!bl) {
                    bl = this.interpretColumn(vector, vector2, null, string5 + "." + string4);
                }
                if (!bl) {
                    if (string5 != null) {
                        this.interpretString(string5 + "." + string4);
                    } else {
                        this.interpretString(string4);
                    }
                }
                return;
            }
            if (matchedTokens2.mark("expr") != null) {
                this.exprClass = 4;
                this.subExpr1 = new expression(matchedTokens2, vector, vector2, this.isGroupBy);
                this.exprType = this.subExpr1.exprType;
                this.exprSubtype = this.subExpr1.exprSubtype;
                this.currencyChar = this.subExpr1.currencyChar;
                this.currencyDecimals = this.subExpr1.currencyDecimals;
                this.dateFormat = this.subExpr1.dateFormat;
                this.value = this.subExpr1.toString();
                if (this.subExpr1.exprClass == 2) {
                    this.value = this.evaluate(null);
                    this.exprClass = 2;
                    this.subExpr1 = null;
                }
                return;
            }
            if (matchedTokens2.mark("COUNT") != null) {
                this.exprClass = 5;
                this.exprSubtype = 2;
                this.funcClass = 1;
                this.value = "COUNT(*)";
            } else {
                string = (String)matchedTokens2.get("int_lit");
                if (string != null) {
                    this.strictLiterals = false;
                    this.stringToNumber(string);
                    return;
                }
                string = (String)matchedTokens2.get("str_lit");
                if (string != null) {
                    if (!this.strictLiterals) {
                        String string6 = string;
                        String string7 = (String)matchedTokens2.get("str_lit2");
                        if (string7 == null) {
                            int n = string.indexOf(46);
                            if (n != -1) {
                                string7 = string.substring(n + 1);
                                string6 = string.substring(0, n);
                            } else {
                                string6 = null;
                                string7 = string;
                            }
                        }
                        if (this.interpretColumn(vector, vector2, string6, string7)) {
                            return;
                        }
                    }
                    this.interpretString(string);
                    return;
                }
                throw new SQLException("Internal error: could not parse expression" + matchedTokens2);
            }
        }
    }

    Object getNullObj() {
        if (this.col != null) {
            return this.col.getNull();
        }
        if (this.subExpr1 != null) {
            return this.subExpr1.getNullObj();
        }
        if (this.subExpr2 != null) {
            return this.subExpr1.getNullObj();
        }
        return null;
    }

    void reset() {
        if (this.oldExprClass == 5) {
            this.exprClass = 5;
            this.subExpr1 = this.oldSubExpr1;
            this.value = this.oldValue;
            if (this.valueList != null) {
                this.valueList.removeAllElements();
            }
            this.funcCount = 0;
            this.funcValue = null;
            if (this.funcClass == 4) {
                this.funcValue = int0;
            }
        }
        if (this.subExpr1 != null) {
            this.subExpr1.reset();
        }
        if (this.subExpr2 != null) {
            this.subExpr2.reset();
        }
    }

    Object evaluate(int[] nArray) throws SQLException {
        this.isNull = false;
        this.exprContainsFunc = false;
        Object object = null;
        Object object2 = null;
        if (this.subExpr1 != null) {
            object = this.subExpr1.evaluate(nArray);
            if (this.subExpr1.exprContainsFunc) {
                this.exprContainsFunc = true;
            }
        }
        if (this.subExpr2 != null) {
            object2 = this.subExpr2.evaluate(nArray);
            if (this.subExpr2.exprContainsFunc) {
                this.exprContainsFunc = true;
            }
        }
        if (this.exprContainsFunc) {
            return null;
        }
        if (nArray == null && this.exprClass == 5) {
            this.oldExprClass = 5;
            this.oldSubExpr1 = this.subExpr1;
            this.oldValue = this.value;
            Object object3 = "NULL";
            object3 = this.getNullObj();
            this.exprClass = 2;
            this.subExpr1 = null;
            if (this.funcClass == 1) {
                this.funcValue = new Integer(this.funcCount);
            }
            this.value = this.funcValue;
            if (this.value == null) {
                this.value = object3;
            }
            this.exprContainsFunc = true;
            return null;
        }
        switch (this.exprClass) {
            case 6: {
                if (nArray == null) {
                    return null;
                }
                int n = this.funcExprs.length;
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    Object object4 = this.funcExprs[n2].evaluate(nArray);
                    if (object4 instanceof byte[]) {
                        byte[] byArray = (byte[])object4;
                        byte[] byArray2 = new byte[byArray.length - 1];
                        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                        object4 = byArray2;
                    }
                    objectArray[n2] = object4;
                    ++n2;
                }
                object = this.sqlFunction.evaluate(objectArray);
                return object;
            }
            case 1: {
                if (nArray == null) {
                    return null;
                }
                int n = nArray[this.tblIndex];
                object = n == 0 ? this.col.nullObj : this.col.getByRow(n);
                if (this.col.isNull(object)) {
                    this.isNull = true;
                }
                return object;
            }
            case 2: {
                return this.value;
            }
            case 4: {
                this.isNull = this.subExpr1.isNull;
                return object;
            }
            case 5: {
                String string;
                this.exprContainsFunc = true;
                if (object == null) {
                    ++this.funcCount;
                    return null;
                }
                if (this.subExpr1.isNull) {
                    return null;
                }
                if (this.valueList != null) {
                    string = object.toString();
                    int n = 0;
                    while (n < this.valueList.size()) {
                        String string2 = (String)this.valueList.elementAt(n);
                        if (string.equalsIgnoreCase(string2)) {
                            return null;
                        }
                        ++n;
                    }
                    this.valueList.addElement(string);
                }
                ++this.funcCount;
                if (this.funcClass == 1) {
                    return null;
                }
                if (this.funcValue == null) {
                    this.funcValue = object;
                }
                if (this.exprType == 1) {
                    string = (String)object;
                    if (string == StringColumn.NULL) {
                        return null;
                    }
                    String string3 = (String)this.funcValue;
                    if (this.funcClass == 2) {
                        if (string.compareTo(string3) > 0) {
                            this.funcValue = object;
                        }
                    } else if (string.compareTo(string3) < 0) {
                        this.funcValue = object;
                    }
                    return null;
                }
                block8 : switch (this.exprSubtype) {
                    case 4: 
                    case 5: 
                    case 6: {
                        long l = ((Number)object).longValue();
                        long l2 = ((Number)this.funcValue).longValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (l <= l2) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 3: {
                                if (l >= l2) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 5: {
                                l2 += (l - l2) / (long)this.funcCount;
                                this.funcValue = new Long(l2);
                                break;
                            }
                            case 4: {
                                this.funcValue = new Long(l2 += l);
                                break;
                            }
                        }
                        break;
                    }
                    case 7: {
                        float f = ((Number)object).floatValue();
                        float f2 = ((Number)this.funcValue).floatValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (!(f > f2)) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 3: {
                                if (!(f < f2)) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 5: {
                                f2 += (f - f2) / (float)this.funcCount;
                                this.funcValue = new Float(f2);
                                break;
                            }
                            case 4: {
                                this.funcValue = new Float(f2 += f);
                                break;
                            }
                        }
                        break;
                    }
                    case 8: {
                        double d = ((Number)object).doubleValue();
                        double d2 = ((Number)this.funcValue).doubleValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (!(d > d2)) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 3: {
                                if (!(d < d2)) break block8;
                                this.funcValue = object;
                                break;
                            }
                            case 5: {
                                d2 += (d - d2) / (double)this.funcCount;
                                this.funcValue = new Double(d2);
                                break;
                            }
                            case 4: {
                                this.funcValue = new Double(d2 += d);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        int n = ((Number)object).intValue();
                        int n3 = ((Number)this.funcValue).intValue();
                        switch (this.funcClass) {
                            case 2: {
                                if (n <= n3) break block8;
                                this.funcValue = object;
                                break block8;
                            }
                            case 3: {
                                if (n >= n3) break block8;
                                this.funcValue = object;
                                break block8;
                            }
                            case 5: {
                                n3 += (n - n3) / this.funcCount;
                                this.funcValue = new Integer(n3);
                                break block8;
                            }
                            case 4: {
                                this.funcValue = new Integer(n3 += n);
                                break block8;
                            }
                        }
                    }
                }
                return null;
            }
            case 3: {
                if (object == null || object2 == null) {
                    return null;
                }
                if (this.subExpr1.isNull || this.subExpr2.isNull) {
                    this.isNull = true;
                    return int0;
                }
                if (this.exprType == 1) {
                    return (String)object + (String)object2;
                }
                block37 : switch (this.exprSubtype) {
                    case 4: 
                    case 5: 
                    case 6: {
                        long l = ((Number)object).longValue();
                        long l3 = ((Number)object2).longValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Long(l + l3);
                                break block37;
                            }
                            case 2: {
                                this.value = new Long(l - l3);
                                break block37;
                            }
                            case 3: {
                                this.value = new Long(l * l3);
                                break block37;
                            }
                            case 4: {
                                this.value = new Long(l / l3);
                                break block37;
                            }
                        }
                        break;
                    }
                    case 7: {
                        float f = ((Number)object).floatValue();
                        float f3 = ((Number)object2).floatValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Float(f + f3);
                                break block37;
                            }
                            case 2: {
                                this.value = new Float(f - f3);
                                break block37;
                            }
                            case 3: {
                                this.value = new Float(f * f3);
                                break block37;
                            }
                            case 4: {
                                this.value = new Float(f / f3);
                                break block37;
                            }
                        }
                        break;
                    }
                    case 8: {
                        double d = ((Number)object).doubleValue();
                        double d3 = ((Number)object2).doubleValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Double(d + d3);
                                break block37;
                            }
                            case 2: {
                                this.value = new Double(d - d3);
                                break block37;
                            }
                            case 3: {
                                this.value = new Double(d * d3);
                                break block37;
                            }
                            case 4: {
                                this.value = new Double(d / d3);
                                break block37;
                            }
                        }
                        break;
                    }
                    default: {
                        int n = ((Number)object).intValue();
                        int n4 = ((Number)object2).intValue();
                        switch (this.operation) {
                            case 1: {
                                this.value = new Integer(n + n4);
                                break block37;
                            }
                            case 2: {
                                this.value = new Integer(n - n4);
                                break block37;
                            }
                            case 3: {
                                this.value = new Integer(n * n4);
                                break block37;
                            }
                            case 4: {
                                this.value = new Integer(n / n4);
                                break block37;
                            }
                        }
                    }
                }
                if (this.subExpr1.exprClass == 2 && this.subExpr2.exprClass == 2) {
                    this.exprClass = 2;
                    this.subExpr2 = null;
                    this.subExpr1 = null;
                }
                return this.value;
            }
        }
        return null;
    }

    void setName(String string) {
        this.name = string;
    }

    void addToResultsSet(Table table) throws SQLException {
        Column column;
        String string = this.toString();
        Database database = table.dbase;
        String string2 = database.getStringProperty("resultsSetCache", "CACHE_ROWS");
        int n = database.translateCacheCondition(string2);
        int n2 = Integer.parseInt(database.getStringProperty("resultsSetCacheAmount", "100"));
        Column column2 = null;
        if (this.exprType == 1) {
            if (this.exprClass == 1) {
                if (this.col instanceof BlobColumn) {
                    column = (BlobColumn)this.col;
                    column2 = new BlobColumn(table, string, ((BlobColumn)column).binType);
                }
                if (this.col instanceof Char1Column) {
                    column2 = new Char1Column(table, string, this.colLen - 4);
                }
            }
            if (column2 == null) {
                column2 = new StringColumn(table, string, (this.colLen - 4) / 2);
            }
        } else {
            switch (this.exprSubtype) {
                case 1: {
                    column2 = new ByteColumn(table, string);
                    break;
                }
                case 2: {
                    column2 = new IntegerColumn(table, string);
                    break;
                }
                case 7: {
                    column2 = new FloatColumn(table, string);
                    break;
                }
                case 5: {
                    column2 = new DateColumn(table, string, this.dateFormat);
                    break;
                }
                case 6: {
                    column2 = new CurrencyColumn(table, string, this.currencyChar, this.currencyDecimals);
                    break;
                }
                case 8: {
                    column2 = new DoubleColumn(table, string);
                    break;
                }
                case 4: {
                    column2 = new LongColumn(table, string);
                    break;
                }
                case 10: {
                    column2 = new BlobColumn(table, string, BlobColumn.BINARY_BLOB);
                    break;
                }
                default: {
                    throw new SQLException("Internal error: can't create column of type: " + this.exprSubtype);
                }
            }
        }
        column2.setCacheCondition(n, n2);
        column2.setBooleanProperty(6, true);
        column = this.getColumn();
        if (column != null) {
            column2.setUnderlyingTable(column.getTable());
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    String getTableName() throws SQLException {
        String string = null;
        String string2 = null;
        if (this.pseudoTblName != null) {
            return this.pseudoTblName;
        }
        if (this.subExpr1 != null) {
            string = this.subExpr1.getTableName();
        }
        if (this.subExpr2 != null) {
            string2 = this.subExpr2.getTableName();
        }
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        if (string.equalsIgnoreCase(string2)) {
            return string;
        }
        throw new SQLException("Expression uses 2 tables: " + string + " and " + string2);
    }

    Column getColumn() throws SQLException {
        Column column = null;
        Column column2 = null;
        if (this.col != null) {
            return this.col;
        }
        if (this.subExpr1 != null) {
            column = this.subExpr1.getColumn();
        }
        if (this.subExpr2 != null) {
            column2 = this.subExpr2.getColumn();
        }
        if (column2 == null) {
            return column;
        }
        if (column == null) {
            return column2;
        }
        return column;
    }

    boolean isConstant() {
        return this.exprClass == 2;
    }

    void reset(expression expression2) {
        this.col = expression2.col;
        this.value = expression2.value;
        this.subExpr1 = expression2.subExpr1;
        this.subExpr2 = expression2.subExpr2;
        this.exprClass = expression2.exprClass;
        this.funcValue = expression2.funcValue;
        this.funcCount = expression2.funcCount;
        this.valueList = expression2.valueList;
        this.exprContainsFunc = expression2.exprContainsFunc;
    }

    public Object clone() {
        expression expression2 = null;
        try {
            expression2 = (expression)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Error cloning expression");
        }
        return expression2;
    }

    expression(Column column, int n) {
        this.col = column;
        this.dbase = column.dbase;
        this.tblIndex = n;
        this.pseudoTblName = column.getName();
        this.value = this.col.getName();
        if (!this.col.numeric()) {
            this.exprType = 1;
            this.colLen = this.col.getLength();
        } else {
            LongColumn longColumn;
            this.exprSubtype = this.col.type;
            if (this.exprSubtype == 6) {
                longColumn = (CurrencyColumn)this.col;
                this.currencyChar = longColumn.unitChar;
                this.currencyDecimals = longColumn.decimalPosn;
            }
            if (this.exprSubtype == 5) {
                longColumn = (DateColumn)this.col;
                this.dateFormat = ((DateColumn)longColumn).formatStr;
            }
            if (this.exprSubtype == 9) {
                this.exprSubtype = 2;
            }
        }
        this.exprClass = 1;
    }

    expression(Database database, Object object) throws SQLException {
        this.dbase = database;
        this.value = object;
        this.exprClass = 2;
        if (object instanceof String || object instanceof Char1String) {
            this.exprType = 3;
        } else if (object instanceof Integer) {
            this.exprSubtype = 2;
        } else if (object instanceof Long) {
            this.exprSubtype = 4;
        } else if (object instanceof Float) {
            this.exprSubtype = 7;
        } else if (object instanceof Double) {
            this.exprSubtype = 8;
        } else if (object instanceof byte[]) {
            this.exprSubtype = 10;
        } else {
            throw new SQLException("Unknown type for constant value: " + object);
        }
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2) throws SQLException {
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.constructExpr(matchedTokens2, vector, vector2);
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2, expression expression2) throws SQLException {
        this.otherExpr = expression2;
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.constructExpr(matchedTokens2, vector, vector2);
    }

    expression(matchedTokens matchedTokens2, Vector vector, Vector vector2, boolean bl) throws SQLException {
        this.strictLiterals = matchedTokens2.dbase.strictLiterals;
        this.isGroupBy = bl;
        this.constructExpr(matchedTokens2, vector, vector2);
    }
}

