/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Char1Column;
import db.Column;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public class StringColumn
extends Column {
    static String NULL = "\u1234";
    static long time;
    int fieldLength;
    int maxSize;

    public boolean isAutoIncrement() {
        return false;
    }

    public int getMaxWidth() {
        return this.maxSize;
    }

    public boolean isNull(Object object) {
        String string = (String)object;
        return string.equals(NULL);
    }

    static boolean testNull(String string) {
        return string.equals(NULL);
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        super.write(randomAccessFile);
        randomAccessFile.writeInt(this.maxSize);
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        super.close(randomAccessFile);
        randomAccessFile.writeInt(this.maxSize);
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
        super.read(randomAccessFile);
        this.maxSize = randomAccessFile.readInt();
        if (this.maxSize > this.fieldLength && this.maxSize > 4) {
            throw new IOException("Internal error - max string size of " + this.maxSize + " is too big for column " + this.colName + " table " + this.cTable.getTableName());
        }
    }

    void recover(Object object) {
        String string = (String)object;
        if (string.equals(NULL)) {
            string = "NULL";
        }
        if (string.length() > this.maxSize) {
            this.maxSize = string.length();
        }
    }

    Object toObject(Object object) {
        if (object == null) {
            return this.nullObj;
        }
        String string = object instanceof String ? (String)object : object.toString();
        int n = string.length();
        if (n <= this.maxSize) {
            return string;
        }
        if (n > this.fieldLength) {
            return null;
        }
        if (n > this.maxSize) {
            this.maxSize = n;
            if (this.maxSize < 4 && string.equals(NULL)) {
                this.maxSize = 4;
            }
        }
        return string;
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        idbDataOutputStream2.writeString((String)object, this.fieldLength);
    }

    public String toString(Object object) {
        String string = object.equals(NULL) ? "NULL" : object.toString();
        return string;
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (this instanceof Char1Column) {
            return object;
        }
        if (object == null) {
            try {
                int n2 = this.cTable.dataIn.readInt();
                char[] cArray = new char[n2];
                int n3 = 0;
                while (n3 < n2) {
                    cArray[n3] = this.cTable.dataIn.readChar();
                    ++n3;
                }
                this.cTable.freeReadAhead();
                String string = new String(cArray);
                object = string;
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    boolean equalToRow(int n, String string) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                int n2 = this.cTable.dataIn.readInt();
                int n3 = string.length();
                if (n2 != n3) {
                    this.cTable.freeReadAhead();
                    return false;
                }
                char[] cArray = string.toCharArray();
                int n4 = 0;
                while (n4 < n2) {
                    char c = this.cTable.dataIn.readChar();
                    if (cArray[n4] != c) {
                        this.cTable.freeReadAhead();
                        return false;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            this.cTable.freeReadAhead();
            return true;
        }
        return object.toString().equals(string);
    }

    boolean numeric() {
        return false;
    }

    boolean hashPreservesOrder() {
        return false;
    }

    int getHash(Object object) {
        if (this.dbase.altStringHashing) {
            return object.hashCode();
        }
        String string = (String)object;
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        if (n3 < 16) {
            int n4 = n3;
            while (n4 > 0) {
                n = n * 37 + cArray[n2++];
                --n4;
            }
        } else {
            int n5 = n3 / 8;
            int n6 = n3;
            while (n6 > 0) {
                n = n * 39 + cArray[n2];
                n6 -= n5;
                n2 += n5;
            }
        }
        return n;
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        String string = object.toString();
        String string2 = object2.toString();
        boolean bl2 = false;
        switch (n) {
            case 1: {
                bl2 = string.equals(string2);
                break;
            }
            case 4: {
                bl2 = !string.equals(string2);
                break;
            }
            case 7: {
                bl2 = string.compareTo(string2) < 0;
                break;
            }
            case 8: {
                bl2 = string.compareTo(string2) <= 0;
                break;
            }
            case 5: {
                bl2 = string.compareTo(string2) > 0;
                break;
            }
            case 6: {
                bl2 = string.compareTo(string2) >= 0;
                break;
            }
            default: {
                throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
            }
        }
        if (bl2 && !bl && (string.equals(NULL) || string2.equals(NULL))) {
            return false;
        }
        return bl2;
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        if (n2 == 1) {
            return this.equalToRow(n, object.toString());
        }
        return StringColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    StringColumn(Table table, String string, int n) throws SQLException {
        super(table, string, n * 2 + 4);
        this.fieldLength = n;
        this.nullObj = NULL;
        this.type = 3;
        this.requiresRecovery = true;
    }
}

