/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.Database;
import db.IdbVector;
import db.SQLProg;
import db.Table;
import db.Trace;
import db.Transaction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jdbc.idbConnection;
import jdbc.idbDatabaseMetaData;
import jdbc.idbDriver;
import jdbc.idbResultsSet;

public class idbStatement
implements Statement {
    static int counter;
    idbConnection con;
    idbDriver drv;
    Database db;
    SQLProg sql;
    idbDatabaseMetaData meta;
    Table rsTable;
    idbResultsSet results;
    int rowCount;
    boolean closed;
    int maxFieldSize;
    int maxRows;
    boolean escape;
    int queryTimeout;
    int id;
    boolean traceDisabled;
    int sqlID;
    int resultSetConcurrency;
    int fetchDirection;
    int fetchSize;
    IdbVector batch;

    private void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" Stm " + this.id + " " + string);
        }
    }

    void checkClosed() throws SQLException {
        if (this.closed) {
            this.trace("Throwing SQLException: Statement is closed");
            throw new SQLException("Statement is closed");
        }
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.trace("executeQuery " + string);
        this.checkClosed();
        this.traceDisabled = true;
        this.execute(string);
        this.traceDisabled = false;
        int n = 0;
        if (this.rsTable != null) {
            n = this.rsTable.getRowCount();
        }
        this.trace(n + " rows updated");
        return this.results;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.trace("executeUpdate " + string);
        this.checkClosed();
        this.traceDisabled = true;
        this.execute(string);
        this.traceDisabled = false;
        int n = this.rowCount;
        this.trace(n + " rows updated");
        return n;
    }

    void closeResultSet() throws SQLException {
        if (this.results != null && !this.results.closed) {
            this.results.close();
            this.sql = null;
            this.rsTable = null;
            this.results = null;
        }
    }

    public synchronized void close() throws SQLException {
        this.trace("close");
        this.checkClosed();
        this.closed = true;
        if (this.sql != null) {
            this.sql.clearUp();
        }
        this.results = null;
        this.con = null;
        this.drv = null;
        this.db = null;
        this.sql = null;
        this.meta = null;
        this.rsTable = null;
        this.results = null;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.trace("getMaxFieldSize " + this.maxFieldSize);
        this.checkClosed();
        return this.maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.trace("setMaxFieldSize " + n);
        this.checkClosed();
        this.maxFieldSize = n;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.trace("getMaxRows " + this.maxRows);
        this.checkClosed();
        return this.maxRows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.trace("setMaxRows " + n);
        this.checkClosed();
        this.maxRows = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.trace("setEscapeProcessing " + bl);
        this.checkClosed();
        this.escape = bl;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.trace("getQueryTimeout " + this.queryTimeout);
        this.checkClosed();
        return this.queryTimeout;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.trace("setQueryTimeout " + n);
        this.checkClosed();
        this.queryTimeout = n;
    }

    public synchronized void cancel() throws SQLException {
        this.trace("cancel");
        this.checkClosed();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.trace("getWarnings");
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.trace("clearWarnings");
    }

    public synchronized void setCursorName(String string) throws SQLException {
        this.trace("setCursorName " + string);
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.trace("execute " + string);
        this.checkClosed();
        if (!this.escape) {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '{') {
                    throw new SQLException("Escape processing is disabled");
                }
                ++n;
            }
        }
        this.sqlID = this.con.trans.allocateSqlID();
        Transaction transaction = this.con.trans;
        synchronized (transaction) {
            this.closeResultSet();
            this.con.checkCommit(this.sqlID);
            this.sql = new SQLProg(this.db, string, false, this.con.trans);
            this.sql.setMaxRows(this.maxRows);
            boolean bl = this.con.autoCommitSetting;
            this.con.autoCommitSetting = false;
            try {
                this.db.addToTimerQueue(this.con.trans, this.queryTimeout);
                this.sql.execute();
            }
            finally {
                Object var7_5 = null;
                if (this.queryTimeout != 0) {
                    this.db.removeFromTimerQueue(this.con.trans);
                }
                this.con.autoCommitSetting = bl;
                this.sql.clearUp();
            }
        }
        this.rowCount = this.sql.getRowCount();
        if (this.rowCount == -1) {
            this.rsTable = this.sql.getResultSet();
            if (this.rsTable != null) {
                this.results = new idbResultsSet(this, this.rsTable, this.sqlID);
                this.trace(this.rsTable.getRowCount() + " rows returned");
                if (this.resultSetConcurrency == 1007) {
                    this.con.checkCommit(this.sqlID);
                }
                return true;
            }
            this.con.checkCommit(this.sqlID);
        } else {
            this.con.checkCommit(this.sqlID);
            this.trace(this.rowCount + " rows modified");
        }
        return false;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.trace("getResultSet");
        this.checkClosed();
        idbResultsSet idbResultsSet2 = this.results;
        this.results = null;
        return idbResultsSet2;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.trace("getUpdateCount " + this.rowCount);
        this.checkClosed();
        return this.rowCount;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.trace("getMoreResults");
        this.checkClosed();
        this.rowCount = -1;
        return this.results != null;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1008;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new IdbVector(5, 5);
        }
        this.batch.addElement(string);
    }

    public void clearBatch() throws SQLException {
        if (this.batch == null) {
            return;
        }
        this.batch.removeAllElements();
    }

    public int[] executeBatch() throws SQLException {
        int n = this.getBatchCount();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = this.batch.getStringAt(n3);
            boolean bl = false;
            try {
                bl = this.execute(string);
                if (bl) {
                    throw new Exception("Cannot perform queries in batch updates");
                }
                ++n2;
            }
            catch (Exception exception) {
                this.clearBatch();
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                throw new BatchUpdateException(exception.toString(), nArray2);
            }
            ++n3;
        }
        this.clearBatch();
        return nArray;
    }

    public int getBatchCount() {
        if (this.batch == null) {
            return 0;
        }
        return this.batch.size();
    }

    idbStatement(idbConnection idbConnection2, int n) throws SQLException {
        this.con = idbConnection2;
        this.drv = idbConnection.parentDriver;
        this.db = this.con.db;
        this.meta = this.con.meta;
        this.maxFieldSize = this.meta.getMaxRowSize();
        this.maxRows = Integer.MAX_VALUE;
        this.escape = true;
        this.id = ++counter;
        this.resultSetConcurrency = n;
        this.trace("Created");
    }
}

