/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTree;
import db.BitMap;
import db.BlobColumn;
import db.ByteColumn;
import db.Char1Column;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FileImporter;
import db.FloatColumn;
import db.GrowArray;
import db.Importer;
import db.IntegerColumn;
import db.JdbcImporter;
import db.LongColumn;
import db.Search;
import db.StringColumn;
import db.Table;
import db.Trace;
import db.Transaction;
import db.expression;
import db.indexTable;
import db.matchedTokens;
import db.tokenList;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Vector;

public class SQLProg {
    static Integer intZero = new Integer(0);
    Database db;
    boolean endOfSQL = false;
    tokenList tokens;
    matchedTokens matched;
    String originalSQL;
    Table rsTable;
    String rsTableName;
    int rowCount;
    int minTableIndex;
    int maxRows;
    Transaction trans;
    indexTable distinctIndex;
    BTree rootNode;
    boolean isGroupBy;
    Vector groupCols;
    Object[] groupVals;
    boolean doingGroupSelect;
    boolean lastGroup;
    boolean filterScan;
    Table filterRS;
    Table groupTable;
    Search havingSearch;
    Vector havingExps;
    Vector havingExpsCopy;

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public Table getResultSet() {
        return this.rsTable;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getParameterCount() {
        return this.matched.getParameterCount();
    }

    public void clearParameters() {
        this.matched.clearParameters();
    }

    void setResultSetTableName(String string) {
        this.rsTableName = string;
    }

    public void setParam(int n, Object object) throws SQLException {
        this.matched.setParam(n, object);
    }

    public Object[] getParams() {
        return (Object[])this.matched.params.clone();
    }

    public void setParams(Object[] objectArray) {
        this.matched.params = objectArray;
    }

    public void execute() throws SQLException {
        block40: {
            if (this.tokens.size() == 0) {
                return;
            }
            if (Trace.traceIt(2)) {
                if (this.tokens.parameterCount > 0) {
                    Trace.traceOut(this.tokens.getSQL(this.matched));
                } else {
                    Trace.traceOut(this.originalSQL);
                }
            }
            this.db.checkForShutdown();
            if (this.rsTable != null) {
                this.rsTable.dropTable(this.trans);
            }
            this.rsTable = null;
            this.rowCount = -1;
            if (this.tokens.mark() < this.tokens.size()) {
                if (Trace.traceIt(512)) {
                    Trace.traceOut(this.matched.toString());
                }
                StringBuffer stringBuffer = new StringBuffer(this.originalSQL + "\n Don't understand SQL after: \"" + this.tokens.getNext() + "\"");
                if (this.matched.depth > 0) {
                    stringBuffer.append("\n Expected: \"" + this.matched.expected + "\"");
                    stringBuffer.append(" found: \"" + this.matched.found + "\"");
                    if (this.matched.reservedWord) {
                        stringBuffer.append(" (reserved word)");
                    }
                }
                Trace.traceOut(stringBuffer.toString());
                throw new SQLException(stringBuffer.toString());
            }
            if (Trace.traceIt(512)) {
                Trace.traceOut(this.matched.toString());
            }
            this.matched.reset();
            this.matched.setSearchDepth(2);
            try {
                if (this.matched.containsKey("select_statement")) {
                    this.isGroupBy = false;
                    this.filterScan = false;
                    this.lastGroup = false;
                    this.doingGroupSelect = false;
                    this.compile_select(null, null, null);
                    break block40;
                }
                if (this.matched.containsKey("insert_statement")) {
                    this.compile_insert();
                    break block40;
                }
                if (this.matched.containsKey("update_statement")) {
                    this.compile_update();
                    break block40;
                }
                if (this.matched.containsKey("delete_statement")) {
                    this.compile_delete();
                    break block40;
                }
                if (this.matched.containsKey("set_statement")) {
                    this.compile_set();
                    break block40;
                }
                if (this.matched.containsKey("shutdown_statement")) {
                    this.compile_shutdown();
                    break block40;
                }
                if (this.matched.containsKey("commit_statement")) {
                    this.compile_commit();
                    break block40;
                }
                if (this.matched.containsKey("import_statement")) {
                    try {
                        this.compile_import();
                        break block40;
                    }
                    catch (Exception exception) {
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
                Transaction transaction = this.db.sysTrans;
                synchronized (transaction) {
                    try {
                        this.trans.commit(this.trans.getSqlID());
                        this.db.sysTrans.setSQL(this.originalSQL);
                        this.db.lockSystemTables(this.db.sysTrans);
                        if (this.matched.containsKey("create_table_statement")) {
                            this.compile_create_table();
                        } else if (this.matched.containsKey("create_index_statement")) {
                            this.compile_create_index();
                        } else if (this.matched.containsKey("drop_index_statement")) {
                            this.compile_drop_index();
                        } else if (this.matched.containsKey("drop_table_statement")) {
                            this.compile_drop_table();
                        } else if (this.matched.containsKey("alter_table_statement")) {
                            this.compile_alter_table();
                        } else {
                            throw new SQLException("Invalid SQL: " + this.originalSQL);
                        }
                        this.db.sysTrans.commit(this.db.sysTrans.getSqlID());
                        Object var2_5 = null;
                        return;
                    }
                    catch (Exception exception) {
                        this.db.journal.rollback(this.db.sysTrans);
                        Trace.traceOut(exception.toString());
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                this.db.journal.rollback(this.trans);
                Trace.traceOut(throwable.toString());
                if (Trace.traceIt(4)) {
                    throwable.printStackTrace();
                }
                throw new SQLException(throwable.getMessage());
            }
        }
    }

    public void clearUp() {
        this.matched.finalize();
    }

    String addCommaSeperatedStrings(String string, Vector vector, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (string != null) {
            stringBuffer.append(string);
        }
        int n = 0;
        while (n < vector.size()) {
            this.matched.mark(vector.elementAt(n));
            String string3 = (String)this.matched.get("colName");
            stringBuffer.append(string3);
            if (n == vector.size() - 1) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(',');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void compile_alter_table() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table: " + string + ", not found");
        }
        table.lockTable(this.db.sysTrans);
        String string2 = null;
        Column column = null;
        if (this.matched.containsKey("column") && (column = table.getColByName(string2 = (String)this.matched.get("column"))) == null) {
            throw new SQLException("Column, " + string2 + " not found");
        }
        if (this.matched.containsKey("add_col")) {
            if (this.matched.containsKey("PRIMARY")) {
                throw new SQLException("Use ALTER TABLE ADD PRIMARY KEY col_list");
            }
            this.createColumn(table);
            try {
                table.newColAdded();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        } else if (this.matched.containsKey("alter_col")) {
            String string3 = (String)this.matched.get("value");
            column.setProperty(4, string3);
            String string4 = "UPDATE " + this.db.colsTableName + " SET ColDefault = " + string3 + " WHERE ColID = " + column.getColID();
            this.db.execSQL(string4, this.db.sysTrans);
        } else if (this.matched.containsKey("drop_col")) {
            if (this.matched.containsKey("PRIMARY")) {
                String string5 = table.getTableName() + "$pKey";
                String string6 = "DROP INDEX " + string5;
                this.db.execSQL(string6, this.db.sysTrans);
            } else {
                try {
                    table.dropColumn(string2, column);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
        } else if (this.matched.containsKey("table_constraint")) {
            Vector vector = (Vector)this.matched.get("colName");
            if (this.matched.containsKey("PRIMARY")) {
                String string7 = "CREATE INDEX " + string + "$pKey ON " + string + " (";
                string7 = this.addCommaSeperatedStrings(string7, vector, ")");
                this.db.execSQL(string7, this.db.sysTrans);
            } else if (this.matched.containsKey("UNIQUE")) {
                String string8 = "UPDATE " + this.db.colsTableName + " SET Flags = Flags+\".UNIQ\"" + " WHERE Flags NOT LIKE \"%UNIQ%\" AND TableID=" + table.getTableID() + " AND ColName IN (";
                string8 = this.addCommaSeperatedStrings(string8, vector, ")");
                this.db.execSQL(string8, this.db.sysTrans);
                Vector vector2 = table.getColList();
                int n = 0;
                while (n < vector2.size()) {
                    column = (Column)vector2.elementAt(n);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        this.matched.mark(vector.elementAt(n2));
                        String string9 = (String)this.matched.get("colName");
                        if (column.getName().equalsIgnoreCase(string9)) {
                            column.setBooleanProperty(2, true);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    void createColumn(Table table) throws SQLException {
        int n;
        int n2;
        int n3;
        String string = (String)this.matched.get("colName");
        Column column = null;
        if (this.matched.containsKey("INT") || this.matched.containsKey("INTEGER") || this.matched.containsKey("SMALLINT")) {
            column = new IntegerColumn(table, string);
        } else if (this.matched.containsKey("CHAR") || this.matched.containsKey("VARCHAR")) {
            n3 = this.matched.getInt("length");
            column = new StringColumn(table, string, n3);
        } else if (this.matched.containsKey("SMALLCHAR")) {
            n3 = this.matched.getInt("length");
            column = new Char1Column(table, string, n3);
        } else if (this.matched.containsKey("BYTE")) {
            column = new ByteColumn(table, string);
        } else if (this.matched.containsKey("TINYINT")) {
            column = new ByteColumn(table, string);
        } else if (this.matched.containsKey("LONG")) {
            column = new LongColumn(table, string);
        } else if (this.matched.containsKey("NUMERIC") || this.matched.containsKey("DECIMAL")) {
            n3 = 108;
            n2 = 0;
            n = 0;
            if (this.matched.containsKey("precision")) {
                n2 = this.matched.getInt("precision");
            }
            if (this.matched.containsKey("scale")) {
                n = this.matched.getInt("scale");
            }
            column = n != 0 ? new DoubleColumn(table, string) : (n2 == 0 || n2 > 9 ? new LongColumn(table, string) : new IntegerColumn(table, string));
        } else if (this.matched.containsKey("DATE")) {
            column = new DateColumn(table, string, this.trans.dateFormat);
        } else if (this.matched.containsKey("FLOAT") || this.matched.containsKey("SHORT") || this.matched.containsKey("SINGLE")) {
            column = new FloatColumn(table, string);
        } else if (this.matched.containsKey("CURRENCY")) {
            column = new CurrencyColumn(table, string, this.trans.currencySymbol, this.trans.currencyDecimal);
        } else if (this.matched.containsKey("DOUBLE")) {
            column = new DoubleColumn(table, string);
        } else if (this.matched.containsKey("BINARY") || this.matched.containsKey("VARBINARY") || this.matched.containsKey("LONGVARBINARY") || this.matched.containsKey("IMAGE") || this.matched.containsKey("OLE")) {
            column = new BlobColumn(table, string, BlobColumn.BINARY_BLOB);
        } else if (this.matched.containsKey("TEXT") || this.matched.containsKey("LONGCHAR")) {
            column = new BlobColumn(table, string, BlobColumn.STRING_BLOB);
        } else {
            throw new SQLException("Unknown data type");
        }
        String string2 = (String)this.matched.get("default");
        if (string2 != null) {
            column.setProperty(4, string2);
        }
        if (this.matched.containsKey("CACHE")) {
            n2 = this.matched.getInt("rows");
            n = 2;
            if (this.matched.containsKey("ROWS")) {
                n = 1;
            }
            column.setCacheCondition(n, n2);
        }
        if (this.matched.containsKey("NOT")) {
            column.setBooleanProperty(3, true);
        }
        if (this.matched.containsKey("AUTO")) {
            column.setBooleanProperty(5, true);
        }
        if (this.matched.containsKey("UNIQUE")) {
            column.setBooleanProperty(2, true);
        }
        if (this.matched.containsKey("PRIMARY")) {
            column.setBooleanProperty(1, true);
        }
    }

    void compile_drop_index() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("index");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Unable to drop unknown table: " + string);
        }
        if (!(table instanceof indexTable)) {
            throw new SQLException(string + " is not an index table");
        }
        table.lockTable(this.db.sysTrans);
        table.dropTable(this.db.sysTrans);
    }

    void compile_drop_table() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table != null) {
            table.lockTable(this.db.sysTrans);
            table.dropTable(this.db.sysTrans);
        }
    }

    void compile_commit() throws SQLException {
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("COMMIT")) {
            this.trans.commit(this.trans.getSqlID());
        } else {
            this.db.journal.rollback(this.trans);
        }
    }

    void compile_delete() throws SQLException {
        if (this.trans != null && !this.trans.obeysLocks()) {
            throw new SQLException("Transaction " + this.trans.ID + " has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        table.lockTable(this.trans);
        this.rowCount = 0;
        if (!this.matched.containsKey("WHERE")) {
            int n = table.getRowCount();
            int n2 = 1;
            while (n2 <= n) {
                if (!table.rowDeleted(n2)) {
                    table.deleteRow(n2, this.trans);
                    ++this.rowCount;
                }
                ++n2;
            }
        } else {
            int[] nArray;
            Vector<Table> vector = new Vector<Table>(1);
            vector.addElement(table);
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement(table.getTableName());
            Search search = new Search(this, vector, vector2, null, false);
            BitMap bitMap = new BitMap(table.rowCount + 1);
            while ((nArray = search.getRows()) != null) {
                bitMap.setBit(nArray[0]);
            }
            int n = -1;
            nArray = new int[1];
            while ((n = bitMap.nextBitSet(n)) >= 0) {
                nArray[0] = n;
                table.deleteRow(nArray[0], this.trans);
                ++this.rowCount;
            }
        }
    }

    void compile_update() throws SQLException {
        int[] nArray;
        Object object;
        Object object2;
        if (this.trans != null && !this.trans.obeysLocks()) {
            throw new SQLException("Transaction " + this.trans.ID + " has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table " + string + " not found");
        }
        table.lockTable(this.trans);
        Vector<Table> vector = new Vector<Table>(1);
        vector.addElement(table);
        Vector<String> vector2 = new Vector<String>(1);
        vector2.addElement(table.getTableName());
        Search search = new Search(this, vector, vector2, null, false);
        this.matched.setSearchDepth(0);
        Vector vector3 = (Vector)this.matched.get("assignment");
        expression[] expressionArray = new expression[vector3.size()];
        Column[] columnArray = new Column[vector3.size()];
        int[] nArray2 = new int[vector3.size()];
        int n = 0;
        while (n < vector3.size()) {
            this.matched.mark(vector3.elementAt(n));
            object2 = (String)this.matched.get("column");
            columnArray[n] = table.getColByName((String)object2);
            if (columnArray[n] == null) {
                throw new SQLException("Column: " + (String)object2 + ", not found");
            }
            nArray2[n] = table.getRelColPosn((String)object2);
            if (this.matched.containsKey("NULL")) {
                expressionArray[n] = null;
            } else if (this.matched.containsKey("select_statement")) {
                this.matched.mark("select_statement");
                this.compile_select(null, null, null);
                if (this.rsTable.rowCount != 1 || this.rsTable.columnList.size() != 2) {
                    throw new SQLException("SET expression sub-query must return a single row and column");
                }
                object = (Column)this.rsTable.columnList.elementAt(1);
                this.rsTable = null;
                Object object3 = ((Column)object).getByRow(1);
                expressionArray[n] = new expression(this.db, object3);
            } else {
                this.matched.mark("expr");
                expressionArray[n] = new expression(this.matched, vector, vector2, new expression(columnArray[n], n));
            }
            ++n;
        }
        object2 = new BitMap(table.rowCount + 1);
        while ((nArray = search.getRows()) != null) {
            ((BitMap)object2).setBit(nArray[0]);
        }
        this.rowCount = 0;
        object = new Vector<Object>(table.getColCount());
        int n2 = -1;
        nArray = new int[1];
        while ((n2 = ((BitMap)object2).nextBitSet(n2)) >= 0) {
            Object object4;
            table.getRow(n2, (Vector)object);
            int n3 = 0;
            while (n3 < columnArray.length) {
                object4 = null;
                if (expressionArray[n3] != null) {
                    nArray[0] = n2;
                    object4 = expressionArray[n3].evaluate(nArray);
                }
                ((Vector)object).setElementAt(columnArray[n3].toObject(object4), nArray2[n3]);
                ++n3;
            }
            try {
                table.noAutoInc = true;
                table.updating = true;
                table.deleteRow(n2, this.trans);
                table.addRow(object, this.trans);
            }
            finally {
                object4 = null;
                table.noAutoInc = false;
                table.updating = false;
            }
            ++this.rowCount;
        }
    }

    void compile_shutdown() throws SQLException {
        boolean bl = false;
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("NOWAIT")) {
            bl = true;
        }
        this.db.shutdown(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void compile_set() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = null;
        String string2 = null;
        string = (String)this.matched.get("date");
        if (string != null) {
            this.trans.dateFormat = string;
            return;
        }
        string = (String)this.matched.get("LITERALS");
        if (string != null) {
            string = (String)this.matched.get("STRICT_ON");
            this.db.strictLiterals = string != null;
            return;
        }
        string = (String)this.matched.get("DEFAULT_USERNAME");
        if (string != null) {
            this.db.defaultUsername = (String)this.matched.get("uname");
            if (!this.matched.containsKey("DEFAULT_PASSWORD")) return;
            this.db.defaultPassword = (String)this.matched.get("pword");
            return;
        }
        string = (String)this.matched.get("cur");
        if (string != null) {
            this.trans.currencySymbol = string.charAt(0);
            return;
        }
        string = (String)this.matched.get("dec");
        if (string != null) {
            this.trans.currencyDecimal = Integer.parseInt(string);
            return;
        }
        if (this.matched.containsKey("INCREMENT_BASE")) {
            String string3 = (String)this.matched.get("base");
            Long l = null;
            if (string3 != null) {
                l = new Long(string3);
            }
            if (this.matched.containsKey("ALL")) {
                int n = 0;
                while (n < this.db.tblList.size()) {
                    Table table = (Table)this.db.tblList.elementAt(n);
                    int n2 = 1;
                    while (n2 < table.columnList.size()) {
                        Column column = (Column)table.columnList.elementAt(n2);
                        if (column.isAutoIncrement()) {
                            column.setProperty(7, l);
                            try {
                                column.close(table.rndFile);
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException.toString());
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
                return;
            }
            String string4 = (String)this.matched.get("table");
            String string5 = (String)this.matched.get("column");
            Table table = this.db.getTable(string4);
            if (table == null) {
                throw new SQLException("Table " + string4 + " not found");
            }
            Column column = table.getColByName(string5);
            if (column == null) {
                throw new SQLException("Table " + string4 + " column " + string5 + " not found");
            }
            column.setProperty(7, l);
            try {
                column.close(table.rndFile);
                return;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        string = (String)this.matched.get("INCREMENT");
        if (string != null) {
            String string6 = (String)this.matched.get("table");
            Table table = this.db.getTable(string6);
            if (table == null) {
                throw new SQLException("Table " + string6 + " not found");
            }
            table.autoIncOff = this.matched.containsKey("OFF");
            return;
        } else {
            string2 = (String)this.matched.get("filename");
            if (string2 == null) return;
            string = (String)this.matched.get("level");
            int n = 0;
            n = string == null ? 0 : Integer.parseInt(string);
            Trace trace = Trace.getTrace();
            trace.setExport(string2, n + 2048);
            trace.colHeaders = false;
            trace.csvDelimited = true;
            trace.printRowNumbers = false;
            trace.printDelRows = false;
            trace.printControlCol = false;
            trace.traceConsole = 0;
            trace.printSummaryHeader = false;
            trace.includeTime = false;
            if (this.matched.containsKey("SQL")) {
                this.db.exportSQL = 1;
            }
            if (this.matched.containsKey("NO")) {
                this.db.exportSQL = 0;
            }
            if (this.matched.containsKey("TIME")) {
                trace.includeTime = true;
            }
            if (this.matched.containsKey("CONSOLE")) {
                trace.traceConsole = 1;
            }
            if (this.matched.containsKey("COLNAMEHEADER")) {
                trace.colHeaders = true;
            }
            if (this.matched.containsKey("CSVDELIMITED")) {
                trace.csvDelimited = true;
                trace.delimiter = (char)44;
            }
            if (this.matched.containsKey("DELIMITED")) {
                trace.csvDelimited = true;
                string = (String)this.matched.get("delimiter");
                trace.delimiter = string.charAt(0);
            }
            if (this.matched.containsKey("FIXEDLENGTH")) {
                trace.csvDelimited = false;
            }
            if (this.matched.containsKey("ROWNUMBERS")) {
                trace.printRowNumbers = true;
            }
            if (this.matched.containsKey("CONTROLCOL")) {
                trace.printControlCol = true;
            }
            if (this.matched.containsKey("SUMMARYHEADER")) {
                trace.printSummaryHeader = true;
            }
            if (!this.matched.containsKey("QUOTE")) return;
            string = (String)this.matched.get("quoteChar");
            trace.setQuote(string.charAt(0));
        }
    }

    void compile_import() throws SQLException, IOException {
        Object object;
        if (!this.trans.obeysLocks()) {
            throw new SQLException("Transaction " + this.trans.ID + " has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        String string2 = (String)this.matched.get("filename");
        String string3 = (String)this.matched.get("schema");
        Importer importer = null;
        boolean bl = false;
        Table table = this.db.getTable(string);
        if (table == null) {
            table = new Table(string, this.db, this.trans, -1);
        } else {
            bl = true;
        }
        int n = 0;
        if (this.matched.containsKey("BUFFER")) {
            n = this.matched.getInt("rows");
        }
        importer = this.matched.containsKey("URL") ? new JdbcImporter(this.db, string2, string3, table, this.trans, this.db.dbProperties) : new FileImporter(table, string2, string3, this.trans, this.db);
        if (!bl) {
            object = this.db.sysTrans;
            synchronized (object) {
                try {
                    this.db.lockSystemTables(this.db.sysTrans);
                    table.allColumnsAdded(this.db.sysTrans, true);
                    this.db.sysTrans.commit(this.db.sysTrans.getSqlID());
                }
                catch (SQLException sQLException) {
                    this.db.journal.rollback(this.db.sysTrans);
                    throw sQLException;
                }
            }
        }
        if (n > 0) {
            table.createWriteBuffer(n);
        }
        object = new Vector(table.getColCount());
        int n2 = 0;
        while (n2 < table.getColCount()) {
            ((Vector)object).addElement(intZero);
            ++n2;
        }
        n2 = 1;
        while (importer.hasMoreRows()) {
            try {
                importer.getNextRow((Vector)object, n2);
                table.addRowAtRow((Vector)object, table.getRowCount() + 1, this.trans);
            }
            catch (Exception exception) {
                System.out.println("Error importing line " + n2);
                System.out.println(importer.getCurLine());
                exception.printStackTrace();
            }
            if (++n2 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(n2 + " rows imported");
            }
            if (n2 % this.db.transImports == 0) {
                this.trans.commit(this.trans.getSqlID());
            }
            Thread.yield();
        }
        this.rowCount = n2;
        if (n > 0) {
            table.writeWriteBuffer(true);
        }
        importer.close();
    }

    void handleGroupBy() throws SQLException {
        Object object = this.matched.getMark();
        String string = this.rsTableName;
        this.rsTableName = null;
        this.filterScan = true;
        this.compile_select(null, null, null);
        this.filterScan = false;
        this.filterRS = this.rsTable;
        this.rsTable = null;
        this.doingGroupSelect = true;
        this.isGroupBy = true;
        this.groupCols = this.compile_select(null, null, null);
        this.isGroupBy = false;
        this.havingSearch.isGroupBy = false;
        int n = this.groupCols.size();
        this.groupTable = this.rsTable;
        this.rsTable = null;
        int n2 = this.groupTable.rowCount;
        this.groupVals = new Object[n];
        this.rsTableName = string;
        this.matched.mark(object);
        this.lastGroup = true;
        this.compile_select(null, null, null);
        this.filterRS.dropTable(this.trans);
    }

    void addTableToList(String string, Vector vector, Vector vector2) throws SQLException {
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        vector.addElement(table);
        String string2 = (String)this.matched.get("pseudoTable");
        if (string2 == null) {
            string2 = string;
        }
        vector2.addElement(string2);
    }

    void evaluateSelectExpressions(Vector vector, Search search, int n, boolean bl, Vector vector2) throws SQLException {
        Cloneable cloneable;
        Object object;
        int[] nArray;
        boolean bl2;
        boolean bl3 = false;
        int n2 = 0;
        boolean bl4 = true;
        do {
            if (++n2 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(n2 + " rows selected");
            }
            bl3 = false;
            bl2 = true;
            this.distinctIndex = null;
            do {
                nArray = search.getRows();
                if (this.trans.timeoutExpired) {
                    this.trans.timeoutExpired = false;
                    throw new SQLException("Query: " + this.originalSQL + "\nis taking too long.");
                }
                Vector<Object> vector3 = new Vector<Object>(n + 1);
                vector3.addElement(intZero);
                boolean bl5 = false;
                if (nArray == null && bl4) {
                    bl5 = true;
                }
                bl4 = false;
                object = null;
                int n3 = 0;
                while (n3 < vector.size()) {
                    cloneable = (expression)vector.elementAt(n3);
                    object = ((expression)cloneable).evaluate(nArray);
                    if (!((expression)cloneable).isConstant()) {
                        bl2 = false;
                    }
                    if (object == null) {
                        bl5 = true;
                    }
                    if (((expression)cloneable).exprContainsFunc) {
                        bl3 = true;
                    } else if (!bl5 && n3 < n) {
                        vector3.addElement(object);
                    }
                    ++n3;
                }
                if (bl5) continue;
                if (bl) {
                    int[] nArray2;
                    if (this.distinctIndex == null) {
                        this.distinctIndex = new indexTable(this.db, this.rsTable, null);
                    }
                    if ((nArray2 = this.distinctIndex.lookupValue(vector3, true)) != null && this.distinctIndex.checkUnique(nArray2[0], nArray2[1], vector3) != -1) {
                        bl5 = true;
                    }
                }
                if (!bl5 && this.doingGroupSelect && !this.isGroupBy) {
                    bl5 = !this.havingSearch.evaluate(nArray);
                    bl2 = true;
                }
                if (!bl5) {
                    int n4 = 0;
                    n4 = nArray != null ? this.rsTable.addRow(vector3, null, nArray[0]) : this.rsTable.addRow(vector3, null);
                    if (this.distinctIndex != null) {
                        this.distinctIndex.addRowToIndex(n4);
                    }
                    if (this.lastGroup && this.rsTable.numOrdered > 0) {
                        if (this.rsTable.rowCount == 1) {
                            this.rootNode = new BTree(this.rsTable, 0);
                        } else {
                            this.rootNode.add(n4 - 1);
                        }
                        if (this.rsTable.getValidRowCount() > this.maxRows && this.maxRows > 0) {
                            int n5 = this.rootNode.getMax();
                            this.rsTable.deleteRow(n5 + 1, null);
                            this.rsTable.minRowDeleted = this.rsTable.rowCount + 1;
                            this.rootNode = this.rootNode.deleteMax();
                            this.rsTable.underlyingTable = null;
                            this.rsTable.fromTable = null;
                            if (this.distinctIndex != null) {
                                this.distinctIndex.delRowFromIndex(n5 + 1);
                            }
                        }
                    }
                }
                if (this.rsTable.getValidRowCount() >= this.maxRows && this.maxRows > 0 && this.rsTable.numOrdered == 0) break;
            } while (!bl2 && nArray != null);
            search.reset();
        } while (bl3);
        bl2 = false;
        if (search.search1 != null && search.search2 != null) {
            search.search2 = null;
            bl2 = true;
            search.forceEvaluation();
        }
        nArray = new int[vector2.size()];
        int n6 = 0;
        while (n6 < search.rows.length) {
            if (search.rows[n6].usedRows != null) {
                BitMap bitMap = search.rows[n6].usedRows;
                object = search.rows[n6].table;
                int n7 = 0;
                while ((n7 = bitMap.nextBitClear(n7)) <= ((Table)object).rowCount && n7 != -1) {
                    if (((Table)object).rowDeleted(n7)) continue;
                    nArray[n6] = n7;
                    if (bl2 && !search.evaluate(nArray)) continue;
                    cloneable = new Vector(n + 1);
                    ((Vector)cloneable).addElement(intZero);
                    Object object2 = null;
                    int n8 = 0;
                    while (n8 < vector.size()) {
                        expression expression2 = (expression)vector.elementAt(n8);
                        object2 = expression2.evaluate(nArray);
                        ((Vector)cloneable).addElement(object2);
                        ++n8;
                    }
                    this.rsTable.addRow(cloneable, this.trans, nArray[0]);
                }
                nArray[n6] = 0;
            }
            ++n6;
        }
    }

    void addAllCols(Vector vector, Vector vector2, Vector vector3, Table table, int n) {
        Vector vector4 = table.getColList();
        int n2 = 1;
        while (n2 < vector4.size()) {
            Column column = (Column)vector4.elementAt(n2);
            expression expression2 = new expression(column, n);
            if (vector.size() > 1) {
                expression2.setName((String)vector2.elementAt(n) + "." + column.getName());
            }
            vector3.addElement(expression2);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Vector compile_select(Vector var1_1, Vector var2_2, int[] var3_3) throws SQLException {
        var9_4 = null;
        var11_5 = false;
        if (this.doingGroupSelect) {
            var11_5 = true;
        }
        if (this.isGroupBy) {
            this.matched.reset();
            this.matched.mark("group_condition");
        } else {
            this.matched.mark("select_statement");
        }
        var9_4 = this.matched.getMark();
        this.matched.setSearchDepth(2);
        if (!this.filterScan && !this.doingGroupSelect && this.matched.containsKey("group_condition")) {
            this.handleGroupBy();
            return null;
        }
        if (this.matched.containsKey("DISTINCT")) {
            var11_5 = true;
        }
        var12_6 = null;
        var13_7 = null;
        if (!this.doingGroupSelect) {
            var14_8 = (Vector<expression>)this.matched.get("table_ref");
            var15_9 = 0;
            if (var14_8 != null) {
                var15_9 = var14_8.size();
            }
            if (var1_1 != null) {
                var15_9 += var1_1.size();
            }
            this.minTableIndex = var15_9;
            var12_6 = new Vector<E>(var15_9);
            var13_7 = new Vector<E>(var15_9);
            if (var1_1 != null) {
                var16_12 = 0;
                while (var16_12 < var1_1.size()) {
                    var12_6.addElement(var1_1.elementAt(var16_12));
                    var13_7.addElement(var2_2.elementAt(var16_12));
                    ++var16_12;
                }
            }
            var16_12 = 0;
            while (var16_12 < var14_8.size()) {
                block69: {
                    var9_4 = this.matched.mark(var14_8.elementAt(var16_12));
                    if (this.matched.containsKey("select_statement")) {
                        var17_16 = new SQLProg(this.db, this.matched, this.trans);
                        var4_15 = (String)this.matched.get("pseudoTable");
                        var17_16.setResultSetTableName(var4_15);
                        try {
                            var17_16.compile_select(null, null, null);
                            break block69;
                        }
                        catch (Exception var18_22) {
                            var19_27 = this.db.getTable(var4_15);
                            if (var19_27 != null) {
                                this.db.removeTable(var19_27);
                            }
                            var20_34 = 0;
                            ** while (var20_34 < var12_6.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var19_27 = (Table)var12_6.elementAt(var20_34);
                            if (var19_27.addToTableList) {
                                this.db.removeTable(var19_27);
                            }
                            ++var20_34;
                            continue;
                        }
lbl61:
                        // 1 sources

                        throw new SQLException(var18_22.toString());
                    }
                    if (this.matched.containsKey("join_spec")) {
                        this.matched.setSearchDepth(3);
                        this.matched.mark("join_item");
                        var4_15 = (String)this.matched.get("tableName");
                        this.addTableToList(var4_15, var12_6, var13_7);
                        this.matched.mark(var14_8.elementAt(var16_12));
                        this.matched.mark("join_item2");
                        var4_15 = (String)this.matched.get("tableName");
                        this.matched.setSearchDepth(2);
                    } else {
                        var4_15 = (String)this.matched.get("refTable");
                    }
                }
                this.addTableToList(var4_15, var12_6, var13_7);
                this.matched.mark(var9_4);
                ++var16_12;
            }
            this.db.lockTables(var12_6, this.trans);
        } else {
            var12_6 = new Vector<E>(1);
            var13_7 = new Vector<E>(1);
            var12_6.addElement(this.filterRS);
            var13_7.addElement(this.filterRS.getTableName());
        }
        var14_8 = new Vector<expression>(10, 5);
        this.matched.setSearchDepth(1);
        if (this.matched.containsKey("*") || this.filterScan) {
            var15_9 = 0;
            if (var1_1 != null) {
                var15_9 = var1_1.size();
            }
            var16_12 = var15_9;
            while (var16_12 < var12_6.size()) {
                var7_37 = (Table)var12_6.elementAt(var16_12);
                this.addAllCols(var12_6, var13_7, var14_8, var7_37, var16_12);
                ++var16_12;
            }
        } else {
            var15_10 = (Vector)this.matched.get("select_item");
            var16_12 = 0;
            while (var16_12 < var15_10.size()) {
                this.matched.mark(var15_10.elementAt(var16_12));
                var6_38 = (String)this.matched.get("pseudoCol");
                this.matched.mark("expr");
                this.matched.setSearchDepth(3);
                if (this.matched.containsKey("all_cols")) {
                    this.matched.mark("all_cols");
                    var17_16 = (String)this.matched.get("tableName");
                    var18_23 = 0;
                    while (var18_23 < var12_6.size()) {
                        var19_28 = (Table)var12_6.elementAt(var18_23);
                        if (var19_28.getTableName().equalsIgnoreCase((String)var17_16)) {
                            this.addAllCols(var12_6, var13_7, var14_8, var19_28, var18_23);
                        }
                        ++var18_23;
                    }
                } else {
                    var10_39 = new expression(this.matched, var12_6, var13_7, this.doingGroupSelect);
                    if (var6_38 != null) {
                        var10_39.setName(var6_38);
                    }
                    var14_8.addElement(var10_39);
                }
                ++var16_12;
            }
        }
        this.matched.mark(var9_4);
        var15_11 = var14_8.size();
        if (this.rsTable == null) {
            var16_12 = 0;
            var17_17 = true;
            if (this.rsTableName == null) {
                this.rsTableName = this.db.getTmpFile();
            } else {
                var16_12 = 1;
            }
            if (this.matched.containsKey("destTable") && !this.filterScan && !this.isGroupBy) {
                this.rsTableName = (String)this.matched.get("destTable");
                var17_17 = false;
            }
            this.rsTable = new Table(this.rsTableName, this.db, var17_17, (boolean)var16_12);
            if (var12_6.size() == 1) {
                this.rsTable.fromTable = new GrowArray();
                this.rsTable.underlyingTable = (Table)var12_6.elementAt(0);
            }
            this.rsTableName = null;
            var18_23 = 0;
            while (var18_23 < var15_11) {
                var10_39 = (expression)var14_8.elementAt(var18_23);
                var10_39.addToResultsSet(this.rsTable);
                var19_29 = var10_39.getMinTableIndex();
                if (var19_29 < this.minTableIndex) {
                    this.minTableIndex = var19_29;
                }
                ++var18_23;
            }
            try {
                this.rsTable.allColumnsAdded(this.trans, true);
            }
            catch (Exception var18_24) {
                throw new SQLException("IO problem: " + var18_24.toString() + var18_24.getMessage());
            }
        }
        if (!this.doingGroupSelect && !this.filterScan) {
            this.lastGroup = true;
        }
        this.matched.mark(var9_4);
        this.matched.setSearchDepth(1);
        if (this.matched.containsKey("ORDER") && this.lastGroup) {
            var16_13 = (Vector)this.matched.get("order_clause");
            var17_18 = 0;
            while (var17_18 < var16_13.size()) {
                this.matched.mark(var16_13.elementAt(var17_18));
                var18_23 = 0;
                if (this.matched.containsKey("DESC")) {
                    var18_23 = 1;
                }
                var19_30 = (String)this.matched.get("colName");
                var4_15 = null;
                if (this.matched.containsKey("tabName")) {
                    var4_15 = (String)this.matched.get("tabName");
                }
                this.rsTable.addOrderedField(var4_15, var19_30, (boolean)var18_23);
                ++var17_18;
            }
        }
        this.matched.mark(var9_4);
        this.matched.setSearchDepth(2);
        var16_14 = new Search(this, var12_6, var13_7, null, false);
        if (this.isGroupBy) {
            var16_14.isGroupBy = true;
            this.havingSearch = var16_14;
            this.havingExps = var16_14.getExps();
            var17_19 = this.havingExps.size();
            this.havingExpsCopy = new Vector<E>(var17_19);
            var18_23 = 0;
            while (var18_23 < var17_19) {
                var19_31 = (expression)this.havingExps.elementAt(var18_23);
                this.havingExpsCopy.addElement(var19_31.clone());
                ++var18_23;
            }
        } else if (this.doingGroupSelect) {
            var17_20 = 0;
            while (var17_20 < this.havingExps.size()) {
                var14_8.addElement((expression)this.havingExps.elementAt(var17_20));
                ++var17_20;
            }
        }
        if (var3_3 != null) {
            var16_14.setRows(var3_3);
        }
        if ((var17_21 = var16_14.getMinTableIndex()) < this.minTableIndex) {
            this.minTableIndex = var17_21;
        }
        if (this.doingGroupSelect && !this.isGroupBy) {
            var18_25 = new Vector<Column>(this.groupCols.size());
            var19_32 = false;
            var20_35 = 0;
            while (var20_35 < this.groupCols.size()) {
                var10_39 = (expression)this.groupCols.elementAt(var20_35);
                var21_40 = var10_39.getColumn();
                if (var21_40 != null) {
                    var18_25.addElement(var21_40);
                    var16_14.rows[0].col = var21_40;
                    var19_32 = true;
                }
                ++var20_35;
            }
            var20_36 /* !! */  = null;
            if (var19_32) {
                var16_14.rows[0].index = var20_36 /* !! */  = new indexTable(this.db, this.filterRS, var18_25);
                var16_14.rows[0].noCompare = true;
            }
            var11_5 = false;
            var21_41 = this.groupCols.size();
            var22_42 = this.groupTable.rowCount;
            var23_43 = new Vector<E>(var21_41 + 1);
            var24_44 = 1;
            while (var24_44 <= var22_42) {
                this.groupTable.getRow(var24_44, var23_43);
                var25_45 = 0;
                while (var25_45 < this.groupVals.length) {
                    this.groupVals[var25_45] = var23_43.elementAt(var25_45 + 1);
                    ++var25_45;
                }
                var16_14.setGroupConditions(this.groupCols, this.groupVals, var20_36 /* !! */ );
                this.evaluateSelectExpressions(var14_8, var16_14, var15_11, var11_5, var12_6);
                this.havingSearch.resetExps(this.havingExps, this.havingExpsCopy);
                var16_14.reset();
                var16_14.done = false;
                var25_45 = 0;
                while (var25_45 < var14_8.size()) {
                    var10_39 = (expression)var14_8.elementAt(var25_45);
                    var10_39.reset();
                    ++var25_45;
                }
                ++var24_44;
            }
            this.lastGroup = true;
            this.minTableIndex = 0x7FFFFFFF;
        } else {
            this.evaluateSelectExpressions(var14_8, var16_14, var15_11, var11_5, var12_6);
        }
        if (this.lastGroup) {
            if (this.rsTable.numOrdered > 0 && this.rsTable.rowCount > 0) {
                this.rootNode.sortNoSwap();
            }
            var18_26 = this.rsTable.columnList;
            var19_33 = 1;
            while (var19_33 < var18_26.size()) {
                var10_39 = (expression)var14_8.elementAt(var19_33 - 1);
                var8_46 = (Column)var18_26.elementAt(var19_33);
                if (var10_39.exprClass == 1) {
                    var8_46.setBooleanProperty(5, var10_39.col.isAutoIncrement());
                    var8_46.notNull = var10_39.col.notNull;
                } else {
                    var8_46.readOnly = true;
                }
                ++var19_33;
            }
            if (var1_1 == null && !this.rsTable.addToTableList) {
                if (this.db.exportSQL != 0 && this.db.export != null) {
                    this.rsTable.exportText(this.originalSQL);
                } else {
                    this.rsTable.exportText(null);
                }
            }
            var19_33 = 0;
            while (var19_33 < var12_6.size()) {
                var20_36 /* !! */  = (Table)var12_6.elementAt(var19_33);
                if (var20_36 /* !! */ .addToTableList) {
                    this.db.removeTable(var20_36 /* !! */ );
                }
                ++var19_33;
            }
        }
        return var14_8;
    }

    void compile_create_index() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("indexName");
        String string2 = (String)this.matched.get("tableName");
        Vector vector = this.matched.getVector("colName");
        boolean bl = this.matched.containsKey("UNIQUE");
        if (vector.size() == 0) {
            throw new SQLException("No columns defined for index: " + string);
        }
        Table table = this.db.getTable(string2);
        if (table == null) {
            throw new SQLException("Table: " + string2 + ", not found");
        }
        table.lockTable(this.db.sysTrans);
        new indexTable(table, vector, string, bl, this.db.sysTrans, table.partitionNumber);
    }

    void compile_create_table() throws SQLException {
        Object object;
        Vector vector;
        int n;
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("tableName");
        Table table = null;
        int n2 = -1;
        if (this.matched.containsKey("PARTITION")) {
            n2 = this.matched.getInt("partitionNumber");
        }
        table = this.matched.containsKey("TEMPORARY") ? new Table(string, this.db, true, true) : new Table(string, this.db, this.db.sysTrans, n2);
        Vector vector2 = this.matched.getVector("column_def");
        int n3 = 0;
        while (n3 < vector2.size()) {
            this.matched.mark(vector2.elementAt(n3));
            this.createColumn(table);
            ++n3;
        }
        this.matched.mark(null);
        Vector<Object> vector3 = new Vector<Object>(1, 1);
        if (this.matched.containsKey("table_constraint")) {
            Vector vector4 = (Vector)this.matched.get("table_constraint");
            n = 0;
            while (n < vector4.size()) {
                this.matched.mark(vector4.elementAt(n));
                vector = (Vector)this.matched.get("colName");
                if (vector != null) {
                    object = new Vector(5, 5);
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        this.matched.mark(vector.elementAt(n4));
                        String string2 = (String)this.matched.get("colName");
                        Column column = table.getColByName(string2);
                        if (column == null) {
                            throw new SQLException("Column not found: " + string2);
                        }
                        this.matched.mark(vector4.elementAt(n));
                        if (this.matched.containsKey("PRIMARY")) {
                            column.setBooleanProperty(1, true);
                        }
                        if (this.matched.containsKey("UNIQUE")) {
                            ((Vector)object).addElement(string2);
                        }
                        ++n4;
                    }
                    if (((Vector)object).size() > 0) {
                        vector3.addElement(object);
                    }
                }
                ++n;
            }
        }
        try {
            table.allColumnsAdded(this.db.sysTrans, true);
            int n5 = vector3.size();
            if (n5 > 0) {
                n = 0;
                while (n < n5) {
                    vector = (Vector)vector3.elementAt(n);
                    object = string + "$uniq" + n;
                    new indexTable(table, vector, (String)object, true, this.db.sysTrans, n2);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
    }

    void compile_insert() throws SQLException {
        int n;
        Vector vector;
        if (!this.trans.obeysLocks()) {
            throw new SQLException("Transaction " + this.trans.ID + " has read only access.");
        }
        this.matched.mark("insert_statement");
        this.matched.setSearchDepth(3);
        Object object = this.matched.getMark();
        String string = (String)this.matched.get("tableName");
        Hashtable hashtable = null;
        boolean bl = false;
        int n2 = 1;
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        table.lockTable(this.trans);
        Vector vector2 = table.getColList();
        Vector<Object> vector3 = new Vector<Object>(20);
        Vector vector4 = this.matched.getVector("insert_item");
        if (vector4.size() == 1) {
            vector = (Vector)vector4.elementAt(0);
            n = 0;
            while (n < vector.size()) {
                this.matched.mark(vector.elementAt(n));
                vector3.addElement(this.matched.get("value"));
                ++n;
            }
        }
        this.matched.mark(object);
        this.matched.mark("insert_list");
        vector = this.matched.getVector("colName");
        this.matched.mark(object);
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("select_statement")) {
            this.compile_select(null, null, null);
            if (this.rsTable.rowCount == 0) {
                return;
            }
            bl = true;
        }
        this.rowCount = 0;
        do {
            if (bl) {
                this.rsTable.getRow(n2++, vector3);
            }
            if (vector.size() > 0) {
                hashtable = new Hashtable(table.getColCount() * 2 + 1, 0.5f);
                if (bl) {
                    vector3.removeElementAt(0);
                }
                if (vector.size() != vector3.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                n = 0;
                while (n < vector.size()) {
                    String string2 = (String)vector.elementAt(n);
                    if (!table.checkColName(string2)) {
                        throw new SQLException("Unknown column : " + string2);
                    }
                    if (vector3.elementAt(n) == null) {
                        vector3.setElementAt("NULL", n);
                    }
                    hashtable.put(table.getColByName(string2).getName(), vector3.elementAt(n));
                    ++n;
                }
                table.addRow(hashtable, this.trans);
            } else {
                if (!bl) {
                    vector3.insertElementAt(intZero, 0);
                }
                if (vector2.size() != vector3.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                table.addRow(vector3, this.trans);
            }
            if (bl && n2 > this.rsTable.getRowCount()) {
                bl = false;
            }
            ++this.rowCount;
        } while (bl);
    }

    protected void finalize() throws Throwable {
        this.rsTable = null;
    }

    public SQLProg(Database database, String string, boolean bl, Transaction transaction) throws SQLWarning, SQLException {
        database.checkForShutdown();
        if (transaction != null && transaction.inTriggers) {
            throw new SQLException("Cannot access database during commit or rollback");
        }
        this.db = database;
        this.originalSQL = string;
        this.trans = transaction;
        if (this.trans != null) {
            this.trans.setSQL(string);
        }
        this.tokens = new tokenList(string, bl);
        this.rsTable = null;
        this.rowCount = -1;
        this.tokens.reset(0);
        this.matched = new matchedTokens(this.tokens, Database.SQLsyntax, this.db);
    }

    SQLProg(Database database, matchedTokens matchedTokens2, Transaction transaction) {
        this.db = database;
        this.trans = transaction;
        this.rsTable = null;
        this.rowCount = -1;
        this.matched = matchedTokens2;
    }
}

