/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.database ;

import java.util.Enumeration;
import java.util.Hashtable ;
import de.ix.jspTutorial.util.Null ;

/** 
 * Generisches Objekt zur Speicherung mit dem DatabaseGenericModifier.
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>)
 * @version $Id:$
 */
public class DatabaseGenericObject 
  implements I_DatabaseGenericObject{
  	
  /**
   * Version der Klasse
   */
  public static String vcid ="$Id:$";

  /** Daten */
  private  Hashtable myAttributes = new Hashtable();

	/**
	 Konstruktor
	*/
  public DatabaseGenericObject () {
  }
	
	

	/** Dieser Konstruktor erzeugt aus einer Hashtable ein DatabaseGenericObject. 
	 
      @param Hashtable  eine Parameter-Hashtable
	*/
  public DatabaseGenericObject(Hashtable aHashtable) {
  	Enumeration keys = aHashtable.keys ();
  	String key = null;
  	Object value = null;
  	
  	while (keys.hasMoreElements ()) {
      key = (String) keys.nextElement ();
      value = aHashtable.get (key);  	  	
      putValue(key, value);
  	}
  }
	
	/** Diese Methode registriert den angegeben Wert unter dem
      angegebenen Schlssel im internen Dictionary. Ist der Schlssel
      bereits vorhanden, so wird der alte Wert berschrieben.

      @param aValue der Wert
      @param aKey der Schlssel
  */
  public void putValue(String aKey, Object aValue) {
      if(aValue == null)
         aValue = Null.Null();
      myAttributes.put(aKey,aValue);
  }

  /** 
      @param aKey der Schlssel
      @return aValue der Wert
  */
  public Object getValue(String aKey) {
     Object theValue = myAttributes.get(aKey);
      if(theValue == null)
      	return null ;
      if(theValue.equals(Null.Null()))
         return null;
      return theValue;
  }



  /** Diese Methode entfernt den angegebenen Schlssel aus dem
      internen Dictionary.

      @param aKey der Schlssel 
  */
  public void remove(String aKey) {
    myAttributes.remove(aKey);
  }

  public void clear() 
  {
			myAttributes.clear() ;
  }
  
  /** Diese Methode reicht die Methode elements an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Enumeration der Elements 
  */
  public Enumeration elements() { return myAttributes.elements(); }



  /** Diese Methode reicht die Methode keys an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Enumeration der Keys 
  */
  public Enumeration keys() { return myAttributes.keys(); }



  /** Diese Methode reicht die Methode size an die zugrundeliegende
      Hashtable weiter.

      @see java.util.Hashtable

      @return Anzahl der Key/value-Paare
  */
  public int size() { return myAttributes.size(); }




  /** Diese Methode erzeugt eine Kopie des Objektes.

      @return Kopie des Objektes
  */
  public Object clone() { 
    return  new DatabaseGenericObject(this.myAttributes);
  }


  public String toString() {
    StringBuffer sb = new StringBuffer("(");
    for (Enumeration e=myAttributes.keys(); e.hasMoreElements(); ) {
      String key = (String) e.nextElement();
      Object value = myAttributes.get(key);
      sb.append(key);
      sb.append("=");
      sb.append(value);
      if (e.hasMoreElements())
        sb.append(", ");
    }
    sb.append(")");

    return sb.toString();
  }

}


//
// History:
//
// $Log:$
//
//

