/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;
import java.sql.*;

import  de.ix.jspTutorial.database.* ;

/**
 * Factory class for generic objects
 *
 *
 * @author Peter Rossbach (pr@webapp.de)
 * @version $Id:$
 */
public class PizzaBinder implements I_DatabaseBinder
{

   /**
    * version of the source
    */
  public static String vcid = "$Id:$";

	/**
         *
         * Create a object out of a db row for the types
         * <I>pizza</I>, <I>ingredient</I> and <I>customer</I>.
         *
	 * @param aType Type of the object inside the current resultset
	 * @param result current row of the DB cursors
         *
	 * @return a database object
	 */
	public I_DatabaseObject bind(String aType, ResultSet	result)
		throws SQLException
		{
			 if("pizza".equals(aType)) {
			 	  Pizza thePizza = new Pizza(
			 	    result.getLong("id"),
			 	    result.getString("name"),
			 	    result.getString("size"),
			 	    result.getDouble("baseprice")
			 	  ) ;
			 	  return thePizza ;
			 }
			 if("ingredient".equals(aType)) {
			 	  Ingredient theIngredient = new Ingredient(
			 	    result.getLong("id"),
			 	    result.getString("name"),
			 	    result.getDouble("price")
			 	  ) ;
			 	  return theIngredient ;

			 }
			 if("customer".equals(aType)) {
			 	  Customer theCustomer = new Customer(
			 	    result.getLong("id"),
			 	    result.getString("firstname"),
			 	    result.getString("lastname"),
			 	    result.getString("address1"),
			 	    result.getString("address2"),
			 	    result.getString("zip"),
			 	    result.getString("town"),
			 	    result.getString("email")
			 	  ) ;
			 	  return theCustomer ;

			 }
			 throw new RuntimeException("Can't bind " + aType) ;
		}

} // end of class


//
// History
//
// $Log:$
//
//