/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataHandlerDataSource;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;
import javax.activation.URLDataSource;
import javax.activation.UnsupportedDataTypeException;

public class DataHandler
implements Transferable {
    private DataSource dataSource;
    private DataSource objDataSource;
    private Object object;
    private String objectMimeType;
    private CommandMap currentCommandMap;
    private static final DataFlavor[] emptyFlavors = new DataFlavor[0];
    private DataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler;
    private DataContentHandler factoryDCH;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory;
    private String shortType;

    public DataHandler(DataSource dataSource) {
        this.dataSource = dataSource;
        this.oldFactory = factory;
    }

    public DataHandler(Object object, String string) {
        this.object = object;
        this.objectMimeType = string;
        this.oldFactory = factory;
    }

    public DataHandler(URL uRL) {
        this.dataSource = new URLDataSource(uRL);
        this.oldFactory = factory;
    }

    private synchronized void initDefaultCommandMap() {
        if (this.currentCommandMap == null) {
            this.currentCommandMap = CommandMap.getDefaultCommandMap();
        }
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (this.objDataSource == null) {
                this.objDataSource = new DataHandlerDataSource(this);
            }
            return this.objDataSource;
        }
        return this.dataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.dataSource != null) {
            inputStream = this.dataSource.getInputStream();
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            if (dataContentHandler == null) {
                throw new UnsupportedDataTypeException();
            }
            if (dataContentHandler instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)dataContentHandler).getDCH() == null) {
                throw new UnsupportedDataTypeException();
            }
            DataContentHandler dataContentHandler2 = dataContentHandler;
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            new Thread((Runnable)new 1(dataContentHandler2, pipedOutputStream, this), "DataHandler.getInputStream").start();
            inputStream = pipedInputStream;
        }
        return inputStream;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataSource != null) {
            int n;
            InputStream inputStream = null;
            byte[] byArray = new byte[1024];
            inputStream = this.dataSource.getInputStream();
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            return;
        }
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        dataContentHandler.writeTo(this.object, this.objectMimeType, outputStream);
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = null;
        if (this.dataSource != null) {
            outputStream = this.dataSource.getOutputStream();
        }
        return outputStream;
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        DataContentHandler dataContentHandler = null;
        if (factory != this.oldFactory) {
            this.transferFlavors = emptyFlavors;
        }
        if (this.transferFlavors != emptyFlavors) {
            return this.transferFlavors;
        }
        dataContentHandler = this.getDataContentHandler();
        this.transferFlavors = dataContentHandler.getTransferDataFlavors();
        return this.transferFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.dataSource != null) {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            return dataContentHandler.getTransferData(dataFlavor, this.dataSource);
        }
        if (dataFlavor.getRepresentationClass() == this.object.getClass() && dataFlavor.getMimeType() == this.objectMimeType) {
            return this.object;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        this.transferFlavors = emptyFlavors;
        this.dataContentHandler = null;
        this.currentCommandMap = commandMap;
    }

    public CommandInfo[] getPreferredCommands() {
        this.initDefaultCommandMap();
        return this.currentCommandMap.getPreferredCommands(this.getBaseType());
    }

    public CommandInfo[] getAllCommands() {
        this.initDefaultCommandMap();
        return this.currentCommandMap.getAllCommands(this.getBaseType());
    }

    public CommandInfo getCommand(String string) {
        this.initDefaultCommandMap();
        return this.currentCommandMap.getCommand(this.getBaseType(), string);
    }

    public Object getContent() throws IOException {
        DataContentHandler dataContentHandler = this.getDataContentHandler();
        DataSource dataSource = this.getDataSource();
        return dataContentHandler.getContent(dataSource);
    }

    public Object getBean(CommandInfo commandInfo) {
        Object object = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            object = commandInfo.getCommandObject(this, classLoader);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return object;
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String string = this.getBaseType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(string);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            this.initDefaultCommandMap();
            this.dataContentHandler = this.currentCommandMap.createDataContentHandler(string);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    private synchronized String getBaseType() {
        MimeType mimeType = null;
        if (this.shortType == null) {
            try {
                mimeType = new MimeType(this.getContentType());
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
            this.shortType = mimeType.getBaseType();
        }
        return this.shortType;
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory dataContentHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        factory = dataContentHandlerFactory;
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ PipedOutputStream val$pos;
        private final /* synthetic */ DataHandler this$0;
        private final /* synthetic */ DataContentHandler val$fdch;

        public void run() {
            try {
                try {
                    this.val$fdch.writeTo(this.this$0.object, this.this$0.objectMimeType, this.val$pos);
                }
                catch (IOException iOException) {
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.val$pos.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                this.val$pos.close();
            }
            catch (IOException iOException) {}
        }

        /* synthetic */ 1(DataContentHandler dataContentHandler, PipedOutputStream pipedOutputStream, DataHandler dataHandler) {
            this.val$fdch = dataContentHandler;
            this.val$pos = pipedOutputStream;
            this.this$0 = dataHandler;
        }
    }
}

