/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType
implements Externalizable {
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new MimeTypeParameterList();
    }

    public MimeType(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    public MimeType(String string, String string2) throws MimeTypeParseException {
        if (!this.isValidToken(string)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
        if (!this.isValidToken(string2)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string2.toLowerCase();
        this.parameters = new MimeTypeParameterList();
    }

    private void parse(String string) throws MimeTypeParseException {
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n < 0 && n2 < 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n < 0 && n2 >= 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (n >= 0 && n2 < 0) {
            this.primaryType = string.substring(0, n).trim().toLowerCase();
            this.subType = string.substring(n + 1).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList();
        } else if (n < n2) {
            this.primaryType = string.substring(0, n).trim().toLowerCase();
            this.subType = string.substring(n + 1, n2).trim().toLowerCase();
            this.parameters = new MimeTypeParameterList(string.substring(n2));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String string) throws MimeTypeParseException {
        if (!this.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        this.primaryType = string.toLowerCase();
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String string) throws MimeTypeParseException {
        if (!this.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
        this.subType = string.toLowerCase();
    }

    public MimeTypeParameterList getParameters() {
        return this.parameters;
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public void setParameter(String string, String string2) {
        this.parameters.set(string, string2);
    }

    public void removeParameter(String string) {
        this.parameters.remove(string);
    }

    public String toString() {
        return String.valueOf(this.getBaseType()) + this.parameters.toString();
    }

    public String getBaseType() {
        return String.valueOf(this.primaryType) + "/" + this.subType;
    }

    public boolean match(MimeType mimeType) {
        return this.primaryType.equals(mimeType.getPrimaryType()) && (this.subType.equals("*") || mimeType.getSubType().equals("*") || this.subType.equals(mimeType.getSubType()));
    }

    public boolean match(String string) throws MimeTypeParseException {
        return this.match(new MimeType(string));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
        objectOutput.flush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.parse(objectInput.readUTF());
            return;
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IOException(mimeTypeParseException.toString());
        }
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private boolean isValidToken(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (!MimeType.isTokenChar(c)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

