/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Column;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

class ByteColumn
extends Column {
    static final int NULL_VALUE = -128;
    static long time;
    static final int INT_CACHE_SIZE = 10;
    static Integer[] intCache;
    static final char[] digits;
    static final String[] strCache;

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isNull(Object object) {
        Integer n = (Integer)object;
        return n.equals(this.nullObj);
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                if (object == null) {
                    super.setProperty(n, null);
                    return;
                }
                int n2 = Integer.parseInt((String)object);
                if (n2 == -128) {
                    throw new NumberFormatException(object.toString());
                }
                super.setProperty(n, new Integer(n2));
                break;
            }
            default: {
                super.setProperty(n, object);
            }
        }
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
    }

    static Integer getInteger(int n) {
        if (n >= 0 && n < 10) {
            return intCache[n];
        }
        return new Integer(n);
    }

    static Integer getInteger(String string) {
        if (string.length() == 1) {
            return ByteColumn.getInteger(string.charAt(0) - 48);
        }
        return new Integer(string);
    }

    Object toObject(Object object) {
        Integer n;
        if (object == null) {
            return this.nullObj;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return this.nullObj;
            }
            n = ByteColumn.getInteger(string);
        } else {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof Number) {
                int n2 = ((Number)object).intValue();
                n = ByteColumn.getInteger(n2);
            } else {
                return null;
            }
        }
        if (n == -128 && !this.allowAccidentalNulls) {
            return null;
        }
        return n;
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        int n2 = (Integer)object;
        idbDataOutputStream2.writeByte(n2);
    }

    /*
     * Unable to fully structure code
     */
    public String toString(Object var1_1) {
        block3: {
            block4: {
                block2: {
                    var3_2 = ((Number)var1_1).intValue();
                    if (var3_2 != -128) break block2;
                    var2_3 = "NULL";
                    break block3;
                }
                var4_4 = this.dbase.getStringBuffer();
                v0 = var5_5 = var3_2 < 0;
                if (!var5_5) break block4;
                var3_2 = -var3_2;
                ** GOTO lbl17
            }
            if (var3_2 >= 10) ** GOTO lbl17
            return ByteColumn.strCache[var3_2];
lbl-1000:
            // 1 sources

            {
                var4_4.append(ByteColumn.digits[var3_2 % 10]);
                var3_2 /= 10;
lbl17:
                // 3 sources

                ** while (var3_2 >= 10)
            }
lbl18:
            // 1 sources

            var4_4.append(ByteColumn.digits[var3_2 % 10]);
            if (var5_5) {
                var4_4.append('-');
            }
            var2_3 = var4_4.reverse().toString();
            this.dbase.returnStringBuffer(var4_4);
        }
        return var2_3;
    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                byte by = this.cTable.dataIn.readByte();
                this.cTable.freeReadAhead();
                object = new Integer(by);
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
            this.rowCache.add(object, n);
        }
        return object;
    }

    boolean deleteBitSet(int n) throws SQLException {
        int n2 = 0;
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                n2 = this.cTable.dataIn.readByte();
                this.cTable.freeReadAhead();
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
            }
        } else {
            n2 = (Integer)object;
        }
        return (n2 & 1) != 0;
    }

    boolean numeric() {
        return true;
    }

    boolean hashPreservesOrder() {
        return true;
    }

    int getHash(Object object) {
        Number number = (Number)object;
        return number.intValue();
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        int n2 = ((Number)object).intValue();
        int n3 = ((Number)object2).intValue();
        if (!(bl || n2 != -128 && n3 != -128)) {
            return false;
        }
        switch (n) {
            case 1: {
                return n2 == n3;
            }
            case 4: {
                return n2 != n3;
            }
            case 7: {
                return n2 < n3;
            }
            case 8: {
                return n2 <= n3;
            }
            case 5: {
                return n2 > n3;
            }
            case 6: {
                return n2 >= n3;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        return ByteColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    void doOperation() {
    }

    ByteColumn(Table table, String string) throws SQLException, NumberFormatException {
        super(table, string, 1);
        this.type = 1;
        this.nullObj = new Integer(-128);
        if (intCache == null) {
            intCache = new Integer[10];
            int n = 0;
            while (n < 10) {
                ByteColumn.intCache[n] = new Integer(n);
                ++n;
            }
        }
    }

    static {
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        strCache = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    }
}

