/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BitMap;
import db.Column;
import db.Search;
import db.Table;
import db.Trace;
import db.indexTable;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;

class Cursor
extends Observable
implements Observer {
    static final int S_JOIN = 5;
    static final int S_FILTER = 10;
    static final int S_EQ = 50;
    static final int S_INDEX = 100;
    Table table;
    Column col;
    Object val;
    int op;
    int row;
    int firstRow;
    int lastRow;
    int curRow;
    int altRow;
    indexTable index;
    int weighting;
    Column joinColumn;
    Cursor joinCursor;
    int[] rows;
    int rowNum;
    Search search;
    String outstandingException;
    int incPosn;
    int fixedRow;
    boolean cannotBind;
    boolean noCompare;
    BitMap usedRows;
    boolean firstPass = false;

    void prepareOuterJoin() {
        this.usedRows = new BitMap(this.table.rowCount + 1);
    }

    void fixRow(int n) throws SQLException {
        this.fixedRow = n;
        if (this.search != null) {
            this.search.setActive(false);
        }
        this.firstRow = this.lastRow = this.fixedRow;
        this.index = null;
        this.col = null;
        this.curRow = 0;
        this.next();
    }

    void freeForever() throws SQLException {
        if (this.fixedRow != 0) {
            return;
        }
        this.index = null;
        if (this.search != null) {
            this.search.setActive(false);
            this.search = null;
        }
        this.col = null;
        this.cannotBind = true;
        this.firstRow = 1;
        this.row = 1;
        this.curRow = 0;
        this.lastRow = this.table.rowCount;
        this.next();
    }

    int setPosn(int n, int[] nArray) {
        if (this.incPosn != -1) {
            return n + 1;
        }
        this.incPosn = this.joinCursor == null ? n : this.joinCursor.setPosn(n, nArray) - 1;
        nArray[this.incPosn] = this.rowNum;
        return this.incPosn;
    }

    public void update(Observable observable, Object object) {
        Cursor cursor = (Cursor)observable;
        if (cursor.curRow != 0) {
            try {
                this.val = this.joinColumn.getByRow(cursor.curRow);
                this.setBounds();
                this.curRow = 0;
                this.next();
            }
            catch (Exception exception) {
                this.outstandingException = new String("Error fetching row in joined table: " + exception.toString());
            }
        } else {
            this.rows[this.rowNum] = this.curRow = 0;
            this.row = this.firstRow = this.lastRow + 1;
        }
        this.notifyObservers(this);
    }

    boolean forTable(String string) {
        return string.equalsIgnoreCase(this.table.getTableName());
    }

    int getWeighting(Column column, Object object, int n) {
        int n2 = 0;
        n2 = object instanceof Cursor ? 5 : 10;
        if (n == 1) {
            n2 += 50;
        }
        if (column.hasOwnIndex()) {
            n2 += 100;
        }
        return n2;
    }

    void setBounds() throws SQLException {
        if (this.index == null) {
            return;
        }
        if (this.op != 1 && !this.index.hashPreservesOrder) {
            this.index = null;
            return;
        }
        this.noCompare = true;
        if (this.op == 1 && !this.index.hashPreservesOrder) {
            this.noCompare = false;
        }
        this.row = 1;
        this.lastRow = this.index.rowCount;
        if (this.op == 1) {
            int[] nArray = this.index.lookupValue(this.val, true);
            if (nArray == null) {
                this.row = this.lastRow + 1;
            } else {
                this.row = nArray[0];
                this.lastRow = nArray[1];
            }
        } else {
            int[] nArray = this.index.lookupValue(this.val, false);
            if (this.op == 7 || this.op == 8) {
                int[] nArray2;
                if (!this.search.allowNulls && (nArray2 = this.index.lookupValue(this.col.getNull(), false)) != null && nArray2[1] > this.row) {
                    this.row = nArray2[1] + 1;
                }
                if (this.op == 7) {
                    this.lastRow = nArray[0] - 1;
                } else {
                    int n;
                    this.lastRow = nArray[1];
                    if (!this.index.rowDeleted(this.lastRow) && !this.col.compare(n = this.index.getRowByRow(this.lastRow), this.val, 1, false)) {
                        this.lastRow = nArray[0] - 1;
                    }
                }
            } else if (this.op == 5) {
                int n;
                this.row = nArray[1];
                if (!this.index.rowDeleted(this.row) && this.col.compare(n = this.index.getRowByRow(this.row), this.val, 1, false)) {
                    ++this.row;
                }
            } else {
                this.row = nArray[0];
            }
        }
        this.firstRow = this.row;
    }

    boolean checkNestedJoin(Cursor cursor) {
        while (cursor != null) {
            if (cursor.joinCursor == this) {
                return true;
            }
            cursor = cursor.joinCursor;
        }
        return false;
    }

    void setFilter(Column column, Object object, int n, Column column2, Search search) throws SQLException {
        if (this.cannotBind) {
            return;
        }
        if (n == 4) {
            return;
        }
        int n2 = this.getWeighting(column, object, n);
        if (n2 <= this.weighting) {
            return;
        }
        this.weighting = n2;
        this.op = n;
        this.col = column;
        Object object2 = this.val;
        this.val = object;
        if (this.search != null) {
            this.search.setActive(false);
        }
        this.search = search;
        this.search.setActive(true);
        this.index = this.table.getIndex(this.col);
        if (object instanceof Cursor) {
            Cursor cursor = (Cursor)object;
            if (this.checkNestedJoin(cursor)) {
                this.val = object2;
            } else {
                this.joinCursor = cursor;
                this.joinCursor.addObserver(this);
                this.joinColumn = column2;
                this.update(this.joinCursor, null);
            }
        } else {
            if (this.joinCursor != null) {
                this.joinCursor.deleteObserver(this);
            }
            this.setBounds();
            this.curRow = 0;
            this.next();
        }
        this.notifyObservers(this);
    }

    void useCurrentRow() throws SQLException {
        if (this.search != null && !this.noCompare && this.curRow != 0) {
            this.search.setActive(true);
        }
        if (this.rows != null) {
            this.rows[this.rowNum] = this.curRow;
        }
        this.notifyObservers(this);
    }

    void next() throws SQLException {
        block10: {
            if (this.outstandingException != null) {
                throw new SQLException(this.outstandingException, "XOPEN?");
            }
            if (this.fixedRow != 0) {
                // empty if block
            }
            Table table = this.table;
            if (this.index != null) {
                table = this.index;
            }
            this.setChanged();
            if (this.curRow == 0) {
                this.row = this.firstRow - 1;
            }
            int n = this.row;
            while (true) {
                ++this.row;
                if (this.row <= this.lastRow && table.rowDeleted(this.row)) continue;
                if (Trace.traceIt(4096) && this.row % 200 == 0) {
                    Trace.traceOut("First = " + this.firstRow + " Last = " + this.lastRow + " Table = " + table.tableName + " Cur = " + this.row);
                }
                if (this.row > this.lastRow) {
                    this.curRow = 0;
                    this.lastRow = n;
                    break block10;
                }
                if (this.col == null) {
                    this.curRow = this.row;
                    break block10;
                }
                this.curRow = this.row;
                if (this.index != null) {
                    this.curRow = this.index.getRowByRow(this.row);
                    if (this.noCompare) break block10;
                }
                if (this.col.compare(this.curRow, this.val, this.op, this.search.allowNulls)) break;
            }
            if (this.firstPass) {
                this.firstRow = this.row;
                this.firstPass = false;
            }
        }
        this.useCurrentRow();
    }

    boolean empty() {
        if (this.joinCursor != null) {
            return this.joinCursor.empty();
        }
        return this.firstRow > this.lastRow;
    }

    int current() {
        return this.curRow;
    }

    int[] getRowNums() {
        return this.rows;
    }

    Cursor(Table table, int[] nArray, int n) throws SQLException {
        this.table = table;
        this.rows = nArray;
        this.rowNum = n;
        this.firstRow = 1;
        this.row = 1;
        this.curRow = 0;
        this.lastRow = this.table.rowCount;
        this.incPosn = -1;
        this.next();
    }
}

