/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Database;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public class Trace {
    private static int traceLevel;
    static Database dbase;
    static Hashtable threadTrace;
    public static final int TR_EVENT = 1;
    public static final int TR_SQL = 2;
    public static final int TR_ERROR = 4;
    public static final int TR_OPEN = 8;
    public static final int TR_TRANS = 16;
    public static final int TR_PROGRESS = 32;
    public static final int TR_CACHE = 64;
    public static final int TR_MEM = 128;
    public static final int TR_INDEX = 256;
    public static final int TR_PARSE = 512;
    public static final int TR_JDBC = 1024;
    public static final int TR_EXPORT = 2048;
    public static final int TR_TABLESCAN = 4096;
    boolean colHeaders;
    boolean csvDelimited = true;
    boolean printSummaryHeader;
    boolean printRowNumbers;
    boolean printDelRows;
    boolean printControlCol;
    boolean includeTime;
    PrintWriter export;
    int traceConsole;
    Thread owningThread;
    char quote;
    char delimiter;

    void init() {
        this.owningThread = Thread.currentThread();
        Object object = threadTrace;
        synchronized (object) {
            threadTrace.put(this.owningThread, this);
        }
        this.export = Trace.dbase.export;
        this.traceConsole = Trace.dbase.traceConsole;
        object = threadTrace.keys();
        while (object.hasMoreElements()) {
            Thread thread = (Thread)object.nextElement();
            if (thread.isAlive()) continue;
            threadTrace.remove(thread);
        }
    }

    void appendQuote(StringBuffer stringBuffer) {
        if (this.quote != '\u0000') {
            stringBuffer.append(this.quote);
        }
    }

    void setQuote(char c) {
        this.quote = c;
    }

    void checkTraceLevel() {
        if ((traceLevel & 2) == 0) {
            System.out.println("********************************************+++++++++++++++++++++++++++");
            Thread.dumpStack();
        }
    }

    public void traceOutput(String string) {
        Object object;
        if (this.export == null) {
            return;
        }
        String string2 = "";
        if (this.includeTime) {
            object = new Date();
            string2 = DateFormat.getDateInstance().format((Date)object) + " ";
        }
        object = string2 + this.owningThread.getName() + " " + string;
        PrintWriter printWriter = this.export;
        synchronized (printWriter) {
            if (this.traceConsole != 0) {
                System.out.println((String)object);
            }
            this.export.println((String)object);
            this.export.flush();
        }
    }

    static Trace getTrace() {
        Trace trace = null;
        Hashtable hashtable = threadTrace;
        synchronized (hashtable) {
            trace = (Trace)threadTrace.get(Thread.currentThread());
            if (trace == null) {
                trace = new Trace();
            }
        }
        return trace;
    }

    public static void traceOut(String string) {
        if (threadTrace == null) {
            return;
        }
        Trace.getTrace().traceOutput(string);
    }

    public static boolean traceIt(int n) {
        return (n & traceLevel) != 0;
    }

    void setTraceLevel(int n) {
        Hashtable hashtable = threadTrace;
        synchronized (hashtable) {
            if ((traceLevel & 0x800) != 0) {
                n |= 0x800;
            }
            traceLevel = n;
        }
    }

    int getTraceLevel() {
        return traceLevel;
    }

    void setExport(String string, int n) throws SQLException {
        this.setTraceLevel(n);
        if (string == null) {
            if (this.export != null) {
                this.export.close();
            }
            this.export = null;
            return;
        }
        if (string.equalsIgnoreCase("NULL")) {
            if (this.export != null) {
                this.export.close();
            }
            this.export = null;
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
            this.export = new PrintWriter(bufferedOutputStream, false);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
    }

    void shutdown() {
        if (this.export != null) {
            this.export.close();
        }
        Hashtable hashtable = threadTrace;
        synchronized (hashtable) {
            threadTrace.remove(this.owningThread);
        }
    }

    static void close() {
        Trace trace = Trace.getTrace();
        trace.shutdown();
    }

    Trace() {
        this.init();
    }

    Trace(Database database) {
        dbase = database;
        if (threadTrace == null) {
            threadTrace = new Hashtable(20, 0.5f);
            traceLevel = Trace.dbase.traceLevel;
        }
        this.init();
    }
}

