/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Database;
import db.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class idbTrigger {
    public static final int TRIGGER_ON_UPDATE = 1;
    public static final int TRIGGER_ON_DELETE = 2;
    public static final int TRIGGER_ON_ADD = 4;
    public static final int TRIGGER_ON_ROLLBACK = 8;
    public static final int TRIGGER_ON_COMMIT = 16;
    private String tableName;
    private String indexName;
    private int triggerEvents;
    private Database db;
    private Table theTable;

    public String getTableName() {
        return this.tableName;
    }

    public int getEvents() {
        return this.triggerEvents;
    }

    public void onUpdate(Vector vector, long l) throws SQLException {
    }

    public void onAdd(Vector vector, long l) throws SQLException {
    }

    public void onDelete(Vector vector, long l) throws SQLException {
    }

    public void preUpdate(Vector vector, long l) throws SQLException {
    }

    public void onRollback(long l) {
    }

    public void onCommit(long l) {
    }

    public final void delete() {
        this.theTable.removeTrigger(this);
    }

    public Connection getConnection() {
        return this.theTable.lockOwner.getConnection();
    }

    public idbTrigger(String string, int n) throws IllegalArgumentException, SQLException {
        this.tableName = string;
        this.triggerEvents = n;
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            String string2 = this.tableName.substring(0, n2 - 1);
            this.tableName = this.tableName.substring(n2 + 1);
            this.db = Database.getDatabase(string2);
        } else {
            this.db = Database.getDatabaseWithTable(this.tableName);
        }
        if (this.db == null) {
            throw new SQLException("Database containing table " + this.tableName + " could not be found");
        }
        if (this.db.getOpenCount() == 0) {
            throw new SQLException("Database is closed");
        }
        this.theTable = this.db.getTable(string);
        if (this.theTable == null) {
            throw new IllegalArgumentException("Table not found: " + string);
        }
        if (n == 0) {
            throw new IllegalArgumentException("Must specify at least one event to trigger on");
        }
        this.theTable.addTrigger(this);
    }
}

