/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.BlobColumn;
import db.IdbVector;
import db.SQLProg;
import db.Trace;
import db.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import jdbc.idbConnection;
import jdbc.idbResultsSet;
import jdbc.idbStatement;

public class idbPreparedStatement
extends idbStatement
implements PreparedStatement {
    SQLProg sql;

    private void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" Prp " + this.id + " " + string);
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        this.trace("executeQuery");
        this.checkClosed();
        this.traceDisabled = true;
        this.execute();
        this.traceDisabled = false;
        int n = 0;
        if (this.rsTable != null) {
            n = this.rsTable.getRowCount();
        }
        this.trace(n + " rows updated");
        return this.results;
    }

    public synchronized int executeUpdate() throws SQLException {
        this.trace("executeUpdate");
        this.checkClosed();
        this.traceDisabled = true;
        this.execute();
        this.traceDisabled = false;
        int n = this.rowCount;
        if (n == -1) {
            n = 0;
        }
        this.trace(n + " rows updated");
        return n;
    }

    public synchronized boolean execute() throws SQLException {
        this.trace("execute");
        this.checkClosed();
        this.sqlID = this.con.trans.allocateSqlID();
        Transaction transaction = this.con.trans;
        synchronized (transaction) {
            this.closeResultSet();
            this.con.checkCommit(this.sqlID);
            this.sql.setMaxRows(this.maxRows);
            boolean bl = this.con.autoCommitSetting;
            this.con.autoCommitSetting = false;
            try {
                this.db.addToTimerQueue(this.con.trans, this.queryTimeout);
                this.sql.execute();
            }
            finally {
                Object var6_3 = null;
                if (this.queryTimeout != 0) {
                    this.db.removeFromTimerQueue(this.con.trans);
                }
                this.con.autoCommitSetting = bl;
            }
        }
        this.rowCount = this.sql.getRowCount();
        if (this.rowCount == -1) {
            this.rsTable = this.sql.getResultSet();
            if (this.rsTable != null) {
                this.results = new idbResultsSet(this, this.rsTable, this.sqlID);
                this.trace(this.rsTable.getRowCount() + " rows returned");
                if (this.resultSetConcurrency == 1007) {
                    this.con.checkCommit(this.sqlID);
                }
                return true;
            }
        } else {
            this.con.checkCommit(this.sqlID);
            this.trace(this.rowCount + " rows modified");
        }
        return false;
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.trace("setNULL: index=" + n + " sqlType=" + n2);
        this.setObject(n, "NULL");
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.trace("setBoolean: index=" + n + " value=" + bl);
        this.setObject(n, new Boolean(bl));
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.trace("set: index=" + n + " value=" + by);
        this.setObject(n, new Integer(by));
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.trace("set: index=" + n + " value=" + s);
        this.setObject(n, new Integer(s));
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.trace("set: index=" + n + " value=" + n2);
        this.setObject(n, new Integer(n2));
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.trace("set: index=" + n + " value=" + l);
        this.setObject(n, new Long(l));
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.trace("set: index=" + n + " value=" + f);
        this.setObject(n, new Float(f));
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.trace("set: index=" + n + " value=" + d);
        this.setObject(n, new Double(d));
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.trace("set: index=" + n + " value=" + bigDecimal);
        this.setObject(n, bigDecimal);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.trace("set: index=" + n + " value=" + string);
        this.setObject(n, string);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.trace("set: index=" + n + " value=" + byArray);
        this.setObject(n, byArray);
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.trace("set: index=" + n + " value=" + date);
        this.setObject(n, date.toString());
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.trace("set: index=" + n + " value=" + time);
        this.setObject(n, time.toString());
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.trace("set: index=" + n + " value=" + timestamp);
        this.setObject(n, timestamp.toString());
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.trace("set: index=" + n + " value=" + inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * n2 + 1);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(BlobColumn.STRING_BLOB);
            int n3 = 0;
            while (n3 < n2) {
                char c = (char)inputStream.read();
                dataOutputStream.writeChar(c);
                ++n3;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.set(n, byArray);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: \n" + iOException.getMessage());
        }
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.trace("set: index=" + n + " value=" + inputStream);
        this.setAnyStream(n, inputStream, n2, BlobColumn.STRING_BLOB);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.trace("set: index=" + n + " value=" + inputStream);
        this.setAnyStream(n, inputStream, n2, BlobColumn.BINARY_BLOB);
    }

    private void setAnyStream(int n, InputStream inputStream, int n2, byte by) throws SQLException {
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = by;
        try {
            inputStream.read(byArray, 1, n2);
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading from stream: \n" + iOException.getMessage());
        }
        this.set(n, byArray);
    }

    public synchronized void clearParameters() throws SQLException {
        this.sql.clearParameters();
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.trace("set: index=" + n + " value=" + object);
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.trace("set: index=" + n + " value=" + object);
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        this.trace("set: index=" + n + " value=" + object);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = BlobColumn.BINARY_BLOB;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            object = byArray2;
        }
        this.set(n, object);
    }

    private synchronized void set(int n, Object object) throws SQLException {
        this.sql.setParam(n, object);
    }

    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new IdbVector(5, 5);
        }
        this.batch.addElement(this.sql.getParams());
    }

    public int[] executeBatch() throws SQLException {
        int n = this.getBatchCount();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            try {
                Object[] objectArray = (Object[])this.batch.elementAt(n3);
                this.sql.setParams(objectArray);
                bl = this.execute();
                if (bl) {
                    throw new Exception("Cannot perform queries in batch updates");
                }
                ++n2;
            }
            catch (Exception exception) {
                this.clearBatch();
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                throw new BatchUpdateException(exception.toString(), nArray2);
            }
            ++n3;
        }
        this.clearBatch();
        return nArray;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    idbPreparedStatement(idbConnection idbConnection2, String string, int n) throws SQLException {
        super(idbConnection2, n);
        this.sql = new SQLProg(this.db, string, true, idbConnection2.trans);
        this.trace("Created " + string);
    }
}

