/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.Column;
import db.CurrencyColumn;
import db.StringColumn;
import db.Table;
import db.Trace;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class idbResultSetMetaData
implements ResultSetMetaData {
    Table RStable;
    Column[] cols;

    private void trace(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" RS Meta " + string);
        }
    }

    public int getColumnCount() throws SQLException {
        this.trace("getColumnCount");
        return this.RStable.getColCount() - 1;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.trace("isAutoIncrement");
        return this.cols[n].isAutoIncrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.trace("isCaseSensitive");
        return this.cols[n] instanceof StringColumn;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.trace("isSearchable");
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.trace("isCurrency");
        return this.cols[n] instanceof CurrencyColumn;
    }

    public int isNullable(int n) throws SQLException {
        this.trace("isNullable");
        if (this.cols[n].allowsNull()) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        this.trace("isSigned");
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Object object;
        int n2 = 0;
        switch (this.cols[n].getType()) {
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 9;
                break;
            }
            case 4: 
            case 8: {
                n2 = 15;
                break;
            }
            case 3: {
                object = (StringColumn)this.cols[n];
                n2 = ((StringColumn)object).getMaxWidth();
                break;
            }
            default: {
                n2 = 5;
            }
        }
        object = this.cols[n].getName();
        if (((String)object).length() > n2) {
            n2 = ((String)object).length();
        }
        this.trace("getColumnDisplaySize: " + this.cols[n].getName() + "=" + n2);
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.trace("getColumnLabel: " + this.cols[n].getName());
        return this.cols[n].getName();
    }

    public String getColumnName(int n) throws SQLException {
        this.trace("getColumnName");
        return this.cols[n].getName();
    }

    public String getSchemaName(int n) throws SQLException {
        this.trace("getSchemaName");
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        this.trace("getPrecision");
        switch (this.cols[n].getType()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 10;
            }
            case 4: {
                return 19;
            }
            case 7: {
                return 7;
            }
            case 5: {
                return 19;
            }
            case 6: {
                return 19;
            }
            case 8: {
                return 15;
            }
            case 10: {
                return 65536;
            }
            case 3: {
                return (this.cols[n].getLength() - 4) / 2;
            }
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.trace("getScale");
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        this.trace("getTableName");
        return this.RStable.getTableName();
    }

    public String getCatalogName(int n) throws SQLException {
        this.trace("getCatalogName");
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.trace("getColumnType");
        return Column.SQL_TYPES[this.cols[n].getType()];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.trace("getColumnTypeName");
        return Column.typeNames[this.cols[n].getType()];
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.trace("isReadOnly");
        return this.cols[n].isReadOnly();
    }

    public boolean isWritable(int n) throws SQLException {
        this.trace("isWritable");
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.trace("isDefinitelyWritable");
        return this.isWritable(n);
    }

    public String getColumnClassName(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    idbResultSetMetaData(Table table) {
        this.RStable = table;
        Vector vector = this.RStable.getColList();
        this.cols = new Column[vector.size()];
        int n = 1;
        while (n < vector.size()) {
            this.cols[n] = (Column)vector.elementAt(n);
            ++n;
        }
    }
}

