/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class JDBCAppl
extends Applet {
    Connection con;
    Label urlLabel;
    public TextField urlText;
    Button connectButton;
    Label sqlLabel;
    public TextField sqlText;
    Button submitButton;
    Label tableLabel;
    Label outputLabel;
    List tableList;
    public List rowList;
    Label statusLabel;
    Button disconnectButton;
    Button browseButton;
    FileDialog urlBrowse;
    public TextArea displayText;

    void loadDrivers() {
        String[] stringArray = new String[]{"jdbc.idbDriver", "RmiJdbc.RJDriver", "sun.jdbc.odbc.JdbcOdbcDriver"};
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.out.print("Loading driver: " + stringArray[n] + "...");
                Class.forName(stringArray[n]).newInstance();
                System.out.println("success");
            }
            catch (Exception exception) {
                System.out.println("failed. Error=" + exception);
            }
            ++n;
        }
    }

    void setUrl(String string) {
        this.urlText.setText(string);
    }

    public void init() {
        try {
            DriverManager.setLogStream(System.out);
            this.loadDrivers();
            this.urlLabel = new Label("URL:");
            this.urlText = new TextField("jdbc:idb:XXX.prp");
            this.connectButton = new Button("Connect");
            this.sqlLabel = new Label("SQL:");
            this.sqlText = new TextField("");
            this.submitButton = new Button("Submit");
            this.tableLabel = new Label("Tables");
            this.outputLabel = new Label("Results");
            this.tableList = new List();
            this.rowList = new List();
            this.statusLabel = new Label("Enter a URL and click on Connect");
            this.disconnectButton = new Button("Disconnect");
            this.browseButton = new Button("Browse");
            this.displayText = new TextArea(4, 40);
            Panel panel = new Panel();
            Panel panel2 = new Panel();
            this.setLayout(new BorderLayout(5, 5));
            this.add("North", panel);
            this.add("Center", panel2);
            this.add("South", this.displayText);
            panel.setLayout(new BorderLayout(5, 5));
            Panel panel3 = new Panel();
            Panel panel4 = new Panel();
            Panel panel5 = new Panel();
            panel.add("West", panel3);
            panel.add("Center", panel4);
            panel.add("East", panel5);
            panel3.setLayout(new GridLayout(2, 1, 5, 5));
            panel4.setLayout(new GridLayout(2, 1, 5, 5));
            panel5.setLayout(new GridLayout(2, 2, 5, 5));
            panel3.add(this.urlLabel);
            panel3.add(this.sqlLabel);
            panel4.add(this.urlText);
            panel4.add(this.sqlText);
            panel5.add(this.connectButton);
            panel5.add(this.browseButton);
            panel5.add(this.submitButton);
            panel5.add(this.disconnectButton);
            panel2.setLayout(new BorderLayout(5, 5));
            Panel panel6 = new Panel();
            Panel panel7 = new Panel();
            panel2.add("West", panel6);
            panel2.add("Center", panel7);
            panel6.setLayout(new BorderLayout(5, 5));
            panel7.setLayout(new BorderLayout(5, 5));
            panel6.add("North", this.tableLabel);
            panel7.add("North", this.outputLabel);
            panel6.add("Center", this.tableList);
            panel7.add("Center", this.rowList);
            panel7.add("South", this.statusLabel);
            StringBuffer stringBuffer = new StringBuffer(500);
            Properties properties = System.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                stringBuffer.append('=');
                try {
                    stringBuffer.append(System.getProperty(string));
                }
                catch (Exception exception) {
                    stringBuffer.append(exception.toString());
                }
                this.rowList.add(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String addResultstoList(ResultSet resultSet, List list, String string) {
        StringBuffer stringBuffer = new StringBuffer(500);
        try {
            int n;
            list.removeAll();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                stringBuffer.setLength(0);
                n = 1;
                while (n <= n2) {
                    if (string == null || resultSetMetaData.getColumnLabel(n).equalsIgnoreCase(string)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(resultSet.getString(n));
                    }
                    ++n;
                }
                list.add(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
            n = 1;
            while (n <= n2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(resultSetMetaData.getColumnLabel(n));
                ++n;
            }
        }
        catch (Exception exception) {
            this.statusLabel.setText(exception.toString());
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target == this.submitButton || event.target == this.sqlText) {
                this.statusLabel.setText("Executing...");
                Statement statement = this.con.createStatement();
                if (statement.execute(this.sqlText.getText())) {
                    ResultSet resultSet = statement.getResultSet();
                    String string = this.addResultstoList(resultSet, this.rowList, null);
                    this.outputLabel.setText(string);
                    resultSet.close();
                    this.statusLabel.setText("SQL Executed");
                }
                statement.close();
                return true;
            }
            if (event.target == this.connectButton || event.target == this.urlText) {
                this.statusLabel.setText("Connecting...");
                System.out.println("Connecting to " + this.urlText.getText());
                this.con = DriverManager.getConnection(this.urlText.getText());
                DatabaseMetaData databaseMetaData = this.con.getMetaData();
                this.statusLabel.setText("Connected to " + databaseMetaData.getDatabaseProductName() + " " + databaseMetaData.getDatabaseProductVersion());
                ResultSet resultSet = databaseMetaData.getTables(null, null, "%", null);
                this.addResultstoList(resultSet, this.tableList, "TABLE_NAME");
                resultSet.close();
                return true;
            }
            if (event.target == this.disconnectButton) {
                if (this.con != null) {
                    this.con.close();
                }
                this.con = null;
                this.statusLabel.setText("Disconnected");
            } else if (event.target == this.browseButton) {
                if (this.urlBrowse == null) {
                    this.urlBrowse = new FileDialog((Frame)this.getParent(), "Select a database", 0);
                }
                this.urlBrowse.show();
                this.urlText.setText("jdbc:idb:" + this.urlBrowse.getDirectory() + this.urlBrowse.getFile());
            }
        }
        catch (Exception exception) {
            this.statusLabel.setText(exception.toString());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.tableList && event.id == 701) {
            this.sqlText.setText("SELECT * FROM " + this.tableList.getSelectedItem());
            return true;
        }
        if (event.target == this.rowList && event.id == 701) {
            this.displayText.append("\n" + this.rowList.getSelectedItem());
            return true;
        }
        return super.handleEvent(event);
    }

    public void destroy() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception exception) {
            this.statusLabel.setText(exception.toString());
            exception.printStackTrace();
        }
    }
}

