/*
 * Decompiled with CFR 0.152.
 */
import db.BlobColumn;
import db.idbTrigger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import jdbc.idbConnection;

class TrigExpl
extends idbTrigger {
    static Connection con;

    public static void main(String[] stringArray) {
        try {
            Class.forName("jdbc.idbDriver");
            con = DriverManager.getConnection("jdbc:idb:sample.prp");
            Statement statement = con.createStatement();
            statement.execute("DROP TABLE employee");
            statement.execute("CREATE TABLE employee (emplID int AUTO INCREMENT, name CHAR(40), salary CURRENCY, hired DATE, age FLOAT, comment BINARY)");
            statement.execute("DROP TABLE summary");
            statement.execute("CREATE TABLE summary (under20000 int, over20000 int, employeeCount int)");
            statement.execute("INSERT INTO summary VALUES (0,0,0)");
            TrigExpl trigExpl = new TrigExpl("employee", 6);
            TrigExpl trigExpl2 = new TrigExpl("summary", 25);
            statement.execute("INSERT INTO employee VALUES(0,'Fred Flintstone', '$19000.00', '1 Jan 1998', 32.0, 'a character from a different age')");
            statement.execute("INSERT INTO employee VALUES(0,'Barny Rubble', '$21000.00', '2 Jan 1998', 31.5, 'sometimes a bit slow')");
            statement.execute("INSERT INTO employee VALUES(0,'Wilma Flintstone', '$23000.00', '3 Jan 1998', 27.5, 'the sensible one')");
            try {
                statement.execute("INSERT INTO employee VALUES(0,'Bugs Bunny', '$23000.00', '3 Jan 1998', 27.5, 'in every cartoon')");
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                TrigExpl.printSummary(statement);
            }
            statement.execute("DELETE FROM employee WHERE name='Wilma Flintstone'");
            con.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onAdd(Vector vector, long l) throws SQLException {
        Connection connection = this.getConnection();
        Properties properties = ((idbConnection)connection).getProperties();
        System.out.println("props=" + properties);
        Integer n = (Integer)vector.elementAt(0);
        String string = (String)vector.elementAt(1);
        Long l2 = (Long)vector.elementAt(2);
        Long l3 = (Long)vector.elementAt(3);
        Float f = (Float)vector.elementAt(4);
        byte[] byArray = (byte[])vector.elementAt(5);
        String string2 = BlobColumn.blobToString(vector.elementAt(5));
        System.out.println(n + " " + string + " " + string2 + "\n" + l + " Added to table " + this.getTableName());
        Statement statement = con.createStatement();
        statement.execute("UPDATE summary SET employeeCount=employeeCount+1");
        if (l2 <= 2000000L) {
            statement.execute("UPDATE summary SET under20000=under20000+1");
        } else {
            statement.execute("UPDATE summary SET over20000=over20000+1");
        }
        TrigExpl.printSummary(statement);
    }

    public void onDelete(Vector vector, long l) throws SQLException {
        Integer n = (Integer)vector.elementAt(0);
        String string = (String)vector.elementAt(1);
        Long l2 = (Long)vector.elementAt(2);
        Long l3 = (Long)vector.elementAt(3);
        Float f = (Float)vector.elementAt(4);
        byte[] byArray = (byte[])vector.elementAt(5);
        String string2 = new String(byArray, 0, 1, byArray.length - 1);
        System.out.println(l + " " + string + " Deleted from table " + this.getTableName());
        Statement statement = con.createStatement();
        statement.execute("UPDATE summary SET employeeCount=employeeCount-1");
        if (l2 <= 2000000L) {
            statement.execute("UPDATE summary SET under20000=under20000-1");
        } else {
            statement.execute("UPDATE summary SET over20000=over20000-1");
        }
        TrigExpl.printSummary(statement);
    }

    static void printSummary(Statement statement) throws SQLException {
        statement.execute("SELECT * FROM summary");
        ResultSet resultSet = statement.getResultSet();
        resultSet.next();
        System.out.println("summary=" + resultSet.getString(1) + "," + resultSet.getString(2) + "," + resultSet.getString(3));
    }

    public void onUpdate(Vector vector, long l) throws SQLException {
        Integer n = (Integer)vector.elementAt(0);
        Integer n2 = (Integer)vector.elementAt(1);
        Integer n3 = (Integer)vector.elementAt(2);
        if (n3 == 4) {
            throw new SQLException("Not in this one bugs");
        }
        System.out.println(l + " " + this.getTableName() + " updated " + n + " " + n2 + " " + n3);
    }

    public void preUpdate(Vector vector, long l) throws SQLException {
        Integer n = (Integer)vector.elementAt(0);
        Integer n2 = (Integer)vector.elementAt(1);
        Integer n3 = (Integer)vector.elementAt(2);
        System.out.println(l + " " + this.getTableName() + " before update " + n + " " + n2 + " " + n3);
    }

    public void onCommit(long l) {
        System.out.println(l + " committed");
    }

    public void onRollback(long l) {
        System.out.println(l + " rolled back");
    }

    TrigExpl(String string, int n) throws SQLException {
        super(string, n);
    }
}

