#! /bin/sh

# $Id:$

if [ -z "$JAVA_HOME" ]
then
JAVACMD=`which java`
if [ -z "$JAVACMD" ]
then
echo "Cannot find JAVA. Please set your PATH."
exit 1
fi
JAVA_BINDIR=`dirname $JAVACMD`
JAVA_HOME=$JAVA_BINDIR/..
fi

JAVAC=$JAVA_HOME/bin/javac

	
if [ -z "$JSPTUT" ]
then
JSPTUT=/JSPTutorial_III
fi
	
BASE=$JSPTUT/develop
junit=$BASE/lib/junit.jar
jdbc=$BASE/lib/idb.jar:$BASE/lib/idbf.jar
ix=$BASE/classes
libs=$BASE/lib/servlet.jar:$BASE%/lib/mail.jar:$BASE/lib/activation.jar:$BASE/lib/xerces.jar

cd $BASE/sources/de/ix/jspTutorial/util
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ../constants
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ../exception
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ../database
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ./model
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ./mail
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ./xml
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ../controller
$JAVAC -d $BASE/classes -classpath $jdbc:$ix:$libs *.java

cd ../../../../../classes
cp ../sources/jspTutorial-app/WEB-INF/tlds/ixtaglib_1_0.tld META-INF/taglib.tld
jar c0f jspTutorial.jar de

cp jspTutorial.jar ../sources/jspTutorial-app/WEB-INF/lib
cp ../lib/mail.jar ../sources/jspTutorial-app/WEB-INF/lib
cp ../lib/activation.jar ../sources/jspTutorial-app/WEB-INF/lib
cp ../lib/xerces.jar ../sources/jspTutorial-app/WEB-INF/lib
cp ../lib/idb.jar ../sources/jspTutorial-app/WEB-INF/lib
cp ../lib/idbf.jar ../sources/jspTutorial-app/WEB-INF/lib
cd $BASE
