/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */
package de.ix.jspTutorial.controller;

import java.util.*;
import javax.servlet.http.HttpServletRequest;

/**
  * This helper class delivers all the required parameters for a given request.
  *
  *
  * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
  * @version $Id:$
  */
public class RequestInfo implements de.ix.jspTutorial.constants.RequestParameterConstants {

 /**
   * version of source
   */
  public static String vcid = "$Id:$";


 /**
   * default constructor
   */
  public RequestInfo() { }


 /**
   * Get the reuired parameters for a given request.
   *
   * @param action Given request
   * @return Enumeration of required parameters
   */
  public Enumeration getParamNames(String action) {

    String[] paramArray;

    // select array depending on the request
    if (action.equals(DO_LOGIN) ) {
       paramArray = DO_LOGIN_PARAMS;
    } else if (action.equals(DO_CHOICE) ) {
       paramArray = DO_CHOICE_PARAMS;
    } else if (action.equals(DO_ORDER) ) {
       paramArray = DO_ORDER_PARAMS;
    } else {
       paramArray = null;
    }

    Vector requestParamVector = new Vector();
    if(paramArray != null)
   			requestParamVector.copyInto(paramArray);
    return  requestParamVector.elements();
  }
}

//
// History:
//
// $Log:$
//
//
