package de.ix.jspTutorial.taglib;

import javax.servlet.jsp.tagext.*;

/**
 * Angabe der Attribute aus dem Tag foreach {@link ForEachTag}
 *
 * @author Peter Rossbach (pr@webapp.de)
 * @version $Id:$
 */
public class ForEachTagExtraInfo extends TagExtraInfo
{
   /**
    * Source-Version
    */
   public static String vcid = "$Id:$";


    public ForEachTagExtraInfo()
    {
    }

    /**
     * Definition der Variable Info fr <I><jsptut:foreach ..></I> <CODE>item</CODE>
     * @param aTagdata
     * @return VariableInfo fr <CODE>item</><CODE>
     */
    public VariableInfo[] getVariableInfo(TagData aTagdata)
    {
        String s = aTagdata.getAttributeString("item");
        return (new VariableInfo[] {
            new VariableInfo(s, "java.lang.Object", true, 0)
        });
    }

    /**
     * Prfe ob im Tag die Attribute item und list enthalten sind
     * @param aTagdata
     * @return OK wenn item und list vorliegen
     */
    public boolean isValid(TagData aTagdata)
    {
       return aTagdata.getAttribute("item") != null 
            && aTagdata.getAttribute("item") != TagData.REQUEST_TIME_VALUE 
            && aTagdata.getAttribute("list") != null;
    }
}