 <%--
  % This Javer Server Page is part of the iX JSP tutorial.
  % It is the global entry point for all requests
 --%>
 
<%-- Setting up an error page --%>
<%@ page errorPage="/jspTutorial/errorpage.jsp" %>
<%@ page import="de.ix.jspTutorial.controller.*" %>
<%@ page import="de.ix.jspTutorial.exception.*" %>

<% 	
   response.setDateHeader("Expires",0);
   response.setHeader("Pragma","no-cache");
   response.setHeader("Cache-Control","no-cache,must-revalidate");
%>

 
  <jsp:useBean
     id    = "pizzaModelManager"
     class = "de.ix.jspTutorial.controller.ModelManager"
     scope = "session"
   >
   <%
     pizzaModelManager.init(config.getServletContext(), session);
   %>   
 </jsp:useBean>

<jsp:useBean
   id="pizzaRequestProcessor"
   class="de.ix.jspTutorial.controller.RequestProcessor"
   scope="session"
 ><%
     pizzaRequestProcessor.init(config.getServletContext(), session);
   %></jsp:useBean>
   
 <jsp:useBean
   id="pizzaScreenFlowManager"
   class="de.ix.jspTutorial.controller.ScreenFlowManager"
   scope="session"
 ></jsp:useBean>
 
 
 <%   
  try {
      pizzaRequestProcessor.processRequest(request);
      String pathInfo = request.getPathInfo() ;
      if(pathInfo != null)
      		request.setAttribute("requestedUrl" , pathInfo);
			 else
      		request.setAttribute("requestedUrl" , "");
  } catch (MissingInputParamsException mipe) {
      request.setAttribute("mipError", mipe);
      request.setAttribute("error","mipError");
      throw mipe ;
  }
         
  String nextPage = pizzaScreenFlowManager.getNextPageName(request);
  String doAction = "";
   
  getServletConfig().getServletContext().getRequestDispatcher("/jspTutorial/"+nextPage).forward(request, response);


 %>
 