' Demo-Skript
' Thema: ADS-Verwaltung mit ADSI
' Autor: Holger Schwichtenberg
' Auszug aus dem Buch "Windows- und Backoffice-Scripting"
' erschienen bei Addison-Wesley im Jahr 2000

' ### Das Skript listet die Benutzerkonten in dem Standard-Benutzercontainer des Active Directory auf 

Dim c ' As IADsContainer
Dim u ' As IADsUser
Set c = GetObject("LDAP://Sonne2000/cn=users,dc=it-visions,dc=de")
c.Filter = Array("User")
For Each u In c
	Ausgabe = ""
	say "Informationen ber Benutzer: " & u.AdsPath
	say "Name: " & ADSIGet(u,"givenname") & " " & ADSIGet(u,"sn")
	say "Beschreibung: " & u.description
	say "Verzeichnisname: " & u.cn
	say "Anmeldename (NT4 etc.): " & u.Get("SAMAccountname")
	say "Abteilung: " & ADSIGet(u, "Department")
	say "Bro: " & ADSIGet(u,"physicalDeliveryOfficeName")
	say "Telefonnummer: " & ADSIGet(u, "telephonenumber")
	say "Faxnummer: " & ADSIGet(u,"facsimileTelephoneNumber") 
	MsgBox Ausgabe
Next 
' -- Fehlertolerantes Auslesen eines Attributs in einem Verzeichnisobjekt
Function ADSIGet(obj, attribut)
ADSIGet = ""
On Error Resume Next
ADSIGet = obj.Get(attribut)
End Function 

' -- Sammlung der Ausgaben
Dim Ausgabe ' As String
sub say(s)
if Ausgabe <> "" then Ausgabe = Ausgabe & chr(13)
ausgabe = Ausgabe & s
end sub



