/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LineTokenizer;
import com.sun.activation.registries.MimeTypeEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MimeTypeFile {
    private String fname;
    private Hashtable type_hash = new Hashtable();
    private static boolean DEBUG;

    public MimeTypeFile(String string) throws IOException {
        File file = null;
        FileInputStream fileInputStream = null;
        this.fname = string;
        file = new File(this.fname);
        fileInputStream = new FileInputStream(file);
        this.parse(new BufferedReader(new InputStreamReader(fileInputStream)));
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public MimeTypeFile(InputStream inputStream) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public MimeTypeFile() {
    }

    public MimeTypeEntry getMimeTypeEntry(String string) {
        return (MimeTypeEntry)this.type_hash.get(string);
    }

    public String getMIMETypeString(String string) {
        MimeTypeEntry mimeTypeEntry = this.getMimeTypeEntry(string);
        if (mimeTypeEntry != null) {
            return mimeTypeEntry.getMIMEType();
        }
        return null;
    }

    public void appendToRegistry(String string) {
        try {
            this.parse(new BufferedReader(new StringReader(string)));
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parse(BufferedReader bufferedReader) throws IOException {
        String string = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 == null ? string : String.valueOf(string2) + string;
            int n = string2.length();
            if (string2.length() > 0 && string2.charAt(n - 1) == '\\') {
                string2 = string2.substring(0, n - 1);
                continue;
            }
            this.parseEntry(string2);
            string2 = null;
        }
        if (string2 != null) {
            this.parseEntry(string2);
        }
    }

    private void parseEntry(String string) {
        String string2 = null;
        String string3 = null;
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (string.charAt(0) == '#') {
            return;
        }
        if (string.indexOf(61) > 0) {
            LineTokenizer lineTokenizer = new LineTokenizer(string);
            while (lineTokenizer.hasMoreTokens()) {
                String string4 = lineTokenizer.nextToken();
                String string5 = null;
                if (lineTokenizer.hasMoreTokens() && lineTokenizer.nextToken().equals("=") && lineTokenizer.hasMoreTokens()) {
                    string5 = lineTokenizer.nextToken();
                }
                if (string5 == null) {
                    System.err.println("Bad .mime.types entry: " + string);
                    return;
                }
                if (string4.equals("type")) {
                    string2 = string5;
                    continue;
                }
                if (!string4.equals("exts")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    MimeTypeEntry mimeTypeEntry = new MimeTypeEntry(string2, string3);
                    this.type_hash.put(string3, mimeTypeEntry);
                    if (!DEBUG) continue;
                    System.out.println("Added: " + mimeTypeEntry.toString());
                }
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            MimeTypeEntry mimeTypeEntry = null;
            string3 = stringTokenizer.nextToken();
            mimeTypeEntry = new MimeTypeEntry(string2, string3);
            this.type_hash.put(string3, mimeTypeEntry);
            if (!DEBUG) continue;
            System.out.println("Added: " + mimeTypeEntry.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DEBUG = true;
        MimeTypeFile mimeTypeFile = new MimeTypeFile(stringArray[0]);
        System.out.println("ext " + stringArray[1] + " type " + mimeTypeFile.getMIMETypeString(stringArray[1]));
        System.exit(0);
    }
}

