/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class ObjectDataContentHandler
implements DataContentHandler {
    private DataFlavor[] transferFlavors;
    private Object obj;
    private String mimeType;
    private DataContentHandler dch;

    public ObjectDataContentHandler(DataContentHandler dataContentHandler, Object object, String string) {
        this.obj = object;
        this.mimeType = string;
        this.dch = dataContentHandler;
    }

    public DataContentHandler getDCH() {
        return this.dch;
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new DataFlavor[0];
                this.transferFlavors[0] = new ActivationDataFlavor(this.obj.getClass(), this.mimeType, this.mimeType);
            }
        }
        return this.transferFlavors;
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(dataFlavor, dataSource);
        }
        if (dataFlavor.equals(this.transferFlavors[0])) {
            return this.obj;
        }
        return null;
    }

    public Object getContent(DataSource dataSource) {
        return this.obj;
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (this.dch != null) {
            this.dch.writeTo(object, string, outputStream);
            return;
        }
        throw new UnsupportedDataTypeException();
    }
}

