/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ByteColumn;
import db.Column;
import db.HashTablePool;
import db.IdbVector;
import db.IntegerColumn;
import db.Journal;
import db.SQLProg;
import db.StringColumn;
import db.Table;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import db.TypeInfo;
import db.indexTable;
import db.sqltoken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Database
implements Runnable {
    static sqltoken SQLsyntax;
    static Vector databases;
    static boolean shutdownActive;
    public static final int TABLE_NAME_MAX = 64;
    public static final int PATH_NAME_MAX = 256;
    public static final int COLUMN_NAME_MAX = 64;
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 13;
    public static final int BETA_VERSION = 0;
    public static final int CACHE_DEFAULT = 0;
    public static final int CACHE_ROWS = 1;
    public static final int CACHE_PERCENT = 2;
    public static final String nullString = "NULL";
    String filename;
    Properties dbProperties;
    int nextTmpNum = 1;
    String tablePath;
    String indexPath;
    String tmpPath;
    String systemPath;
    int partitionCount;
    IdbVector partitions;
    boolean valid;
    boolean closed;
    int openCount;
    String propertiesPath;
    String url;
    Thread timerThread;
    Vector timerQueue;
    long timerCheck;
    Table tblTable;
    Table colTable;
    Table idxTable;
    Vector tblList;
    String colsTableName;
    String tblsTableName;
    String indxTableName;
    String defDateFormat;
    char defCurrencySymbol;
    int defCurrencyDecimal;
    int exportSQL;
    float indexLoad;
    int transLevel;
    int transImports;
    PrintWriter export;
    int traceLevel;
    int traceConsole;
    boolean fastUpdate;
    boolean strictLiterals;
    int milleniumBoundary;
    boolean readOnly;
    boolean resultsOnDisk;
    boolean likeIgnoreCase;
    boolean altStringHashing;
    boolean nowMeansTime;
    int recoveryPolicy;
    boolean searchDeletes;
    boolean prepareIgnoresEscapes;
    boolean microsoftVM;
    Vector hashtables;
    Vector vectorPool;
    Vector stringbuffs;
    Transaction sysTrans;
    Journal journal;
    boolean doRecovery;
    String defaultUsername = "";
    String defaultPassword = "";

    Database getDatabase() {
        return this;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public String getURL() {
        return this.url;
    }

    synchronized String getTmpFile() {
        return this.filename + "$tmp$" + this.nextTmpNum++;
    }

    String getStringProperty(String string, String string2) {
        return this.dbProperties.getProperty(string, string2);
    }

    synchronized void addTable(Table table) {
        this.tblList.addElement(table);
    }

    public Journal getJournal() {
        return this.journal;
    }

    synchronized void removeTable(Table table) {
        if (this.tblList == null) {
            return;
        }
        int n = this.getTableIndex(table);
        if (n < 0) {
            return;
        }
        this.tblList.removeElementAt(n);
    }

    boolean isValid() {
        return this.valid;
    }

    public String getFilename() {
        return this.filename;
    }

    void addColumns() throws SQLException {
        IntegerColumn integerColumn = new IntegerColumn(this.colTable, "ColID");
        integerColumn.setBooleanProperty(1, true);
        integerColumn.setBooleanProperty(5, true);
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.colTable, "TableId");
        integerColumn.setCacheCondition(2, 100);
        StringColumn stringColumn = new StringColumn(this.colTable, "ColName", 64);
        stringColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.colTable, "Flags", 64);
        stringColumn.setCacheCondition(2, 100);
        ByteColumn byteColumn = new ByteColumn(this.colTable, "Type");
        byteColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.colTable, "Offset");
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.colTable, "Length");
        integerColumn.setCacheCondition(2, 100);
        byteColumn = new ByteColumn(this.colTable, "CacheCond");
        byteColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.colTable, "CacheAmnt");
        integerColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.colTable, "ColDefault", 64);
        stringColumn.setCacheCondition(2, 100);
    }

    void traceMemory() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        if (Trace.traceIt(128)) {
            Trace.traceOut("Total Memory=" + runtime.totalMemory() + " Free=" + runtime.freeMemory() + " Used " + l);
        }
    }

    void checkForShutdown() throws SQLException {
        if (this.closed) {
            throw new SQLException("Database has been closed");
        }
        if (shutdownActive) {
            throw new SQLException("Shutdown is in progress");
        }
    }

    void shutdown(boolean bl) throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            shutdownActive = true;
            int n = databases.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Database database = (Database)databases.elementAt(n2);
                if (!bl) {
                    database.lockTables(database.tblList, this.sysTrans);
                }
                database.openCount = 1;
                database.close(false);
                --n2;
            }
            shutdownActive = false;
        }
    }

    public synchronized Transaction dbOpen(String string, String string2, String string3) throws SQLException {
        Vector<int[]> vector;
        Integer n;
        Serializable serializable;
        int n2;
        this.checkForShutdown();
        if (!this.valid) {
            this.initialise(string);
        }
        if (Trace.traceIt(1)) {
            Trace.traceOut("Opening database " + string + " opens=" + this.openCount);
        }
        this.traceMemory();
        if (this.valid) {
            ++this.openCount;
            return new Transaction(this);
        }
        String string4 = this.tablePath;
        if (this.systemPath != null) {
            this.tablePath = this.systemPath;
        }
        if (!this.valid) {
            this.sysTrans = new Transaction(this);
        }
        Transaction transaction = new Transaction(this);
        this.colTable = new Table(null, this, transaction, -1);
        this.addColumns();
        try {
            n2 = this.colTable.open(this.filename + "$db$Cols");
            if (n2 == 0) {
                n2 = this.colTable.open(this.filename + "$db$Columns");
            }
            if (n2 == 0) {
                this.colTable = null;
                this.dbCreate(string, string3, transaction);
                transaction.commit(transaction.sqlID);
                this.tablePath = string4;
                this.valid = true;
                ++this.openCount;
                return transaction;
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.colTable.tblID = new Integer(1000);
        n2 = 1;
        while (n2 <= this.colTable.rowCount) {
            if (this.colTable.rowDeleted(n2)) {
                throw new SQLException("Internal error - column table columns missing");
            }
            serializable = (Integer)this.colTable.getColByRow("TableId", n2);
            if (!((Integer)serializable).equals(this.colTable.tblID)) break;
            String string5 = (String)this.colTable.getColByRow("ColName", n2);
            n = (Integer)this.colTable.getColByRow("ColID", n2);
            vector = this.colTable.getColByName(string5);
            ((Column)((Object)vector)).colID = n;
            ++n2;
        }
        Hashtable hashtable = null;
        serializable = new IdbVector(this.colTable);
        hashtable = new Hashtable(200, 0.6f);
        int n3 = 1;
        while (n3 <= this.colTable.rowCount) {
            if (!this.colTable.rowDeleted(n3)) {
                this.colTable.getRow(n3, (Vector)serializable);
                n = ((IdbVector)serializable).getIntegerAt(2);
                vector = (Vector)hashtable.get(n);
                int n4 = ((IdbVector)serializable).getIntAt(6);
                int[] nArray = new int[]{n3, n4};
                if (vector == null) {
                    vector = new Vector<int[]>(20, 20);
                    vector.addElement(nArray);
                    hashtable.put(n, vector);
                } else {
                    boolean bl = false;
                    int n5 = vector.size() - 1;
                    while (n5 >= 0) {
                        int[] nArray2 = (int[])vector.elementAt(n5);
                        if (n4 > nArray2[1]) {
                            vector.ensureCapacity(vector.size() + 1);
                            vector.insertElementAt(nArray, n5 + 1);
                            bl = true;
                            break;
                        }
                        --n5;
                    }
                    if (!bl) {
                        vector.insertElementAt(nArray, 0);
                    }
                }
            }
            ++n3;
        }
        this.tblTable = new Table(null, this.colTable, this.filename + "$db$Tables", hashtable);
        IdbVector idbVector = new IdbVector(this.tblTable);
        int n6 = 1;
        while (n6 <= this.tblTable.rowCount) {
            if (n6 > 6) {
                this.tablePath = string4;
            }
            if (!this.tblTable.rowDeleted(n6)) {
                this.tblTable.getRow(n6, idbVector);
                int n7 = idbVector.getIntAt(5);
                Table table = null;
                if (n7 == 1) {
                    table = new Table(idbVector, this.colTable, new Integer(n6), hashtable);
                    if (table.tableName.endsWith("$db$Indexes")) {
                        this.idxTable = table;
                        try {
                            this.journal.doRecovery(true);
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Problem replaying system journal: " + iOException.toString());
                        }
                    }
                } else if (n7 == 2) {
                    table = new indexTable(idbVector, this.colTable, new Integer(n6), hashtable);
                }
            }
            ++n6;
        }
        try {
            this.journal.doRecovery(false);
        }
        catch (IOException iOException) {
            throw new SQLException("Problem replaying journal: " + iOException.toString());
        }
        n6 = 0;
        while (n6 < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n6);
            if (table instanceof indexTable) {
                try {
                    ((indexTable)table).bind(this.idxTable, this.colTable, this.tblTable);
                }
                catch (Exception exception) {
                    System.out.println("Error binding index: " + table.getTableName() + "\n" + exception.toString() + "\nIndex will be dropped from database.");
                    table.dropTable(this.sysTrans);
                }
            }
            ++n6;
        }
        transaction.commit(transaction.sqlID);
        this.tablePath = string4;
        ++this.openCount;
        this.valid = true;
        return transaction;
    }

    String setPath(String string, String string2, boolean bl) throws SQLException {
        Object object;
        String string3 = this.getStringProperty(string, string2);
        if (string3 != null) {
            if (string3.charAt(0) == '$') {
                object = string3.substring(1);
                string3 = System.getProperty((String)object);
            } else if (bl) {
                string3 = this.propertiesPath + File.separatorChar + string3;
            }
            string3 = this.switchSeparators(string3);
        } else {
            string3 = this.tablePath;
        }
        try {
            object = new File(string3);
            string3 = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening file: " + string3 + "\n" + iOException.toString());
        }
        return string3;
    }

    String switchSeparators(String string) {
        if (string == null) {
            return null;
        }
        char c = File.separatorChar == '\\' ? (char)'/' : '\\';
        String string2 = string.replace(c, File.separatorChar);
        return string2;
    }

    void initialise(String string) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        this.hashtables = new Vector(40, 20);
        this.vectorPool = new Vector(20, 10);
        this.stringbuffs = new Vector(40, 20);
        this.dbProperties = new Properties();
        string = this.switchSeparators(string);
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            file = new File(string2);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening properties file: " + string + "\n" + iOException.toString());
        }
        this.filename = file.getName();
        int n = this.filename.indexOf(46);
        if (n != -1) {
            this.filename = this.filename.substring(0, n);
        }
        try {
            object3 = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object3);
            this.dbProperties.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SQLException("FileNotFoundException reading properties from file: " + string + " " + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("IOException reading properties from file: " + string + " " + iOException.toString());
        }
        catch (SecurityException securityException) {
            throw new SQLException("SecurityException reading properties from file: " + string + " " + securityException.toString());
        }
        this.colsTableName = this.filename + "$db$cols";
        this.tblsTableName = this.filename + "$db$tables";
        this.indxTableName = this.filename + "$db$indexes";
        object3 = this.getStringProperty("traceFile", null);
        object3 = this.switchSeparators((String)object3);
        boolean bl = false;
        if (this.getIntegerProperty("relativeToProperties", "0") != 0) {
            bl = true;
        }
        this.propertiesPath = file.getParent();
        this.tablePath = this.setPath("tablePath", ".", bl);
        this.indexPath = this.setPath("indexPath", null, bl);
        this.systemPath = this.setPath("systemPath", null, bl);
        this.tmpPath = this.setPath("tmpPath", null, bl);
        this.partitionCount = this.getIntegerProperty("partitionCount", "0");
        this.partitions = new IdbVector(this.partitionCount);
        int n2 = 1;
        while (n2 <= this.partitionCount) {
            object2 = "partition" + n2;
            object = this.setPath((String)object2, null, false);
            this.partitions.addElement(object);
            ++n2;
        }
        this.createDir(this.tablePath);
        if (this.indexPath != null) {
            this.createDir(this.indexPath);
        }
        if (this.systemPath != null) {
            this.createDir(this.systemPath);
        }
        if (this.tmpPath != null) {
            this.createDir(this.tmpPath);
        }
        this.traceLevel = this.getIntegerProperty("traceLevel", "0");
        this.traceConsole = this.getIntegerProperty("traceConsole", "0");
        Trace trace = new Trace(this);
        trace.setExport((String)object3, this.traceLevel);
        this.export = trace.export;
        this.exportSQL = this.getIntegerProperty("exportSQL", "0");
        this.indexLoad = (float)this.getIntegerProperty("indexLoad", "5") / 100.0f;
        if (this.getIntegerProperty("resultsOnDisk", "0") != 0) {
            this.resultsOnDisk = true;
        }
        if (this.getIntegerProperty("readOnly", "0") != 0) {
            this.readOnly = true;
            this.resultsOnDisk = false;
        }
        this.defDateFormat = this.getStringProperty("dateFormat", "yyyy-mm-dd");
        this.defCurrencySymbol = this.getStringProperty("currencySymbol", "$").charAt(0);
        this.defCurrencyDecimal = this.getIntegerProperty("currencyDecimal", "2");
        this.transLevel = this.getIntegerProperty("transLevel", "1");
        this.transImports = this.getIntegerProperty("transImports", "100");
        this.recoveryPolicy = this.getIntegerProperty("recoveryPolicy", "2");
        this.timerCheck = this.getIntegerProperty("timerCheck", "5000");
        this.fastUpdate = this.getIntegerProperty("fastUpdate", "0") != 0;
        this.strictLiterals = this.getIntegerProperty("strictLiterals", "0") != 0;
        this.likeIgnoreCase = this.getIntegerProperty("likeIgnoreCase", "0") != 0;
        this.milleniumBoundary = this.getIntegerProperty("milleniumBoundary", "0");
        this.altStringHashing = this.getIntegerProperty("altStringHashing", "0") != 0;
        this.nowMeansTime = this.getIntegerProperty("nowMeansTime", "0") != 0;
        this.searchDeletes = this.getIntegerProperty("searchDeletes", "0") != 0;
        this.prepareIgnoresEscapes = this.getIntegerProperty("prepareIgnoresEscapes", "0") != 0;
        try {
            object2 = this.getClass();
            synchronized (object2) {
                if (SQLsyntax == null) {
                    SQLsyntax = new sqltoken(this);
                    SQLsyntax.setupSyntax();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
        }
        object2 = this.getStringProperty("ignoreKeywords", "");
        if (((String)object2).length() > 0) {
            object = new StringTokenizer((String)object2, ",;", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                SQLsyntax.removeReservedWord(string3);
            }
        }
        this.tblList = new Vector(20, 20);
        this.journal = new Journal(this);
        this.timerQueue = new Vector(10, 5);
        this.timerThread = new Thread(this);
        this.timerThread.start();
    }

    void createDir(String string) throws SQLException {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new SQLException("Cannot create directory: " + string, "XOPEN");
        }
    }

    void setTablePath(String string) throws SQLException {
        this.tablePath = string;
        this.createDir(string);
        File file = new File(string);
        if (file.isAbsolute()) {
            Properties properties = System.getProperties();
            properties.put("user.dir", string);
            System.setProperties(properties);
        }
    }

    void setIndexPath(String string) throws SQLException {
        this.indexPath = string;
        this.createDir(string);
    }

    void setTmpPath(String string) throws SQLException {
        this.tmpPath = string;
        this.createDir(string);
    }

    public Transaction dbCreate(String string, String string2, Transaction transaction) throws SQLException {
        this.tblTable = new Table(this.filename + "$db$Tables", this, transaction, -1);
        IntegerColumn integerColumn = new IntegerColumn(this.tblTable, "TableID");
        integerColumn.setBooleanProperty(1, true);
        integerColumn.setBooleanProperty(5, true);
        integerColumn.setCacheCondition(2, 100);
        StringColumn stringColumn = new StringColumn(this.tblTable, "TableName", 64);
        stringColumn.setBooleanProperty(2, true);
        stringColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.tblTable, "Path", 256);
        stringColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.tblTable, "RecLen");
        integerColumn.setCacheCondition(2, 100);
        ByteColumn byteColumn = new ByteColumn(this.tblTable, "Type");
        byteColumn.setCacheCondition(2, 100);
        try {
            this.tblTable.allColumnsAdded(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.colTable = new Table(this.filename + "$db$Cols", this, transaction, -1);
        this.addColumns();
        try {
            this.colTable.allColumnsAdded(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.tblTable.registerTable(transaction);
        indexTable indexTable2 = (indexTable)this.getTable(this.filename + "$db$Tables$pKey");
        indexTable2.registerTable(transaction);
        this.idxTable = new Table(this.filename + "$db$Indexes", this, transaction, -1);
        integerColumn = new IntegerColumn(this.idxTable, "TableID");
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.idxTable, "ColID");
        integerColumn.setCacheCondition(2, 100);
        try {
            this.idxTable.allColumnsAdded(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        indexTable2.registerIndex(transaction);
        indexTable2 = (indexTable)this.getTable(this.filename + "$db$Cols$pKey");
        indexTable2.registerIndex(transaction);
        new TypeInfo(this, transaction);
        return transaction;
    }

    int translateCacheCondition(String string) {
        if (string.equalsIgnoreCase("CACHE_ROWS")) {
            return 1;
        }
        return 2;
    }

    int getIntegerProperty(String string, String string2) {
        String string3 = this.dbProperties.getProperty(string, string2);
        return Integer.parseInt(string3);
    }

    public synchronized Table getTable(String string) {
        int n = 0;
        while (n < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n);
            String string2 = table.getTableName();
            if (string2.equalsIgnoreCase(string)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    synchronized Table getTable(int n) {
        int n2 = 0;
        while (n2 < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n2);
            if (n == table.getTableID()) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    synchronized int getTableIndex(Table table) {
        int n = 0;
        while (n < this.tblList.size()) {
            Table table2 = (Table)this.tblList.elementAt(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized Vector getTables() {
        return (Vector)this.tblList.clone();
    }

    synchronized Table[] getTableArray() {
        Table[] tableArray = new Table[this.tblList.size()];
        int n = 0;
        while (n < this.tblList.size()) {
            Table table;
            tableArray[n] = table = (Table)this.tblList.elementAt(n);
            ++n;
        }
        return tableArray;
    }

    public SQLProg execQuery(String string, Transaction transaction) throws SQLException {
        SQLProg sQLProg = new SQLProg(this, string, false, transaction);
        sQLProg.execute();
        return sQLProg;
    }

    public void execSQL(String string, Transaction transaction) throws SQLException {
        SQLProg sQLProg = this.execQuery(string, transaction);
        if (sQLProg.rsTable != null) {
            sQLProg.rsTable.dropTable(null);
            sQLProg.rsTable = null;
            sQLProg = null;
        }
    }

    public void close(boolean bl) throws SQLException {
        if (!this.valid) {
            return;
        }
        --this.openCount;
        if (this.openCount > 0) {
            Trace.close();
            return;
        }
        if (!bl) {
            this.journal.commitAll();
        }
        int n = 0;
        while (n < this.tblList.size()) {
            Table table = (Table)this.tblList.elementAt(n);
            try {
                if (table.tableType == 3) {
                    table.dropTable(null);
                } else {
                    table.close(bl);
                }
            }
            catch (Exception exception) {
                System.out.println("Error closing table " + table.tableName + "\n" + exception);
                exception.printStackTrace();
            }
            ++n;
        }
        this.filename = null;
        this.tblTable = null;
        this.colTable = null;
        this.idxTable = null;
        this.tblList = null;
        this.dbProperties = null;
        this.export = null;
        this.hashtables = null;
        this.vectorPool = null;
        this.timerQueue = null;
        this.timerThread.interrupt();
        this.stringbuffs = null;
        this.nextTmpNum = 1;
        this.valid = false;
        this.closed = true;
        Trace.close();
        this.journal.closeLog();
        Database.removeDatabase(this);
    }

    public synchronized void close() throws SQLException {
        if (Trace.traceIt(1)) {
            Trace.traceOut("Closing database " + this.filename + " opens=" + this.openCount);
        }
        this.close(false);
    }

    protected synchronized void finalize() throws Throwable {
        try {
            this.close(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void lockSystemTables(Transaction transaction) throws SQLException {
        this.colTable.lockTable(transaction);
        this.tblTable.lockTable(transaction);
        this.idxTable.lockTable(transaction);
    }

    void lockTables(Vector vector, Transaction transaction) throws SQLException {
        Vector vector2 = this.getTables();
        int n = 0;
        while (n < vector2.size()) {
            Table table = (Table)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Table table2 = (Table)vector.elementAt(n2);
                if (table == table2) {
                    if (table.tblID == null) {
                        table.lockTable(transaction);
                    } else if (table.tblID < 1004) {
                        this.lockSystemTables(transaction);
                    } else {
                        table.lockTable(transaction);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    void releasePool(HashTablePool hashTablePool) {
        hashTablePool.freeAll();
        if (this.hashtables == null) {
            return;
        }
        Vector vector = this.hashtables;
        synchronized (vector) {
            this.hashtables.addElement(hashTablePool);
        }
    }

    HashTablePool getHashTablePool() {
        HashTablePool hashTablePool = null;
        Vector vector = this.hashtables;
        synchronized (vector) {
            int n = this.hashtables.size() - 1;
            if (n < 0) {
                hashTablePool = new HashTablePool();
            } else {
                hashTablePool = (HashTablePool)this.hashtables.elementAt(n);
                this.hashtables.removeElementAt(n);
            }
        }
        return hashTablePool;
    }

    void returnStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        Vector vector = this.stringbuffs;
        synchronized (vector) {
            this.stringbuffs.addElement(stringBuffer);
        }
    }

    StringBuffer getStringBuffer() {
        StringBuffer stringBuffer = null;
        Vector vector = this.stringbuffs;
        synchronized (vector) {
            int n = this.stringbuffs.size() - 1;
            if (n < 0) {
                stringBuffer = new StringBuffer(20);
            } else {
                stringBuffer = (StringBuffer)this.stringbuffs.elementAt(n);
                this.stringbuffs.removeElementAt(n);
            }
        }
        return stringBuffer;
    }

    public static Database getDatabase(String string) {
        Serializable serializable;
        try {
            serializable = Class.forName("java.lang.Exception");
            synchronized (serializable) {
                if (databases == null) {
                    databases = new Vector(5, 5);
                    if (System.getProperty("noBanner") == null) {
                        System.out.print("Enhydra InstantDB - Version 3.13");
                        System.out.println();
                        String string2 = "The Initial Developer of the Original Code is Lutris Technologies Inc.\nPortions created by Lutris are Copyright (C) 1997-2000 Lutris Technologies, Inc.\nAll Rights Reserved.";
                        System.out.println(string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
            return null;
        }
        serializable = databases;
        synchronized (serializable) {
            int n = 0;
            while (n < databases.size()) {
                Database database = (Database)databases.elementAt(n);
                if (database.getURL().equalsIgnoreCase(string)) {
                    Database database2 = database;
                    Object var2_8 = null;
                    return database2;
                }
                ++n;
            }
            Database database = null;
            Object var2_9 = null;
            return database;
        }
    }

    public static Database getDatabaseWithTable(String string) {
        Vector vector = databases;
        synchronized (vector) {
            int n = 0;
            while (n < databases.size()) {
                Database database = (Database)databases.elementAt(n);
                if (database.getTable(string) != null) {
                    Database database2 = database;
                    Object var2_6 = null;
                    return database2;
                }
                ++n;
            }
            Database database = null;
            Object var2_7 = null;
            return database;
        }
    }

    public static void addDatabase(Database database) {
        Vector vector = databases;
        synchronized (vector) {
            databases.addElement(database);
        }
    }

    public static void removeDatabase(Database database) {
        Vector vector = databases;
        synchronized (vector) {
            databases.removeElement(database);
        }
    }

    public void setTableEncryption(String string, TableEncrypt tableEncrypt) throws SQLException {
        Table table = this.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string + " - setting table encryption");
        }
        table.setTableEncryption(tableEncrypt);
    }

    public void run() {
        this.timerThread.setName(this.filename + "$timer");
        while (true) {
            block8: {
                try {
                    Thread.sleep(this.timerCheck);
                }
                catch (InterruptedException interruptedException) {
                    if (this.timerQueue == null) break block8;
                    interruptedException.printStackTrace();
                }
            }
            Database database = this;
            synchronized (database) {
                if (this.timerQueue == null) {
                    Object var2_4 = null;
                    return;
                }
                Transaction transaction = this.getHeadOfTimerQueue();
                while (transaction != null) {
                    transaction = transaction.checkExpired() ? this.getHeadOfTimerQueue() : null;
                }
            }
        }
    }

    Transaction getHeadOfTimerQueue() {
        Transaction transaction = null;
        Vector vector = this.timerQueue;
        synchronized (vector) {
            if (this.timerQueue.size() > 0) {
                transaction = (Transaction)this.timerQueue.elementAt(0);
            }
        }
        return transaction;
    }

    public void addToTimerQueue(Transaction transaction, int n) {
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        transaction.expiryTime = l += (long)(n * 1000);
        Vector vector = this.timerQueue;
        synchronized (vector) {
            int n2 = this.timerQueue.size();
            if (n2 == 0) {
                this.timerQueue.addElement(transaction);
            } else {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    Transaction transaction2 = (Transaction)this.timerQueue.elementAt(n3);
                    if (l >= transaction2.expiryTime) {
                        if (n3 == n2 - 1) {
                            this.timerQueue.addElement(transaction);
                            break;
                        }
                        this.timerQueue.insertElementAt(transaction, n3 + 1);
                        break;
                    }
                    --n3;
                }
            }
        }
    }

    public void removeFromTimerQueue(Transaction transaction) {
        this.timerQueue.removeElement(transaction);
    }

    public Database(String string) throws SQLException {
        this.url = string;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("java.vendor");
        if (string2.indexOf("Microsoft") != -1) {
            this.microsoftVM = true;
        }
    }
}

