/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Column;
import db.Database;
import db.IdbVector;
import db.IndexColumn;
import db.Table;
import db.Trace;
import db.Transaction;
import db.idbDataOutputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class indexTable
extends Table {
    static long time;
    static long addtime;
    static long hashtime;
    static long lookuptime;
    static int indexRowsMoved;
    static final int START_SIZE = 128;
    static final int MAX_OUT_BUF = 8192;
    static Integer int0;
    static Integer int1;
    Table parentTable;
    int[] keys;
    int[] rows;
    boolean[] deleted;
    Vector indexedCols;
    boolean hashPreservesOrder = false;
    int lowestKey;
    int highestKey;
    boolean unique;

    int getKeyByRow(int n) {
        return this.keys[n - 1];
    }

    int getRowByRow(int n) {
        return this.rows[n - 1];
    }

    boolean indexes(Vector vector) {
        if (this.indexedCols.size() != vector.size()) {
            return false;
        }
        int n = 0;
        while (n < this.indexedCols.size()) {
            Object e = this.indexedCols.elementAt(n);
            boolean bl = false;
            int n2 = 0;
            while (n2 < vector.size()) {
                if (vector.elementAt(n2) == e) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void registerIndex(Transaction transaction) throws SQLException {
        Table table = null;
        table = this.dbase.getTable(this.dbase.filename + "$db$Indexes");
        if (table == null) {
            return;
        }
        int n = 0;
        while (n < this.indexedCols.size()) {
            Column column = (Column)this.indexedCols.elementAt(n);
            Vector<Integer> vector = new Vector<Integer>(3);
            vector.addElement(int0);
            vector.addElement(this.tblID);
            vector.addElement(column.colID);
            table.addRow(vector, transaction);
            ++n;
        }
    }

    void close(boolean bl) throws IOException, SQLException {
        if (this.dbase.readOnly) {
            return;
        }
        this.rndFile = new RandomAccessFile(this.fileDesc, "rw");
        this.fd = this.rndFile.getFD();
        if (!this.modified) {
            super.close(bl);
            return;
        }
        try {
            long l = (this.rowCount - this.deletedRowCount) * 8;
            this.rndFile.seek(this.firstRowPosn + l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rndFile.seek(this.firstRowPosn);
        byte[] byArray = new byte[32768];
        idbDataOutputStream idbDataOutputStream2 = new idbDataOutputStream(byArray, 2);
        int n = 0;
        int n2 = 0;
        while (n2 < this.rowCount) {
            if (!this.deleted[n2]) {
                idbDataOutputStream2.writeVarInt(this.keys[n2]);
                idbDataOutputStream2.writeVarInt(this.rows[n2]);
                idbDataOutputStream2.curCol = 0;
                if ((n += 2) == 8192) {
                    this.rndFile.write(byArray);
                    idbDataOutputStream2.reset();
                    n = 0;
                }
            }
            ++n2;
        }
        this.rndFile.write(byArray, 0, n * 4);
        super.close(bl);
    }

    void getColsFromNames(Vector vector) throws SQLException {
        Column column = null;
        this.indexedCols = new Vector(2, 2);
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            column = this.parentTable.getColByName(string);
            if (column == null) {
                throw new SQLException("Attempt to create index on unknown column: " + string, "XOPEN?");
            }
            this.indexedCols.addElement(column);
            ++n;
        }
        if (this.indexedCols.size() == 1 && column.hashPreservesOrder()) {
            this.hashPreservesOrder = true;
        }
    }

    void newIndexArrays(int n) {
        this.keys = new int[n];
        this.rows = new int[n];
        this.deleted = new boolean[n];
    }

    void recover() {
        if (Trace.traceIt(1)) {
            Trace.traceOut("Recovering table: " + this.tableName);
        }
        this.deletedRowCount = 0;
        this.rowCount = 0;
    }

    void generateIndex() throws SQLException {
        int n = 128;
        if (this.parentTable.rowCount > 128) {
            n = 2 * this.parentTable.rowCount;
        }
        this.newIndexArrays(n);
        this.deletedRowCount = 0;
        this.rowCount = 0;
        if (Trace.traceIt(8)) {
            Trace.traceOut("Generating Index for " + this.parentTable.tableName + ", " + this.parentTable.rowCount + " rows");
        }
        int n2 = 1;
        while (n2 <= this.parentTable.rowCount) {
            if (!this.parentTable.rowDeleted(n2)) {
                this.addRowToIndex(n2);
            }
            ++n2;
        }
    }

    void bind(Table table, Table table2, Table table3) throws SQLException {
        Serializable serializable;
        this.indexedCols = new Vector(2, 2);
        Column column = null;
        int n = 1;
        while (n <= table.rowCount) {
            if (!table.rowDeleted(n) && this.tblID.equals(serializable = (Integer)table.getColByRow("TableID", n))) {
                serializable = (Integer)table.getColByRow("ColID", n);
                if (this.parentTable == null) {
                    Enumeration enumeration = this.dbase.tblList.elements();
                    while (enumeration.hasMoreElements()) {
                        Table table4 = (Table)enumeration.nextElement();
                        column = table4.getColByID((Integer)serializable);
                        if (column != null) break;
                    }
                    this.parentTable = column.getTable();
                    if (this.parentTable.recovered) {
                        this.recovered = true;
                    }
                } else {
                    column = this.parentTable.getColByID((Integer)serializable);
                }
                this.indexedCols.addElement(column);
            }
            ++n;
        }
        if (this.indexedCols.size() == 1 && column.hashPreservesOrder()) {
            this.hashPreservesOrder = true;
        }
        if (this.recovered) {
            this.generateIndex();
            try {
                Vector vector = this.columnList;
                serializable = this.indexTables;
                this.close(false);
                this.columnList = vector;
                this.indexTables = serializable;
                this.isClosed = false;
            }
            catch (Exception exception) {
                throw new SQLException("IO problem: " + exception.toString());
            }
            this.rndFile = null;
            this.fd = null;
        }
        this.parentTable.indexTables.addElement(this);
    }

    void unbind(Transaction transaction) throws SQLException {
        Table table = this.dbase.idxTable;
        int n = 1;
        while (n <= table.rowCount) {
            Integer n2 = (Integer)table.getColByRow("TableID", n);
            if (this.tblID.equals(n2)) {
                table.deleteRow(n, transaction);
            }
            ++n;
        }
    }

    public void dropTable(Transaction transaction) throws SQLException {
        if (this.tableType == 3) {
            return;
        }
        this.parentTable.indexTables.removeElement(this);
        this.unbind(transaction);
        super.dropTable(transaction);
    }

    void setLowestKey() throws SQLException {
        if (this.rowCount == this.deletedRowCount) {
            return;
        }
        int n = 1;
        while (this.deleted[n - 1] && n < this.rowCount) {
            ++n;
        }
        this.lowestKey = this.getKeyByRow(n);
    }

    void setHighestKey() throws SQLException {
        if (this.rowCount == this.deletedRowCount) {
            return;
        }
        int n = this.rowCount;
        while (this.deleted[n - 1] && n > 1) {
            --n;
        }
        this.highestKey = this.getKeyByRow(n);
    }

    int getKey(int n) throws SQLException {
        Vector<Object> vector = new Vector<Object>(this.indexedCols.size());
        int n2 = 0;
        while (n2 < this.indexedCols.size()) {
            Column column = (Column)this.indexedCols.elementAt(n2);
            vector.addElement(column.getByRow(n));
            ++n2;
        }
        n2 = this.getKey(vector);
        return n2;
    }

    int getKey(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.indexedCols.size()) {
            Column column = (Column)this.indexedCols.elementAt(n2);
            Object e = vector.elementAt(n2);
            n = n << 3 ^ column.getHash(e);
            ++n2;
        }
        return n;
    }

    int lookupKey(int n, boolean bl) throws SQLException {
        int n2 = -1;
        if (bl) {
            if (this.rowCount == 0 || n < this.lowestKey || n > this.highestKey) {
                return 0;
            }
        } else {
            if (this.rowCount == 0 || n < this.lowestKey) {
                return 1;
            }
            if (n > this.highestKey) {
                return this.rowCount + 1;
            }
        }
        int n3 = 1;
        int n4 = this.rowCount;
        while (this.deleted[n3 - 1] && n3 < n4) {
            ++n3;
        }
        while (this.deleted[n4 - 1] && n4 > n3) {
            --n4;
        }
        int n5 = this.lowestKey;
        int n6 = this.highestKey;
        int n7 = 0;
        while (true) {
            if (n5 == n) {
                n7 = n3;
                break;
            }
            if (n6 == n) {
                n7 = n4;
                break;
            }
            if (n4 - n3 <= 1) {
                if (bl) {
                    n2 = 0;
                    break;
                }
                n2 = n4;
                break;
            }
            n7 = (n3 + n4) / 2;
            while (this.deleted[n7 - 1] && n7 < n4 - 1) {
                ++n7;
            }
            while (this.deleted[n7 - 1] && n7 > n3 + 1) {
                --n7;
            }
            if (this.deleted[n7 - 1]) {
                if (bl) {
                    n2 = 0;
                    break;
                }
                n2 = n7;
                break;
            }
            int n8 = this.getKeyByRow(n7);
            if (n < n8) {
                n4 = n7;
                n6 = n8;
                continue;
            }
            n3 = n7;
            n5 = n8;
        }
        if (n2 == -1) {
            n2 = this.lowestRowWithKey(n, n7);
        }
        return n2;
    }

    int lowestRowWithKey(int n, int n2) throws SQLException {
        int n3 = n2;
        while (--n3 > 0) {
            if (this.deleted[n3 - 1]) continue;
            int n4 = this.getKeyByRow(n3);
            if (n != n4) break;
            n2 = n3;
        }
        return n2;
    }

    int highestRowWithKey(int n, int n2, int n3) throws SQLException {
        int n4;
        int n5;
        if (this.rowCount > 0 && n3 == 1) {
            n5 = this.rowCount;
            while (this.deleted[n5 - 1]) {
                if (--n5 != 0 && n5 != n2) continue;
                return n2;
            }
            n4 = this.getKeyByRow(n5);
            if (n4 == n) {
                return n5;
            }
        }
        n5 = n2 + n3;
        n4 = n2;
        while (n5 <= this.rowCount) {
            if (!this.deleted[n5 - 1]) {
                int n6 = this.getKeyByRow(n5);
                if (n != n6) break;
                n4 = n5;
                if (n5 - n2 >= n3) {
                    n5 = n4 = this.highestRowWithKey(n, n4, n3 * 2);
                    n2 = this.rowCount;
                }
            }
            n5 += n3;
        }
        return n4;
    }

    int[] lookupValue(Vector vector, boolean bl) throws SQLException {
        int n = this.getKey(vector);
        int n2 = this.lookupKey(n, bl);
        if (n2 == 0) {
            return null;
        }
        int n3 = this.highestRowWithKey(n, n2, 1);
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    int[] lookupValue(Object object, boolean bl) throws SQLException {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return this.lookupValue(vector, bl);
    }

    boolean rowDeleted(int n) throws SQLException {
        if (this.deleted == null) {
            return super.rowDeleted(n);
        }
        if (n > this.rowCount) {
            return true;
        }
        return this.deleted[n - 1];
    }

    void growIndex(int n, boolean bl, int n2, int n3, int n4) {
        int n5 = this.keys.length;
        while (n5 < n + 1) {
            n5 = n5 * 2 + 2;
        }
        if (Trace.traceIt(32)) {
            Trace.traceOut("Modifying index: " + this.tableName + ", row count=" + this.rowCount + ", deleted rows=" + this.deletedRowCount + ", new size=" + n5 + ", spread=" + bl);
        }
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        boolean[] blArray = new boolean[n5];
        int n6 = 0;
        int n7 = this.rowCount;
        int n8 = 0;
        while (n8 < n7) {
            if (n8 == n2 - 1) {
                nArray[n6] = n3;
                nArray2[n6] = n4;
                ++this.rowCount;
                blArray[++n6] = true;
                ++this.rowCount;
                ++this.deletedRowCount;
                ++n6;
            }
            blArray[n6] = this.deleted[n8];
            nArray[n6] = this.keys[n8];
            nArray2[n6] = this.rows[n8];
            ++n6;
            if (bl) {
                blArray[n6] = true;
                ++this.rowCount;
                ++this.deletedRowCount;
                ++n6;
            }
            ++n8;
        }
        this.keys = nArray;
        this.rows = nArray2;
        this.deleted = blArray;
    }

    void addRowAtRow(int n, int n2, int n3) throws SQLException {
        if (!this.modified) {
            this.markDirty();
        }
        int n4 = n - 1;
        if (n > this.keys.length) {
            this.growIndex(n, false, 0, 0, 0);
        }
        if (this.deleted[n4]) {
            --this.deletedRowCount;
        }
        if (n > this.rowCount) {
            this.rowCount = n;
        }
        this.keys[n4] = n2;
        this.rows[n4] = n3;
        this.deleted[n4] = false;
    }

    void addDeletedRowAtRow(int n) throws SQLException {
        if (n > this.keys.length) {
            this.growIndex(n, false, 0, 0, 0);
        }
        if (n > this.rowCount) {
            this.rowCount = n;
        }
        this.deleteRow(n);
    }

    void deleteRow(int n) throws SQLException {
        int n2;
        if (!this.modified) {
            this.markDirty();
        }
        if (!this.deleted[n2 = n - 1]) {
            ++this.deletedRowCount;
        }
        this.deleted[n2] = true;
    }

    void insertIndex(int n, int n2, int n3) throws SQLException {
        if (this.rowCount == this.deletedRowCount) {
            this.lowestKey = this.highestKey = n2;
        }
        if (n2 < this.lowestKey) {
            this.lowestKey = n2;
        }
        if (n2 > this.highestKey) {
            this.highestKey = n2;
        }
        if (n > this.rowCount) {
            this.addDeletedRowAtRow(this.rowCount + 1);
            this.addRowAtRow(this.rowCount + 1, n2, n3);
            return;
        }
        if (this.deleted[n - 1]) {
            this.addRowAtRow(n, n2, n3);
            return;
        }
        int n4 = 2;
        if ((float)this.deletedRowCount / (float)this.rowCount < this.dbase.indexLoad) {
            int n5 = this.rowCount * n4;
            this.growIndex(n5, true, n, n2, n3);
            return;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        while (n8 < this.rowCount) {
            int n9 = n - n8;
            int n10 = n + n8;
            if (n9 < 1 && n10 > this.rowCount) break;
            if (n9 < 1) {
                n9 = 1;
            }
            if (n10 > this.rowCount) {
                n10 = this.rowCount;
            }
            if (this.deleted[n9 - 1]) {
                n7 = n9;
                n6 = -1;
                --n;
            } else if (this.deleted[n10 - 1]) {
                n7 = n10;
                n6 = 1;
            }
            if (n7 != 0) {
                int n11 = n7;
                while (n11 != n) {
                    int n12 = n11 - n6 - 1;
                    int n13 = n11 - 1;
                    this.keys[n13] = this.keys[n12];
                    this.rows[n13] = this.rows[n12];
                    this.deleted[n13] = false;
                    this.deleted[n12] = true;
                    ++indexRowsMoved;
                    n11 -= n6;
                }
                this.addRowAtRow(n, n2, n3);
                return;
            }
            ++n8;
        }
    }

    Vector getIndexedCols(int n) throws SQLException {
        Vector<Object> vector = new Vector<Object>(this.indexedCols.size());
        int n2 = 0;
        while (n2 < this.indexedCols.size()) {
            Column column = (Column)this.indexedCols.elementAt(n2);
            vector.addElement(column.getByRow(n));
            ++n2;
        }
        return vector;
    }

    int checkUnique(int n, int n2, Vector vector) throws SQLException {
        int n3 = n;
        while (n3 <= n2) {
            if (n3 <= this.rowCount && !this.rowDeleted(n3)) {
                boolean bl = true;
                int n4 = 0;
                while (n4 < vector.size()) {
                    Column column = (Column)this.indexedCols.elementAt(n4);
                    if (!column.compare(this.rows[n3 - 1], vector.elementAt(n4), 1, false)) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    void addRowToIndex(int n) throws SQLException {
        Vector vector;
        int n2;
        int n3 = this.getKey(n);
        int n4 = this.lookupKey(n3, false);
        int n5 = this.highestRowWithKey(n3, n4, 1);
        if (this.unique && (n2 = this.checkUnique(n4, n5, vector = this.getIndexedCols(n))) != -1) {
            String string = this.parentTable.rowToString(this.rows[n2 - 1], false);
            throw new SQLException("Row already exists: " + string + " in table " + this.parentTable.getTableName() + "\nDetected by index " + this.getTableName());
        }
        int n6 = n4 + 1;
        while (n6 < n5 - 1) {
            if (this.deleted[n6 - 1]) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        this.insertIndex(n5, n3, n);
        if (n % 100 == 0 && Trace.traceIt(32)) {
            Trace.traceOut("row " + n + " indexed");
        }
        this.dumpIndex();
    }

    void dumpIndex() {
        if ((this.dbase.traceLevel & 0x100) == 0) {
            return;
        }
        if (Trace.traceIt(256)) {
            Trace.traceOut(this.tableName + " " + this.rowCount + " " + this.deletedRowCount);
        }
        int n = 0;
        while (n < this.rowCount) {
            if (Trace.traceIt(256)) {
                Trace.traceOut(this.deleted[n] + "\t" + this.keys[n] + "\t" + this.rows[n]);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    void delRowFromIndex(int var1_1) throws SQLException {
        var2_2 = this.getKey(var1_1);
        var3_3 = this.lookupKey(var2_2, true);
        if (var3_3 != 0) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = this.getRowByRow(var3_3);
            if (var4_4 == var1_1 && !this.deleted[var3_3 - 1]) {
                this.deleteRow(var3_3);
                if (var2_2 == this.lowestKey) {
                    this.setLowestKey();
                }
                if (var2_2 == this.highestKey) {
                    this.setHighestKey();
                }
                this.dumpIndex();
                return;
            }
            ++var3_3;
lbl15:
            // 2 sources

            ** while (var3_3 <= this.rowCount)
        }
lbl16:
        // 1 sources

        if (var3_3 == 0) {
            return;
        }
    }

    indexTable(String string, Database database, Transaction transaction) throws SQLException {
        super(string, database, transaction, -1);
    }

    indexTable(Table table, Vector vector, String string, boolean bl, Transaction transaction, int n) throws SQLException {
        super(string, table.dbase, transaction, n);
        this.tableType = 2;
        this.parentTable = table;
        this.getColsFromNames(vector);
        new IndexColumn(this, "Deleted", 1);
        new IndexColumn(this, "Rows", 3);
        IndexColumn indexColumn = new IndexColumn(this, "Keys", 2);
        indexColumn.setBooleanProperty(2, bl);
        this.unique = bl;
        try {
            this.allColumnsAdded(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        this.parentTable.indexTables.addElement(this);
        this.registerIndex(transaction);
        this.generateIndex();
    }

    indexTable(Database database, Table table, Vector vector) throws SQLException {
        super(database.getTmpFile(), database, true, false);
        this.parentTable = table;
        if (vector == null) {
            vector = (Vector)this.parentTable.columnList.clone();
        }
        this.indexedCols = vector;
        this.modified = true;
        this.keys = new int[128];
        this.rows = new int[128];
        this.deleted = new boolean[128];
        this.generateIndex();
    }

    indexTable(IdbVector idbVector, Table table, Object object, Hashtable hashtable) throws SQLException {
        super(idbVector, table, object, hashtable);
        Object object2;
        this.rowCount -= this.deletedRowCount;
        int n = 2 * this.rowCount + 64;
        if (this.dbase.readOnly) {
            n = this.rowCount;
        }
        this.newIndexArrays(n);
        int n2 = 0;
        while (n2 < this.columnList.size()) {
            object2 = (Column)this.columnList.elementAt(n2);
            if (((Column)object2).getName().equals("Keys")) {
                this.unique = ((Column)object2).unique;
            }
            ++n2;
        }
        if (this.recovered) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileDesc);
            object2 = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object2);
            fileInputStream.skip(this.firstRowPosn);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.rowCount) {
                if (!this.dbase.readOnly) {
                    this.deleted[n3++] = true;
                }
                this.keys[n3] = dataInputStream.readInt();
                this.rows[n3++] = dataInputStream.readInt();
                ++n4;
            }
            dataInputStream.close();
            ((BufferedInputStream)object2).close();
            fileInputStream.close();
            this.rndFile.close();
            this.rndFile = null;
            this.fd = null;
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        if (this.dbase.readOnly) {
            this.deletedRowCount = 0;
        } else {
            this.deletedRowCount = this.rowCount;
            this.rowCount += this.deletedRowCount;
        }
        this.setLowestKey();
        this.setHighestKey();
        this.findFirstDeletedRow(1);
    }

    static {
        int0 = new Integer(0);
        int1 = new Integer(1);
    }
}

