/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.EventQueue;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.MailEvent;

public abstract class Service {
    protected Session session;
    protected URLName url;
    protected boolean debug = false;
    private boolean connected = false;
    private Vector connectionListeners;
    private EventQueue q;

    protected Service(Session session, URLName uRLName) {
        this.session = session;
        this.url = uRLName;
        this.debug = session.getDebug();
    }

    public void connect() throws MessagingException {
        this.connect(null, null, null);
    }

    public void connect(String string, String string2, String string3) throws MessagingException {
        this.connect(string, -1, string2, string3);
    }

    public void connect(String string, int n, String string2, String string3) throws MessagingException {
        PasswordAuthentication passwordAuthentication;
        if (this.isConnected()) {
            throw new MessagingException("already connected");
        }
        boolean bl = false;
        boolean bl2 = false;
        String string4 = null;
        String string5 = null;
        if (this.url != null) {
            string4 = this.url.getProtocol();
            if (string == null) {
                string = this.url.getHost();
                n = this.url.getPort();
            }
            if (string2 == null) {
                string2 = this.url.getUsername();
                if (string3 == null) {
                    string3 = this.url.getPassword();
                }
            } else if (string3 == null && string2.equals(this.url.getUsername())) {
                string3 = this.url.getPassword();
            }
            n = this.url.getPort();
            string5 = this.url.getFile();
        }
        if (!bl) {
            block28: {
                if (string4 != null) {
                    if (string == null) {
                        string = this.session.getProperty("mail." + string4 + ".host");
                        n = -1;
                    }
                    if (string2 == null) {
                        string2 = this.session.getProperty("mail." + string4 + ".user");
                    }
                }
                if (string == null) {
                    string = this.session.getProperty("mail.host");
                    n = -1;
                }
                if (string2 == null) {
                    string2 = this.session.getProperty("mail.user");
                }
                if (string2 == null) {
                    try {
                        string2 = System.getProperty("user.name");
                    }
                    catch (SecurityException securityException) {
                        if (!this.debug) break block28;
                        securityException.printStackTrace();
                    }
                }
            }
            if (string3 == null && this.url != null) {
                passwordAuthentication = this.session.getPasswordAuthentication(this.url);
                if (passwordAuthentication != null) {
                    if (string2 == null) {
                        string2 = passwordAuthentication.getUserName();
                        string3 = passwordAuthentication.getPassword();
                    } else if (string2.equals(passwordAuthentication.getUserName())) {
                        string3 = passwordAuthentication.getPassword();
                    }
                } else {
                    bl2 = true;
                }
            }
            bl = this.protocolConnect(string, n, string2, string3);
        }
        if (!bl) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
            passwordAuthentication = this.session.requestPasswordAuthentication(inetAddress, n, string4, null, string2);
            if (passwordAuthentication != null) {
                string2 = passwordAuthentication.getUserName();
                string3 = passwordAuthentication.getPassword();
                bl = this.protocolConnect(string, n, string2, string3);
            }
        }
        if (!bl) {
            throw new AuthenticationFailedException();
        }
        this.setURLName(new URLName(string4, string, n, string5, string2, string3));
        if (bl2) {
            this.session.setPasswordAuthentication(this.getURLName(), new PasswordAuthentication(string2, string3));
        }
        this.setConnected(true);
        this.notifyConnectionListeners(1);
    }

    protected boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean bl) {
        this.connected = bl;
    }

    public synchronized void close() throws MessagingException {
        this.setConnected(false);
        this.notifyConnectionListeners(3);
    }

    public URLName getURLName() {
        if (this.url != null && this.url.getPassword() != null) {
            return new URLName(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), null, this.url.getUsername(), null);
        }
        return this.url;
    }

    protected void setURLName(URLName uRLName) {
        this.url = uRLName;
    }

    public synchronized void addConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.addElement(connectionListener);
    }

    public synchronized void removeConnectionListener(ConnectionListener connectionListener) {
        if (this.connectionListeners != null) {
            this.connectionListeners.removeElement(connectionListener);
        }
    }

    protected void notifyConnectionListeners(int n) {
        if (this.connectionListeners != null) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, n);
            this.queueEvent(connectionEvent, this.connectionListeners);
        }
        if (n == 3) {
            this.terminateQueue();
        }
    }

    private synchronized void terminateQueue() {
        if (this.q != null) {
            Vector vector = new Vector();
            vector.setSize(1);
            this.q.enqueue(new 1(new Object()), vector);
            this.q = null;
        }
    }

    public String toString() {
        URLName uRLName = this.getURLName();
        if (uRLName != null) {
            return uRLName.toString();
        }
        return super.toString();
    }

    protected synchronized void queueEvent(MailEvent mailEvent, Vector vector) {
        if (this.q == null) {
            this.q = new EventQueue();
        }
        Vector vector2 = (Vector)vector.clone();
        this.q.enqueue(mailEvent, vector2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.terminateQueue();
    }

    private final class 1
    extends MailEvent {
        public void dispatch(Object object) {
            Thread.currentThread().interrupt();
        }

        /* synthetic */ 1(Object object) {
            super(object);
        }
    }
}

