/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.controller ;


import javax.servlet.http.HttpSession;
import javax.servlet.ServletContext;

import de.ix.jspTutorial.constants.SessionConstants;

import de.ix.jspTutorial.model.Customer;
import de.ix.jspTutorial.model.PersonalPizza;
import de.ix.jspTutorial.model.PizzaAccessor;




/**
  * This class provides a convienient set of methods for the
  * web tier components to access all the model objects. <br>
  *
  * This class also insures that only one copy of the  model objects
  * are created for web tier access by placing a reference to the
  * model objects in the session.
  *
  * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
  * @version $Id:$
  */

public class ModelManager implements de.ix.jspTutorial.constants.SessionConstants{

  /**
    * Version  des Source
    */
  public static String vcid = "$Id:$";

  /**
    * Application
    */
  private ServletContext myApplication;

  /**
    * Session des ModelManagers
    */
   private HttpSession    httpSession;


    /**
      *  Initialize method for the <code>ModelManager</code> instance
      *
      * @param servletContext the applicationcurrent request
      * @param httpSession    the session
      */
    public void init(ServletContext servletContext,HttpSession httpSession) {
       this.httpSession     = httpSession;
       this.myApplication  = servletContext;
    }


    //------------------------------------------------------------
    //                 CUSTOMER RELATED METHODS
    //------------------------------------------------------------


    /**
      *  Get the current customer object.
      *
      *  @return the current customer object
      */
    public Customer getCustomer() {
      Customer customer = (Customer)httpSession.getValue(CUSTOMER);
      if (customer == null) {
        customer = new Customer();
        httpSession.putValue(CUSTOMER, customer);
      }
      return customer;
    }

    /**
      *  Set the current customer object.
      *
      * @param newCustomer    the new current customer
      */
    public void setCustomer(Customer newCustomer) {
      httpSession.putValue(CUSTOMER, newCustomer);
    }

    /**
      *  Reset the current customer object.
      *
      */
    public void resetCustomer() {
      httpSession.removeValue(CUSTOMER);
    }


    /**
      *  Check if there is a valid customer object.
      *
      */
    public boolean isCustomerLoggedIn() {
      Customer customer = (Customer)httpSession.getValue(CUSTOMER);
      return (customer != null);
    }



    //------------------------------------------------------------
    //                 PIZZA ACCESS RELATED METHOD(S)
    //------------------------------------------------------------

    /**
      *  Get pizza accessor object.
      *
      *  @return A pizza accessor object
      */
    public PizzaAccessor getPizzaAccessor() {
      PizzaAccessor pizzaAccessor = (PizzaAccessor)myApplication.getAttribute(PIZZA_ACCESSOR);
      if (pizzaAccessor == null) {
        pizzaAccessor = new PizzaAccessor(myApplication);
        myApplication.setAttribute(PIZZA_ACCESSOR, pizzaAccessor);
      }
      return pizzaAccessor;
    }

    //------------------------------------------------------------
    //                 PERSONAL PIZZA RELATED METHOD(S)
    //------------------------------------------------------------

    /**
      *  Get the current personal pizza object.
      *
      *  @return The current personal pizza object
      */
   public PersonalPizza getPersonalPizza() {
      PersonalPizza personalPizza = (PersonalPizza)httpSession.getValue(PERSONAL_PIZZA);
      if (personalPizza == null) {
        personalPizza = new PersonalPizza();
        httpSession.putValue(PERSONAL_PIZZA, personalPizza);
      }
      return personalPizza;
    }

   /**
     *  Set the current personal pizza object.
     *
     *  @param newPersonalPizza The new current personal pizza object
     */
    public void setPersonalPizza(PersonalPizza newPersonalPizza) {
      httpSession.putValue(PERSONAL_PIZZA, newPersonalPizza);
    }


}

//
// History:
//
// $Log:$
//
//
