/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de)
 * 
 * Source is only for non commercial and coaching usage.
 * 
 * Not Warranty to use it.
 */
 
package de.ix.jspTutorial.database.test ;

import junit.framework.*;
import de.ix.jspTutorial.database.* ;
import java.util.*;
import java.sql.*;


/** TestDBRetriever.java

    @see
    @author Peter Rossbach
    @version $Id:$
 */

public class TestDBRetriever extends TestCase 
{

	private DatabaseRetriever  myRetriever;
	
  public static Test suite()
	{
		return new TestSuite(TestDBRetriever.class) ;
	}

  public TestDBRetriever(String name)
  {
    super(name);
  }

  protected DatabaseRetriever getRetriever() { return myRetriever ;}
  
  protected void setUp()
  { 
    myRetriever = new DatabaseRetriever();
    try {
    	/*
     	DatabaseConnection theConnection = 
	    	 new DatabaseConnection(
	      	"solid.jdbc.SolidDriver",
	      	"jdbc:solid://localhost:1313", "TestTable"
	      	);	jdbc.idbDriver
     	*/
     	DatabaseConnection theConnection = 
	    	 new DatabaseConnection(
	      	"jdbc.idbDriver",
	      	"jdbc:idb:db/sample.prp", "TestTable"
	      	);
			Properties theProp = new Properties() ;
      theProp.put("user","web") ;
      theProp.put("password","lication");
      theConnection.connect(theProp) ;
      myRetriever.setConnection(theConnection);
		} catch (Exception e) {
			fail("Can't setup Retriever correct " + e.getMessage() ) ;
		}
	  System.out.println("retriever" + getRetriever());
  }

  protected void tearDown() 
  {
  	try {
  		if(myRetriever != null)
	  		myRetriever.getConnection().disconnect() ;
		} catch (Exception e) {
			fail("Can't close Retriever correct " + e.getMessage() ) ;
		}
  }

  public void testRetriever()
	{
	  	DatabaseConnection theConnection = null ;
			try {
				 
	      // fetch many objects with a procedure
	      System.out.println("value" + getRetriever());
	      assertNotNull("My Retriever is not set",getRetriever()) ;
	      theConnection = getRetriever().getConnection() ;
	      assertNotNull("Connection not set",theConnection) ;
	      theConnection.begin() ;
	      List objects = getRetriever().retrieve("select * from test2", "test2");
	      assertNotNull("no Objects",objects) ;
	      assert("no objects retrieve from database",0 != objects.size() ) ;
	      
	      for (Iterator it=objects.iterator(); it.hasNext();) {
	        I_DatabaseGenericObject object = (I_DatabaseGenericObject) it.next();
	        System.out.println(object.toString());
	      }
					theConnection.commit() ;
	
			} catch ( Exception e) {
       if(theConnection != null) {
       	 try {
       	 	theConnection.rollback() ;
       	 } catch ( DatabaseException de) {				
       	 		fail("Can't used Retriever correct and rollback db" + e.getMessage() + " / " +   de.getMessage() ) ;			
					 }
       }
				fail("Can't used Retriever correct " + e.getMessage() ) ;			
			}
	}
} 

// end of class

/**** History ****/

//
// $Log:$
//