/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.mail;

import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

import java.util.*;
import java.io.*;

import de.ix.jspTutorial.constants.*;

public class MailHelper implements MailConstants {

  final static boolean multiOn     = false;

  private String sender;
  private String messageText;
  private String smtpServer;
  private String subject;
  private Vector recipients;
  private Vector attachments;
  private boolean mailDebug;


  public MailHelper() {
    recipients  = new Vector();
    smtpServer  = "";
    messageText = "";
    sender      = "";
    subject     = "";
    attachments = new Vector();
    mailDebug = MAIL_DEBUG ;

  }

  public MailHelper(String  sender,
                    Vector recipient,
                    String smtpServer,
                    String subject,
                    String messageText,
                    Vector attachments, boolean mailDebug) {

    this.attachments = new Vector();
    this.attachments.addAll(attachments);

    this.recipients = new Vector();    
    this.recipients.addAll(recipient) ;

    this.smtpServer  = smtpServer;
    this.messageText = messageText;
    this.sender      = sender;
    this.subject     = subject;
    this.mailDebug = mailDebug ;
  }

  public void setMessageText(String newMessageText) {
    this.messageText = newMessageText;
  }

  public void setSender(String newSender) {
    this.sender = newSender;
  }

  public void setSubject(String newSubject) {
    this.subject = newSubject;
  }

  public void setRecipients(Vector newRecipients) {
    recipients.clear();
    recipients.addAll(newRecipients);
  }

  public void setAttachments(Vector newAttachments) {
    attachments.clear();
    attachments.addAll(newAttachments);
  }

  public void setSmtpServer(String newSmtpServer) {
    smtpServer = newSmtpServer;
  }

  public void setMailDebug(boolean newMailDebug) {
    this.mailDebug = newMailDebug;
  }
  
  public String getSender() {
    return sender;
  }

  public String getMessageText() {
    return messageText;
  }

  public Vector getRecipients() {
    return recipients;
  }

  public Vector getAttachments() {
    return attachments;
  }

  public String getSmtpServer() {
    return smtpServer;
  }

  public String getSubject() {
    return subject;
  }

  public boolean getMailDebug() {
    return mailDebug;
  }

  private String getShortFileName(String longFileName) {
    int index = longFileName.lastIndexOf(File.separator);
    if (    (index > -1)
         && (index != (longFileName.length()-1)) )  {
      return longFileName.substring(index+1,longFileName.length());
    } else return null;
  }


  public void sendMail() {

    Properties props = new Properties();
    props.put("mail.smtp.host", this.getSmtpServer());
    Session session = Session.getDefaultInstance(props, null);
    session.setDebug(getMailDebug());

    try{
      Message           message       = new MimeMessage(session);
      MimeBodyPart      mimeBodyPart  = new MimeBodyPart();
      Multipart         multiPart     = new MimeMultipart();
      InternetAddress   addressFrom   = new InternetAddress(this.getSender());
      InternetAddress[] addressTo  = null ;
      
      if(recipients != null && recipients.size() > 0) {
      	  InternetAddress[] address = new InternetAddress[recipients.size()] ;
      	  for(int i=0 ; i < recipients.size() ;i++) {
      	  	address[i] = new InternetAddress((String)recipients.elementAt(i) );
      	  }
      	  addressTo = address ;
      } else {
      		InternetAddress[] address = { new InternetAddress(MAIL_RECIPIENT)};
      		addressTo = address ;
      }
      message.setFrom(addressFrom);
      message.setRecipients(Message.RecipientType.TO, addressTo);
      message.setSubject(this.getSubject());

      mimeBodyPart.setText(this.getMessageText());
      multiPart.addBodyPart(mimeBodyPart);

      Vector attachFiles = this.getAttachments();

      // attach files
     if (! attachFiles.isEmpty() ) {

          for (int i = 0; i < attachFiles.size(); i++) {

            String fileName       = (String)attachFiles.elementAt(i);
            String shortFileName  = getShortFileName(fileName);

            if (shortFileName != null) {
                FileDataSource  fileDataSource = new FileDataSource(fileName);
                MimeBodyPart    attachFileMbp  = new MimeBodyPart();
                attachFileMbp.setDataHandler(new DataHandler(fileDataSource));
                multiPart.addBodyPart(attachFileMbp);
            } else {

                // error in file name should be handled

            }

          }

      }

      message.setContent(multiPart);
      Transport.send(message);

    } catch(javax.mail.MessagingException ex){
      System.out.println("Messaging Fehler: " + ex);
    } catch(Exception ex) {
      System.out.println("General Exception: " + ex);
    }
  }

}