/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) und Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercial and coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.servlet.http.HttpServletRequest;

import de.ix.jspTutorial.database.* ;
import de.ix.jspTutorial.constants.*;

/**
 * Definition of a pizza online shop customer
 *
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class Customer implements I_DatabaseObject, XMLConstants, XMLModelInterface {


  /**
    * version of the source
    */
  public static String vcid = "$Id:$";

  /**
    * Unique customer id
    */
   private long   id;

   /**
    * firstname
    */
   private String firstname;

   /**
    * lastname
    */
   private String lastname;

   /**
    * first address row
    */
   private String address1;

   /**
    * second address row
    */
   private String address2;

   /**
    * town
    */
   private String town;

   /**
    * zip code
    */
   private String zip;

   /**
    *  e-mail address
    */
   private String eMail;

   /**
    * Constructor sets the id to -1 an all strings to
    * the empty string.
    *
    */
   public Customer() {
      this.firstname = "";
      this.lastname = "";
      this.address1 = "";
      this.address2 = "";
      this.town = "";
      this.zip = "";
      this.eMail = "";
      this.id = -1;
   }



   /**
    * Set all attributes to the values of a second customer
    * object.
    *
    * @param newCustomerValue new values for the customer
    *
    */
   public void set(Customer newCustomerValue)
   {
      this.firstname = newCustomerValue.getFirstname();
      this.lastname = newCustomerValue.getLastname();
      this.address1 = newCustomerValue.getAddress1();
      this.address2 = newCustomerValue.getAddress2();
      this.town = newCustomerValue.getTown();
      this.zip = newCustomerValue.getZip();
      this.eMail = newCustomerValue.getEmail();
      this.id = newCustomerValue.getId();
   }

  /**
    * Method to create a generic object
    *
    * @return a DatabaseGenericObject
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */
   public DatabaseGenericObject getGenericObject()
		{
			DatabaseGenericObject theDbCustomer =
	   	     new DatabaseGenericObject() ;
	   	  theDbCustomer.putValue("id",new Long(getId())) ;
	   	  theDbCustomer.putValue("firstname",getFirstname()) ;
	   	  theDbCustomer.putValue("lastname",getLastname()) ;
	   	  theDbCustomer.putValue("address1",getAddress1()) ;
	   	  theDbCustomer.putValue("address2",getAddress2()) ;
	   	  theDbCustomer.putValue("zip",getZip()) ;
	   	  theDbCustomer.putValue("town",getTown()) ;
	   	  theDbCustomer.putValue("email",getEmail()) ;
			return theDbCustomer ;
		}

   /**
    * Constructor to set all attributes of the customer.
    *
    *
    * @param firstname	Firstname
    * @param lastname Lastname
    * @param address1 First row of the address
    * @param address2 Second row of the address
    * @param zip zip code
    * @param town town
    * @param eMail current e-mail address
    * @param id unique id
    *
    */
   public Customer(long id,String firstname, String lastname, String address1,
                   String address2, String zip, String town, String eMail
                   ) {
      this.firstname  = firstname;
      this.lastname   = lastname;
      this.address1   = address1;
      this.address2   = address2;
      this.zip        = zip;
      this.town       = town;
      this.eMail      = eMail;
      this.id         = id;
   }

   /**
    * Setter method for the attribute <code>firstname</code>
    *
    * @param newFirstname new value for the attribute firstname
    *
    * @see Customer#getFirstname()
    */
   public void setFirstname(String newFirstname) {
      firstname = newFirstname;
   }

  /**
    * Getter method for the attribute <code>firstname</code>
    *
    * @return current value of the attribute firstname
    *
    * @see Customer#setFirstname(String)
    */
   public String getFirstname() {
      return firstname;
   }

   /**
    * Setter method for the attribute <code>lastname</code>
    *
    * @param newLastname new value for the attribute lastname
    *
    * @see Customer#getLastname()
    */
   public void setLastname(String newLastname) {
      lastname = newLastname;
   }

 /**
    * Getter method for the attribute <code>lastname</code>
    *
    * @return current value of the attribute lastname
    *
    * @see Customer#setLastname(String)
    */
   public String getLastname() {
      return lastname;
   }

   /**
    * Setter method for the attribute <code>address1</code>
    *
    * @param newFirstname new value for the attribute address1
    *
    * @see Customer#getAddress1()
    */
   public void setAddress1(String newAddress1) {
      address1 = newAddress1;
   }

   /**
    * Getter method for the attribute <code>address1</code>
    *
    * @return current value of the attribute address1
    *
    * @see Customer#setAddress1(String)
    */
   public String getAddress1() {
      return address1;
   }

  /**
    * Setter method for the attribute <code>address2</code>
    *
    * @param newAddress new value for the attribute address2
    *
    * @see Customer#getAddress2()
    */
   public void setAddress2(String newAddress2) {
      address2 = newAddress2;
   }

 /**
    * Getter method for the attribute <code>address2</code>
    *
    * @return current value of the attribute address2
    *
    * @see Customer#setAddress2(String)
    */
   public String getAddress2() {
      return address2;
   }

  /**
    * Setter method for the attribute <code>zip</code>
    *
    * @param newZip new value for the attribute zip
    *
    * @see Customer#getZip()
    */
   public void setZip(String newZip) {
      zip = newZip;
   }

  /**
    * Getter method for the attribute <code>zip</code>
    *
    * @return current value of the attribute zip
    *
    * @see Customer#setZip(String)
    */
   public String getZip() {
      return zip;
   }

    /**
    * Setter method for the attribute <code>town</code>
    *
    * @param newTown new value for the attribute town
    *
    * @see Customer#getTown()
    */
   public void setTown(String newTown) {
      town = newTown;
   }

  /**
    * Getter method for the attribute <code>town</code>
    *
    * @return current value of the attribute town
    *
    * @see Customer#setTown(String)
    */
   public String getTown() {
      return town;
   }


   /**
    * Setter method for the attribute <code>id</code>
    *
    * @param newId new value for the attribute id
    *
    * @see Customer#getEmail()
    */
   public void setEmail(String newEMail) {
      eMail = newEMail;
   }

  /**
    * Getter method for the attribute <code>eMail</code>
    *
    * @return current value of the attribute eMail
    *
    * @see Customer#setEmail(String)
    */
   public String getEmail() {
      return eMail;
   }

   /**
    * Setter method for the attribute <code>id</code>
    *
    * @param newId new value for the attribute id
    *
    * @see Customer#getId()
    */
   public void setId(long newId) {
      id = newId;
   }

  /**
    * Getter method for the attribute <code>id</code>
    *
    * @return current value of the attribute id
    *
    * @see Customer#setId(long)
    */
   public long getId() {
      return id;
   }

   /**
    * Build a string out of the customer attributes.
    *
    * @return String representation of the customer
    *
    */
   public String toString() {
      return "Id:" + id + " Firstname: " + firstname + "  Lastname: " + lastname
             + "  Address: " + address1 + " " + address2 + "  ZIP/Town: "
             + zip + " " + town + "  eMail: " + eMail;
   }

  /**
   * method to generate XML Element containing all
   * important <code>Customer</code> information
   *
   * @param  document XML Document, to create xml element
   * @return xml element containing XML representation of PersonalPizza
   */
  public Element generateXML(Document document) {
      Element customer = (Element) document.createElement(XML_CUSTOMER_TAG);

      Element firstname   = (Element) document.createElement(XML_FIRSTNAME_TAG);
      firstname.appendChild(document.createTextNode(this.getFirstname()));

      Element lastname    = (Element) document.createElement(XML_LASTNAME_TAG);
      lastname.appendChild(document.createTextNode(this.getLastname()));

      Element address1    = (Element) document.createElement(XML_ADDRESS1_TAG);
      address1.appendChild(document.createTextNode(this.getAddress1()));

      Element address2    = (Element) document.createElement(XML_ADDRESS2_TAG);
      address2.appendChild(document.createTextNode(this.getAddress2()));

      Element zip         = (Element) document.createElement(XML_ZIP_TAG);
      zip.appendChild(document.createTextNode(this.getZip()));

      Element town        = (Element) document.createElement(XML_TOWN_TAG);
      town.appendChild(document.createTextNode(this.getTown()));

      Element eMail       = (Element) document.createElement(XML_EMAIL_TAG);
      eMail.appendChild(document.createTextNode(this.getEmail()));

      customer.appendChild(firstname);
      customer.appendChild(lastname);
      customer.appendChild(address1);
      customer.appendChild(address2);
      customer.appendChild(zip);
      customer.appendChild(town);
      customer.appendChild(eMail);

      return customer;
    }

}

//
// History
//
// $Log:$
//
//