/**
 * Copyright @ 2000 Peter Robach (pr@webapp.de) and Lars Rwekamp (Lars@openKnowlege.de)
 *
 * Source is only for non commercialand coaching usage.
 *
 * Not Warranty to use it.
 */

package de.ix.jspTutorial.model;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import de.ix.jspTutorial.constants.*;
import de.ix.jspTutorial.database.* ;

/**
 * Class to represent an ingredient of a pizza.
 *
 *
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de">pr@webapp.de</a>), Lars Rwekamp ( <a href="mailto://lars.roewekamp@openKnowledge.de">lars.roewekamp@openKnowledge.de</a>)
 * @version $Id:$
 */
public class Ingredient implements I_DatabaseObject, XMLConstants, XMLModelInterface {


   /**
    * version of the source
    */
  public static String vcid = "$Id:$";

  /**
   * unique id of the ingredient
   */
  private long   id;

  /**
   *  Name of the ingredient
   */
   private String name;

  /**
   * Price of the ingredient
   */
   private double price;

   /**
    * Constructor for an empty ingredient object
    *
    */
   public Ingredient() {}

   /**
    * Constructor sets all necessary values
    *
    *
    * @param id unique id of the ingredient
    * @param name name f the ingredient
    * @param price price of the ingredient
    *
    */
   public Ingredient(long id, String name, double price) {
      this.id = id;
      this.name = name;
      this.price = price;
   }

  /**
    * Method to create a generic object
    *
    * @return a DatabaseGenericObject
    *
    * @see de.ix.jspTutorial.database.DatabaseGenericModifier#create(I_DatabaseGenericObject,String)
    */

   public DatabaseGenericObject getGenericObject() {
      DatabaseGenericObject theDbIngredient =
	   	     new DatabaseGenericObject() ;
      theDbIngredient.putValue("id",new Long(getId())) ;
      theDbIngredient.putValue("name",getName()) ;
      theDbIngredient.putValue("price",new Double(getPrice())) ;
      return theDbIngredient ;
   }

  /**
    * Getter method for the attribute <code>id</code>
    *
    * @return current value of the attribute id
    *
    * @see Ingredient#setId(long)
    */
   public long getId() {
      return id;
   }

   /**
    * Setter method for the attribute <code>id</code>
    *
    * @param newId new value for the attribute id
    *
    * @see Ingredient#getId()
    */
   public void setId(long newId) {
      id = newId;
   }



   /**
    * Getter method for the attribute <code>name</code>
    *
    * @return current value of the attribute name
    *
    * @see Ingredient#setName(String)
    */
   public String getName() {
      return name;
   }

  /**
    * Setter method for the attribute <code>name</code>
    *
    * @param newName new value for the attribute name
    *
    * @see Ingredient#getName()
    */
   public void setName(String newName) {
      name = newName;
   }

    /**
    * Setter method for the attribute <code>price</code>
    *
    * @param newPrice new value for the attribute price
    *
    * @see Ingredient#getPrice()
    */
   public void setPrice(double newPrice) {
      price = newPrice;
   }

   /**
    * Getter method for the attribute <code>price</code>
    *
    * @return current value of the attribute price
    *
    * @see Ingredient#setPrice(double)
    */
   public double getPrice() {
      return price;
   }


  /**
   * method to generate XML Element containing all
   * important <code>Ingredient</code> information
   *
   * @param  document XML Document, to create xml element
   * @return xml element containing XML representation of PersonalPizza
   */
  public Element generateXML(Document document) {

     Element ingredient = (Element) document.createElement(XML_INGREDIENT_TAG);

     Element name = (Element) document.createElement(XML_NAME_TAG);
     name.appendChild(document.createTextNode(this.getName()));

     double priceValue  = this.getPrice();
     Double priceValueD = new Double(priceValue);

     Element price = (Element) document.createElement(XML_PRICE_TAG);
     price.appendChild(document.createTextNode(priceValueD.toString()));

     ingredient.appendChild(name);
     ingredient.appendChild(price);

     return ingredient;
   }


  /**
    * Build a string out of the ingredient attributes.
    *
    * @return String representation of the ingredient
    *
    */
   public String toString() {
      return "Id: " + id + "  Name: " + name + "  Price: " + price;
   }
}


//
// History
//
// $Log:$
//
//
