package de.ix.jspTutorial.taglib;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.* ;
import java.util.* ;
import java.text.* ;

/**
 * A simple german currency double formatter
 * <xmp>
 * <%@ taglib uri="/ixtaglib" prefix="jsptut" %>
 * ...
 * <jsptut:curreny value="9.3456" />
 * out are 9.35
 * ...
 * </xmp>
 * @author Peter Rossbach (<a href="mailto://pr@webapp.de"> pr@webapp.de </a>)
 * @version $Id:$
 */
public class FormatCurrency extends BodyTagSupport
{
   /**
    * Source-Version
    */
   public static String vcid = "$Id:$";

   /**
    * the current Value
    */
   private double myValue;
	 
   /**
    * output format
    */
   DecimalFormat myFormat ;
   
   /**
    * Set the format 
    */
   public FormatCurrency()
   {
   			myFormat = new DecimalFormat();
		 		myFormat.setGroupingUsed(true);
		 		myFormat.setMinimumFractionDigits(2);
	  		myFormat.setMaximumFractionDigits(2);
   }
   
	/**
   * Get current formatting Value
   */
  public double getValue() { return myValue ; }
  
	public void setValue(String aValue)
	{
		this.myValue = new Double(aValue).doubleValue();
	}

	public void setValue(double aValue)
	{
		this.myValue = (double) aValue;
	}

	public void setValue(Double aValue)
	{
		this.myValue = (double) aValue.doubleValue();
	}


  /**
   * Output the current money value
   */
	public int doEndTag()
		throws JspException
	{
		try
		{
		  pageContext.getOut().print(formatCurrency(myValue)) ;
		}
		catch(java.io.IOException e)
		{
			throw new JspException("IO Error: " + e.getMessage());
		}
	  return EVAL_PAGE ;
	}

  /**
	 * Formatierung the Money value with to two Position after .
	 * @param aCurrencyValue the money value
	 */
	protected  String formatCurrency(double aCurrencyValue) {
    return myFormat.format(aCurrencyValue) ;

	}

} // end of class

//
//
// History:
//
// $Log:$
//