package bruening.x4dialog;

import java.util.Vector;
import java.util.Enumeration;

public abstract class AbstractConstraint implements ConstraintIF
{
  protected String value;
  protected Vector parameters = new Vector();

 
  public void setValue(String value)
  {
    this.value = value;
  }

  public void addParameter(String parameter)
  {
    parameters.addElement(parameter.trim());
  }

  public void printParameters()
  {
    Enumeration enParameters = parameters.elements();
    while (enParameters.hasMoreElements())
    {
      System.out.println(enParameters.nextElement());
    }
  }

  public String getConstraintName()
  {
    return this.getClass().getName();
  }
}
