package bruening.x4dialog;

import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Document;

import java.util.StringTokenizer;
import java.util.Enumeration;

public class AnnotationVisitor extends NOOPVisitor
{
  private Document anDoc;

  public AnnotationVisitor(Document anDoc)
  {
    this.anDoc = anDoc;
  }


  private String getPath(Element element)
  {
    String path = element.getTagName();
    Node parent = element.getParentNode();
    while (parent instanceof Element)
    {
      Element parentElement = (Element)parent;
      path = parentElement.getTagName() + "/" + path;
      parent = parent.getParentNode();
    }

    return path;
  }


  private void copyAttributes(Element fromElement, Element toElement)
  {
    NamedNodeMap nnm = fromElement.getAttributes();
    for (int i = 0; i < nnm.getLength(); i ++)
    {
      Node a = nnm.item(i);
      ((Element)toElement).setAttribute(a.getNodeName(), a.getNodeValue());
    }
  }


  public void visitElementPost(Element element)
  {
    Element anElement = XMLUtils.getNode(element.getAttribute("anid"), anDoc);
    if (anElement != null)
    {
      copyAttributes(anElement, element);


      if (XMLUtils.getImmediateElementChildrenCount(element) == 0 &&
          XMLUtils.getImmediateElementChildrenCount(anElement) > 0)
      {
        NodeList nodeList = anElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++)
        {
          element.appendChild(XMLUtils.cloneNode(element.getOwnerDocument(), nodeList.item(i)));
        }
      }

    }
  }
}
