package bruening.x4dialog;

import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ConstraintManager
{
  public ConstraintManager()
  {
  }

  public Enumeration getConstraints(String value)
  {
    Vector constraints = new Vector();
    StringTokenizer st = new StringTokenizer(value, ";");
    while (st.hasMoreTokens())
    {
      String token = st.nextToken();
      int bracketLeft = token.indexOf("(");
      String constraintClassName = token.substring(0, bracketLeft);
      try
      {
        Class constraintClass = Class.forName("bruening.x4dialog." + constraintClassName);
        ConstraintIF constraint = (ConstraintIF)constraintClass.newInstance();
        constraints.addElement(constraint);
        System.out.println("constraint " + constraint.getConstraintName());

        int bracketRight = token.indexOf(")");
        String parameters = token.substring(bracketLeft + 1, bracketRight);
        StringTokenizer stParameters = new StringTokenizer(parameters, ",");
        while (stParameters.hasMoreTokens())
        {
          constraint.addParameter(stParameters.nextToken());
        }
      }
      catch (ClassNotFoundException e)
      {
        e.printStackTrace();
      }
      catch (IllegalAccessException e)
      {
        e.printStackTrace();
      }
      catch (InstantiationException e)
      {
        e.printStackTrace();
      }
    }
    return constraints.elements();
  }



} 