package bruening.x4dialog;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.NoSuchElementException;
import java.util.Enumeration;
import java.util.StringTokenizer;

import org.w3c.dom.Element;

abstract public class Responder implements ResponderIF
{
  protected Hashtable params = null;
  protected Hashtable hashtableX4DialogModel = new Hashtable();
  protected X4DialogApplicationIF application = null;

  public void setApplication(X4DialogApplicationIF application)
  {
    this.application = application;
  }

  public abstract void registerModels();

  protected void registerModel(X4DialogModelIF model, String id)
  {
    hashtableX4DialogModel.put(id, model);
  }

  protected X4DialogModelIF getModel(String id)
  {
    return (X4DialogModelIF)hashtableX4DialogModel.get(id);
  }


  public void removeModels()
  {
    Enumeration enKeys = hashtableX4DialogModel.keys();
    while (enKeys.hasMoreElements())
    {
      hashtableX4DialogModel.remove(enKeys.nextElement());
    }
  }

  public void setParams(Hashtable params)
  {
    this.params = params;
  }

  protected String getParamValue(String paramName)
  {
    String paramValue = (String)params.get(paramName);
    if ((paramValue != null) && (paramValue.startsWith("webdialogcheckbox")))
    {
      StringTokenizer st = new StringTokenizer(paramValue, " ");
      String token = null;

      while (st.hasMoreTokens())
      {
        token = st.nextToken();
      }
      return token;
    }
    else
    {
      return paramValue;
    }
  }


  protected boolean paramHasPrefix(String paramName, String prefix)
  {
    StringTokenizer st = new StringTokenizer(paramName, ":");
    try
    {
      String token = st.nextToken();
      return token.equals(prefix);
    }
    catch (NoSuchElementException e)
    {
      return false;
    }
  }

  protected String getParamWithoutPrefix(String paramName)
  {
    StringTokenizer st = new StringTokenizer(paramName, ":");
    st.nextToken();
    return st.nextToken();
  }

  protected String getParamPrefix(String paramName)
  {
    StringTokenizer st = new StringTokenizer(paramName, ":");
    return st.nextToken();
  }

  protected String getStrippedParamPrefix(String paramName)
  {
    final String constraintPrefix = "constraint_";
    String prefix = getParamPrefix(paramName);
    if (prefix.startsWith(constraintPrefix))
    {
      return prefix.substring(constraintPrefix.length(), prefix.length());
    }
    return prefix;
  }


  public Element getNodeFromFullID(String id)
  {
    StringTokenizer st = new StringTokenizer(id, ":");
    String prefix = st.nextToken();
    String path = st.nextToken();
    X4DialogModelIF model =
      (X4DialogModelIF)hashtableX4DialogModel.get(prefix);
    return XMLUtils.getNode(path, model.getXMLRepresentation());
  }

  public abstract String _executeRequestCommand();

  public String executeRequestCommand()
  {
    String erg = _executeRequestCommand();
    removeModels();
    return erg;
  }
}
