package bruening.x4dialog;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;

public class Traversal
{
  private Visitor visitor;

  public Traversal(Visitor visitor)
  {
    this.visitor = visitor;
  }

  public void traverse(Node node)
  {
    if (node.getNodeType() == Node.ELEMENT_NODE)
    {
      visitor.visitElementPre((Element)node);
      NodeList nodeList = node.getChildNodes();
      int childrenCount = nodeList.getLength();
      if (childrenCount > 0)
      {
        for (int i = 0; i < childrenCount; i++)
        {
          traverse(nodeList.item(i));
        }
      }
      visitor.visitElementPost((Element)node);
    }
  }

}