package bruening.x4dialog;

import java.util.Vector;
import java.util.Enumeration;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Hashtable;

import org.xml.sax.SAXException;

import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.Document;

import org.apache.xerces.dom.DocumentImpl;

import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTResultTarget;

import org.apache.xalan.xpath.xml.XMLParserLiaison;

import org.apache.xalan.xslt.StylesheetRoot;

public class View
{
  private Hashtable modelHashtable = new Hashtable();
  private Composer composer = new Composer("composition");
  protected X4DialogApplicationIF application = null;
  private Hashtable styleSheetParamHashtable = new Hashtable();
  private StylesheetRoot compiledView;

  public View()
  {
    super();
  }

  public void setApplication(X4DialogApplicationIF application)
  {
    this.application = application;
  }

  public void setCompiledView(StylesheetRoot compiledView)
  {
    this.compiledView = compiledView;
  }

  public void removeModels()
  {
    Enumeration enKeys = modelHashtable.keys();
    while (enKeys.hasMoreElements())
    {
      modelHashtable.remove(enKeys.nextElement());
    }
  }

  public void registerModel(X4DialogModelIF x4DialogModel,
                            Document anDoc,
                            String prefix)
  {
    // Model unter prefix speichern
    modelHashtable.put(prefix, x4DialogModel);

    // Original-Model kopieren
    Document cloneDoc = new DocumentImpl();
    cloneDoc.appendChild(XMLUtils.cloneNode(cloneDoc,
                           x4DialogModel.getXMLRepresentation().getFirstChild()));

    // Document mit IDs und Annotations versehen
    Document transformedModel =
      getTransformedModel(cloneDoc, anDoc, prefix);

    // modifiziertes Document in das Composite-XML-Document einhaengen
    composer.addDocument(transformedModel, prefix);
  }


  public Document getComposite()
  {
    return composer.getComposition();
  }

  public String renderView()
  {
    try
    {
      XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
      XMLParserLiaison processorLiason = processor.getXMLProcessorLiaison();
      processorLiason.setIndent(2);

      StringWriter sw = new StringWriter();
      Document xml = getComposite();

      // Stylesheet-Parameter uebergeben
      Enumeration enStyleSheetParam = styleSheetParamHashtable.keys();
      while (enStyleSheetParam.hasMoreElements())
      {
        String key = (String)enStyleSheetParam.nextElement();
        processor.setStylesheetParam(key, "'" + (String)styleSheetParamHashtable.get(key) + "'");
      }

      XSLTResultTarget resultTraget = new XSLTResultTarget(sw);
      processor.setStylesheet(compiledView);
      processor.process(new XSLTInputSource(xml), null, resultTraget);
      return sw.toString();
    }
    catch (SAXException e)
    {
      e.printStackTrace();
      return null;
    }

    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }


  }

  private Document getTransformedModel(Document cloneDoc,
                                       Document anDoc,
                                       String prefix)
  {
    try
    {
      // fuer jeden Knoten Path-Informationen als Attribut eintragen
      PathVisitor pathVisitor = new PathVisitor(prefix);
      Traversal traversal = new Traversal(pathVisitor);
      traversal.traverse(cloneDoc.getFirstChild());

      // falls erforderlich, Annotations fuer das Model zuordnen
      if (anDoc != null)
      {
        cloneDoc = enforceAnnotations(cloneDoc, anDoc);
      }

      // temporaer benoetigte Attribute wieder entfernen
      cloneDoc = cleanUp(cloneDoc);
      return cloneDoc;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }


  private Document cleanUp(Document xmlDoc)
  {
    CleanUpVisitor cleanUpVisitor = new CleanUpVisitor();
    cleanUpVisitor.addWipeOutAttribute("anid");
    Traversal traversal = new Traversal(cleanUpVisitor);
    traversal.traverse(xmlDoc.getFirstChild());
    return xmlDoc;
  }

  private Document enforceAnnotations(Document xmlDoc, Document anDoc)
  {
    AnnotationVisitor annotationVisitor = new AnnotationVisitor(anDoc);
    Traversal traversal = new Traversal(annotationVisitor);
    traversal.traverse(xmlDoc.getFirstChild());
    return xmlDoc;
  }


  // Model ueber Prefix ermitteln
  public X4DialogModelIF getModel(String id)
  {
    StringTokenizer st = new StringTokenizer(id, ":");
    String prefix = st.nextToken();
    return (X4DialogModelIF)modelHashtable.get(prefix);
  }

  public void addStyleSheetParam(String key, String value)
  {
    styleSheetParamHashtable.put(key, value);
  }

  public void registerRejectedMessage(String paramName,
                                      String prefix,
                                      String message)
  {
    try
    {
      Element element =
        (Element)XPathAPI.selectSingleNode(composer.getComposition(),
                                           composer.getComposition().getDocumentElement().getTagName() +
                                           "/" + prefix + "/" + paramName);
      element.setAttribute("message", message);
      System.out.println("element = " + element.getTagName());
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

}
