package bruening.x4dialog.example;

import java.util.Hashtable;
import java.util.Enumeration;

import bruening.x4dialog.X4DialogApplication;
import bruening.x4dialog.X4DialogModelIF;
import bruening.x4dialog.ResponderIF;
import bruening.x4dialog.ModelXMLFromFile;
import bruening.x4dialog.X4DialogPropertiesIF;
import bruening.x4dialog.XMLUtils;

public class ExampleApplication extends X4DialogApplication
{
  private String[][] commandMatch =
    { { "listview", "edit",         "bruening.x4dialog.example.ListViewResponder" },
      { "listview", "delete",       "bruening.x4dialog.example.ListViewResponder" },
      { "",         "new",          "bruening.x4dialog.example.ListViewResponder" },
      { "",         "init",         "bruening.x4dialog.example.ListViewResponder" },
      { "",         "list",         "bruening.x4dialog.example.ListViewResponder" },
      { "editview", "save",         "bruening.x4dialog.example.EditViewResponder" },
      { "editview", "cancel",       "bruening.x4dialog.example.EditViewResponder" },
      { "newview",  "save",         "bruening.x4dialog.example.NewViewResponder" },
      { "newview",  "cancel",       "bruening.x4dialog.example.NewViewResponder" } };




  public ExampleApplication()
  {
    registerModel(new ModelXMLFromFile("demoDataAddress.xml"), "key_address");
    registerModel(new ModelXMLFromFile("demoDataEmptyAddress.xml"), "key_emptyaddress");
    registerModel(new ModelXMLFromFile("demoDataReiter.xml"), "key_reiter");
    registerModel(new ModelMessageOfTheDay(), "key_message");

    registerView("NewView", "NewView");
    registerView("ListView", "ListView");
    registerView("EditView", "EditView");
  }

  public ResponderIF getResponder(String view, String command)
  {
    if (view == null)
    {
      view = "";
    }

    for (int i = 0; i < commandMatch.length; i++)
    {
      String viewItem = commandMatch[i][0];
      String commandItem = commandMatch[i][1];
      if (view.equalsIgnoreCase(viewItem) && command.equalsIgnoreCase(commandItem))
      {
        try
        {
          Class responderClass = Class.forName(commandMatch[i][2]);
          ResponderIF responder = (ResponderIF)responderClass.newInstance();
          return responder;
        }
        catch (ClassNotFoundException e)
        {
          e.printStackTrace();
          return null;
        }
        catch (IllegalAccessException e)
        {
          e.printStackTrace();
          return null;
        }
        catch (InstantiationException e)
        {
          e.printStackTrace();
          return null;
        }
      }
    }
    System.out.println("Kein passender Responder gefunden");
    return null;
  }
}
