package bruening.x4dialog.example;

import java.util.Enumeration;
import java.util.StringTokenizer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.apache.xerces.dom.DocumentImpl;

import bruening.x4dialog.Responder;
import bruening.x4dialog.View;
import bruening.x4dialog.X4DialogPropertiesIF;
import bruening.x4dialog.XMLUtils;
import bruening.x4dialog.CleanUpVisitor;
import bruening.x4dialog.Traversal;

public class NewViewResponder extends Responder
{

  public NewViewResponder()
  {
    super();
  }

  public void registerModels()
  {
   registerModel(application.getModel("key_address"), "key_address");
  }

  public String _executeRequestCommand()
  {
  try
  {
    if (getParamValue("command").equalsIgnoreCase("save"))
    {
      Document addressDoc = application.getModel("key_address").getXMLRepresentation();
      Document docFromParams = new DocumentImpl();

      String paramName = "root[1]/address[1]/name[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/vorname[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/strasse[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/stadt[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/bundesland[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/liestix[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);
      paramName = "root[1]/address[1]/lieblingstier[1]";
      docFromParams = XMLUtils.addPathToDoc(paramName, getParamValue("key_emptyaddress:" + paramName), docFromParams);


      CleanUpVisitor cleanUpVisitor = new CleanUpVisitor();
      cleanUpVisitor.addWipeOutAttribute("tokenindex");
      Traversal traversal = new Traversal(cleanUpVisitor);
      try
      {
        traversal.traverse(docFromParams.getFirstChild());
      }
      catch (Exception e)
      {
        e.printStackTrace();
      }

      Element root = addressDoc.getDocumentElement();
      root.appendChild(XMLUtils.cloneNode(addressDoc, docFromParams.getFirstChild().getFirstChild()));

      return renderView();
    }

    if (getParamValue("command").equalsIgnoreCase("cancel"))
    {
      return renderView();
    }

    return null;
  }
  catch (Exception e)
  {
    e.printStackTrace();
    return null;
  }

  }

  private String renderView()
  {
    try
    {
      View view = new View();
      view.setApplication(application);
      view.setCompiledView(application.getCompiledView("ListView"));
      view.addStyleSheetParam("disabled", "edit");
      view.registerModel(application.getModel("key_address"), null, "key_address");
      view.registerModel(application.getModel("key_reiter"), null, "key_reiter");
      view.registerModel(application.getModel("key_message"), null, "key_message");

      String htmlString = view.renderView();
      view.removeModels();
      return htmlString;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }
}
