<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns="http://www.w3.org/TR/REC-html40">

  <xsl:import href="x4dialoglib.xsl"/>
  
  <xsl:output method="html" indent="yes"/>
  <xsl:variable name="selected">list</xsl:variable>
  <xsl:variable name="view">listview</xsl:variable>
  <xsl:param name="disabled">list</xsl:param>
  <xsl:variable name="servleturl">/servlet/ExampleServlet</xsl:variable>

  <xsl:template match="/">
    <html>
      <head>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
      </head>

      <body bgcolor="white" link="blue" vlink="blue" alink="blue">
        <form method="post">
          <xsl:attribute name="action">
            <xsl:value-of select="$servleturl"/>
          </xsl:attribute>


          <!-- Name des Views aus Variable view (siehe oben) -->
          <input type="hidden" name="view">
            <xsl:attribute name="value">
              <xsl:value-of select="$view"/>
            </xsl:attribute>
          </input>

          <!-- Reiter darstellen -->
          <xsl:apply-templates select="composition/key_reiter/reiter" />

          <table width="80%" bgcolor="#FFCC00" border="0" cellspacing="0" cellpadding="0" align="center">
            <tr height="30" valign="center">
              <td width="100%">&#160;<input type="submit" name="command" value="Delete"/>
              </td>
            </tr>


            <tr>
              <td valign="top">
                <table width="100%" border="0">
                  <tr bgcolor="FFFF66">
                    <td>
                    </td>
                    <td width="100%">
                      <b>Titel</b>
                    </td>
                  </tr>
                  <xsl:for-each select="composition/key_address/root/address">
                    <tr bgcolor="ffffcc">
                      <!-- Checkbox vor dem Link darstellen -->
                      <td><xsl:apply-templates select="self::node()[@wid]"/></td>
                      <td>

                        <!-- Hotlink darstellen -->
                        <xsl:call-template name="hotlink">
                          <xsl:with-param name="hotlinklabel">
                            <xsl:value-of select="vorname"/>&#160;<xsl:value-of select="name"/>
                          </xsl:with-param>
                          <xsl:with-param name="hotlinkhref">
                            <xsl:value-of select="concat($servleturl, '?view=', $view, '&amp;command=edit&amp;wid=', @wid)"/>
                          </xsl:with-param>
                        </xsl:call-template>
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </td>
            </tr>
            <tr height="30" valign="center">
              <td width="100%">&#160;<input type="submit" name="command" value="Delete"/>
              </td>
            </tr>
            <tr>
              <td>
                <table width="100%" border="0">
                  <tr>
                    <td height="20" bgcolor="FFFFcc">
                      <font size="1">
                        <b>
                          &#160;Message of the Day:
                          <!-- Message of the Day darstellen -->
                          <xsl:value-of select="composition/key_message/root/message" />
                        </b>
                      </font>
                    </td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </form>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="address[@wid]">
    <xsl:call-template name="checkbox">
      <xsl:with-param name="checkboxlabel"/>
      <xsl:with-param name="checkboxvalue">false</xsl:with-param>
    </xsl:call-template>
  </xsl:template>
</xsl:stylesheet>

