using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Security.Cryptography;
using System.Globalization;

namespace Symmetrisch
{
	/// <summary>
	/// Zusammendfassende Beschreibung fr Form2.
	/// </summary>
	public class SaveDialog : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label lFileName;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox checkBox1;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox tbKey;
		private Form1 _f;
		private System.Windows.Forms.Label tbKeyLength;
		private Rijndael rj;

		public SaveDialog(Form1 f)
		{
			_f = f;
			InitializeComponent();
			lFileName.Text = _f.fi.FullName;
			if (_f.FileStatus == FileStatusEnum.UnCrypted)
			{
				this.checkBox1.Checked = true;
			} 
			else 
			{
				this.checkBox1.Checked = false;
			}
			rj = Rijndael.Create();
			tbKey.Text = SetKey(rj.Key);
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label4 = new System.Windows.Forms.Label();
			this.tbKey = new System.Windows.Forms.TextBox();
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lFileName = new System.Windows.Forms.Label();
			this.tbKeyLength = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(200, 168);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(80, 23);
			this.button1.TabIndex = 2;
			this.button1.Text = "Speichern";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(120, 168);
			this.button2.Name = "button2";
			this.button2.TabIndex = 3;
			this.button2.Text = "Abbrechen";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.tbKeyLength,
																					this.label4,
																					this.tbKey,
																					this.checkBox1,
																					this.label1,
																					this.lFileName});
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(272, 152);
			this.groupBox1.TabIndex = 4;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Speicherinformationen";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 89);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(100, 16);
			this.label4.TabIndex = 8;
			this.label4.Text = "Schlssel:";
			// 
			// tbKey
			// 
			this.tbKey.Location = new System.Drawing.Point(9, 112);
			this.tbKey.Name = "tbKey";
			this.tbKey.Size = new System.Drawing.Size(256, 20);
			this.tbKey.TabIndex = 7;
			this.tbKey.Text = "";
			// 
			// checkBox1
			// 
			this.checkBox1.Enabled = false;
			this.checkBox1.Location = new System.Drawing.Point(16, 19);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.Size = new System.Drawing.Size(232, 16);
			this.checkBox1.TabIndex = 4;
			this.checkBox1.Text = "Datei wird verschlsselt gespeichert";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 40);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(232, 16);
			this.label1.TabIndex = 3;
			this.label1.Text = "Es wird folgende Datei gespeichert:";
			// 
			// lFileName
			// 
			this.lFileName.BackColor = System.Drawing.SystemColors.ControlLight;
			this.lFileName.Location = new System.Drawing.Point(14, 64);
			this.lFileName.Name = "lFileName";
			this.lFileName.Size = new System.Drawing.Size(240, 18);
			this.lFileName.TabIndex = 2;
			// 
			// tbKeyLength
			// 
			this.tbKeyLength.Location = new System.Drawing.Point(168, 88);
			this.tbKeyLength.Name = "tbKeyLength";
			this.tbKeyLength.TabIndex = 9;
			// 
			// SaveDialog
			// 
			this.AutoScale = false;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.button2;
			this.ClientSize = new System.Drawing.Size(288, 198);
			this.ControlBox = false;
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox1,
																		  this.button2,
																		  this.button1});
			this.MinimumSize = new System.Drawing.Size(296, 144);
			this.Name = "SaveDialog";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Speichern";
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void button2_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		public string SetKey(byte[] rjKey)
		{
			string result = String.Empty;
			for (int i = 0; i < rjKey.Length; i++)
			{
				result += String.Format("{0:X2}", rjKey[i]);
			}
			this.tbKeyLength.Text = "(" + result.Length + "=" + rjKey.Length + ")";
			return result;
		}

		public byte[] GetKey(string val)
		{
			int newlen = (int) Math.Floor(val.Length / 2);
			byte[] result = new byte[newlen];
			for (int i = 0; i < newlen; i+=2)
			{
				result[i] = Byte.Parse(val.Substring(i*2, 2), NumberStyles.HexNumber);
			}
			return result;
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			FileStream fsLoad = new FileStream(_f.LoadFileName, FileMode.Open);
			byte[] buffer = new Byte[fsLoad.Length];
			fsLoad.Read(buffer, 0, (int) fsLoad.Length);
			fsLoad.Close();
			FileStream fsSave = new FileStream(_f.SaveFileName, FileMode.Create);
			ICryptoTransform ct;
			int offset = 0;
			if (this.checkBox1.Checked)
			{
				// unverschlsselt gelesene Datei nun verschlsseln
				fsSave.Write(rj.IV, 0, 16);	// Vektor an den Anfang schreiben
				fsSave.Flush();
				ct = rj.CreateEncryptor(GetKey(tbKey.Text), rj.IV); // Transformer erzeugen
			}
			else
			{
				offset = 16;
				byte[] oldIV = new byte[offset];
				Array.Copy(buffer, oldIV, offset);
				rj.IV = oldIV;
				ct = rj.CreateDecryptor(GetKey(tbKey.Text), rj.IV);
			}
			try
			{
				CryptoStream cs = new CryptoStream(fsSave, ct, CryptoStreamMode.Write);
				int len = buffer.Length - offset;
				cs.Write(buffer, offset, len);
				cs.Close();
			} 
			catch (Exception ex)
			{
				MessageBox.Show("Fehler: \n\n" + ex.Message, "Transformationsfehler", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			}
			this.Close();		// Form schlieen
		}
	}
}
