/*
        Diese Datei "Puzzle.js" ist Bestandteil des Projektes
        "Puzzle-Objekte" und demonstriert Mglichkeiten der
        objektorientierten Programmierung einer Drag-and-Drop-Anwendung
        unter JavaScript.

        In dieser Datei befinden sich alle Eigenschaften und Methoden,
        um die Puzzlekarten mit den ntigen Funktionen zu versehen.

         ----- Autor: Stefan Spohn, April 2001 -------
*/

//

var globDrag = false;
// Schalter fr drag and drop
// Diese Variable   m u s s  hier initialisiert werden.
// Wrde die Initialisierung bei den anderen glob. Variablen
// innerhalb von "Puzzle.htm" erfolgen,
// gibt der MS Explorer merkwrdigerweise dann einen Fehler aus,
// wenn das Puzzle vom Desktop aus per Doppelklick gestartet wird.

function oPuzz(x, y, ImgName, ID)
{
    /*
    Jedes Kartenobjekt erzeugt dynamisch
    sein eigenes Startfeld als eingebettetes Objekt.
    */
    this.Startpos    = new oSquare(x,y, "Rahmen.gif");

    // Vererbung:
    // oPuzz ist eine SubKlasse der Superklasse oSquare
    // 'basedOn': frei gewhlter Bezeichner
    this.basedOn = oSquare;

    // Aufruf des Konstruktors der Superklasse
    this.basedOn(x, y, ImgName, ID);

    //Eigenschaften
    this.id        = ID;
    this.ImgID     = document.images.length-1;// wg. Opera;
    this.zIndex    = globIndex;
    this.el        = GetRef("Puzz"+ID);

    // Methoden:
    this.ChgPic    = mPuzz_ChgPic;
    this.MoveBy    = mPuzz_MoveBy;
    this.MoveTo    = mPuzz_MoveTo;
    this.Move      = mPuzz_Move;
    this.ToStart   = mPuzz_ToStart;
    this.ChgWith   = mPuzz_ChgWith;
    this.SetIndex  = mPuzz_SetIndex;
    this.Intersect = mPuzz_Intersect;

    //Eventhandler fr jedes Puzzleteil
    if (this.el.captureEvents) // fuer NC 4
    	this.el.captureEvents(Event.MOUSEDOWN);

    	this.el.onmousedown = mdown; // fuer NC4 und die anderen Browser
}

// Eventhandler auf Dokumentebene:
     if (document.captureEvents)
      document.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP);

     document.onmousemove = mmove;
     document.onmouseup = mup;

//oPuzz.prototype = new oSquare(); <br>
//... muss nicht angefgt werden<br>
// entgegen der Ausfhrungen in ix 4/2001, S. 194

function mdown(e)
{
// Mausklick auf einer Karte:

    Click_X = GetX(e);
    Click_Y = GetY(e);

    // Welche Karte ist es?
    var i = 0;
    while (Puzz[i++].el != this){};

    ClickedPuzz = Puzz[--i];
    ClickedPuzz.SetIndex(++globIndex);

    globDrag = true;

return false;
}

function mmove(e)
{
// Bewegung der Maus:

   if (!globDrag) return;

   var New_X = GetX(e);
   var New_Y = GetY(e);

   var Dist_X = (New_X-Click_X);
   var Dist_Y = (New_Y-Click_Y);

   // Mausposition zwischenspeichern
   Click_X = New_X;
   Click_Y = New_Y;

   ClickedPuzz.MoveBy(Dist_X, Dist_Y);
}

function mup(e)
{
// Maustaste losgelassen:

var i = nTeile;
var max = 0;
var Feld = -1;
var n;

    globDrag = false;
    if (!ClickedPuzz) return;

    // mit welchem der neun Spielfeldler
    // besteht die grte Schnittflche?
    while(i--)
    {
        // Das Spielfeld mit der max.
        // Schnittflche ermitteln:
        n = ClickedPuzz.Intersect(Spielfeld[i]);
        if (n > max)
        {
            max = n;
            Feld = i;
        }
    }

    // Das Spielfeld, das mit der aktuellen Puzzlekarte
    // die grte Schnittmenge bildet, zieht die Karte
    // magnetisch an und positioniert sie genau auf dem Feld.
    if (Feld > - 1)
        ClickedPuzz.MoveTo(Spielfeld[Feld].x, Spielfeld[Feld].y);

    ClickedPuzz = null;
}
function oSquare(x, y, Img, ID)
{
    this.x   = x;
    this.y   = y;
    this.Img = PathOfPics+Img;

    CreateLayer(x, y, Img, ID);
}

function mPuzz_MoveBy(distX, distY)
{
    this.x += distX;
    this.y += distY;

    this.Move();
}

function mPuzz_MoveTo(ToX, ToY)
{
    this.x = ToX;
    this.y = ToY;

    this.Move();
}

function mPuzz_Move()
/*
Objekt auf neue Position setzen
*/
{
    if (isNC4())
        this.el.moveTo(this.x, this.y);

    if(isMSIE5() || isN6() || isOpera())
    {
       this.el.style.left = this.x;
       this.el.style.top  = this.y;
    }
}

function mPuzz_ChgWith(ChgObj)
{
var TempX, TempY;

    TempX = this.x;
    TempY = this.y;

    // Karte "ber" die Startfeldern legen
    this.SetIndex(++globIndex);
    this.MoveTo(ChgObj.x, ChgObj.y);
    ChgObj.MoveTo(TempX, TempY);

    var t = this.Startpos;
        this.Startpos = ChgObj.Startpos;
        ChgObj.Startpos = t;
}

function mPuzz_Intersect(obj)
/*
    Bei welchem Spielfeld
    gibt es die grte berschneidung
    mit dem aktuellen Puzzleteil?
*/
{
var diffX;

    if (this.x < obj.x)
        diffX = this.x+60 - obj.x
    else
        diffX = obj.x+60-this.x


    if (diffX < 0 || diffX > 60)
       diffX = 0;

    if (this.y < obj.y)
        diffY = this.y + 60-obj.y;
    else
        diffY =  obj.y + 60-this.y


    if (diffY < 0 || diffY > 60)
        diffY = 0;

    if (diffX * diffY >= 900)
        return (diffX + diffY);
    else
        return 0;
}

function mPuzz_ToStart()
/*
    Puzzleteile in die Ausgangsposition bringen
*/
{
    this.MoveTo(this.Startpos.x, this.Startpos.y);
}

function mPuzz_ChgPic(n)
/*
    Puzzleteil mit anderem Bild versehen
*/
{
this.Img = PathOfPics+Serie[n]+"_"+this.id+".jpg";

    if (isNC4())
        this.el.document.images[0].src = this.Img;

    if (isMSIE5() || isN6())
        this.el.style.background = "url( "+this.Img+" )";

    if (isOpera())
        document.images[this.ImgID].src = this.Img;
}

function mPuzz_SetIndex(n)
/*
    Das angeklickte Puzzleteil
    wird in den Vordergrund gesetzt,
    indem die globale Variable inkrementiert wird.
*/
{
    this.zIndex = n;

    if (isNC4())
        this.el.zIndex = this.zIndex;

    if (isMSIE5() || isN6() || isOpera())
        this.el.style.zIndex = this.zIndex;
}

function CreateLayer(x, y, Img, id)
{
    ImgName = PathOfPics+Img;
    var s ="\n";

    if (isNC4())
    {
        s += "<layer id= Puzz"+id
        s += " top= "+ y  +" left= "+ x +" z-index= 30>"
        s += " <img src= "+ImgName+">"
        s += " </layer>";
    }

    if (isMSIE5() || isN6())
    //Grafik als Hintergrundbild
    {
       s += "<div id= Puzz"+id
       s += " style= 'background-image: url("+ImgName+");"
       s += " position:absolute; width: 60; height: 60;";
       s += " top:" +y+ "; left: "+x+"; z-index = 30'>"
       s += " </div>";
    }

    if (isOpera())
    {
       s += "<div id= Puzz"+id
       s += " style= 'position:absolute; width: 60; height: 60;";
       s += " top:" +y+ "; left: "+x+"; z-index = 30'>";
       s += " <img src="+ImgName+">";
       s += " </div>";
    }
    document.open();
    document.write(s);
    document.close();
}

function GetRef(layer)
{
var ref;

    if (isNC4())
        ref = eval("document."+layer);

    if (isN6() || isOpera())
        ref = eval(document.getElementById(layer));

    if (isMSIE5())
        ref = eval("document.all."+layer);

return ref;
}

function GetX(e)
{
    if (isNC4() || isN6())
        return e.pageX;

    if (isOpera())
        return e.x+pageXOffset;


    if (isMSIE5())
        return event.clientX + document.body.scrollLeft;
}

function GetY(e)
{
    if (isNC4() || isN6())
        return e.pageY;

    if (isOpera())
        return e.y + pageYOffset;

    if (isMSIE5())
        return event.clientY + document.body.scrollTop;
}

// Funktionen zur Identifizierung der jeweiligen Browser

function isOpera()
{
   var s = navigator.userAgent;
   return (s.lastIndexOf("Opera") > -1);
}

function isN6()
{
   var s = navigator.userAgent;
   return (s.lastIndexOf("Netscape6") > -1);
}

function isNC4()
{
   return (document.layers);
}

function isMSIE5()
{
   var s = navigator.userAgent;
   return (s.lastIndexOf("MSIE 5") > -1 && s.lastIndexOf("Opera") == -1);
  // Opera kann sich nmlich als MSIE5-kompatibel ausgeben,
  // was aber nicht hundertprozentig stimmt.
}