#include <iostream>
using namespace std;

namespace original
{
	template <class T,int n>
	class Stack
	{
		public:
			Stack():size_(0)
			{}
			void push(const T& i)
			{
				elements_[size_++] = i;
			}
			T pop()
			{
				return elements_[--size_];
			}
			const int& size() const
			{
				return size_;
			}
			int capacity() const
			{
				return n;
			}
		protected:
			T elements_[n];
			int size_;
	};
}

namespace aspects
{
	template <class T,int n>
	class StackWithDisplaying: public original::Stack<T,n>
	{
		private:
			void display() const
			{
				for (int i=0; i < size(); ++i)
					cout	<< i << ": " 
							<< elements_[i] << endl;
				cout	<< "elements: " << size()
						<< ", capacity: " << capacity() 
						<< ", free: " << capacity() - size() 
						<< endl;
			}
		public:
			~StackWithDisplaying()
			{
				display();
			}
	};
}


namespace composed
{
	template <class T,int n>
	class Stack: public aspects::StackWithDisplaying<T,n>
	{};
	/*
	template <class T,int n>
	class Stack: public original::Stack<T,n>//aspects::StackWithDisplaying<T,n>
	{};
	*/
	//using namespace original;
}

int main()
{
	using namespace composed;

	Stack<char,3> s;
	s.push('a');
	s.push('b');
	s.push('c');
	//s.push(4);
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	//cout << s.pop() << endl;

	return 0;
}
