#include <iostream>
#include <exception>
using namespace std;

class ReportTracing // helper class for implementing Tracing aspect
{
	public:
		ReportTracing(const char* function):function_(function)
		{
			cout << "Before " << function_ << endl;
		}
		~ReportTracing()
		{
			cout << "After " << function_ << endl;
		}
	private:
		const char* function_;
};

class CheckingException: public exception
{
	public:
		CheckingException(const char* msg):msg_(msg)
		{}
		const char* what() const throw()
		{	
			return msg_;
		}
	private:
		const char* msg_;
};

class IntStack
{
	public:
		IntStack():size_(0)
		{
			ReportTracing t("constructor");
		}
		void push(const int& i) 
		{	ReportTracing t("push");
			if (size() == capacity())
				throw CheckingException("stack overflow");
			elements_[size_++] = i;
		}
		int pop() 
		{
			if (size() == 0)
				throw CheckingException("stack underflow");
			ReportTracing t("pop");
			return elements_[--size_];
		}
		const int& size() const
		{
			ReportTracing t("size");
			return size_;
		}
		int capacity() const
		{
			ReportTracing t("capacity");
			return max_size_;
		}
	private:
		enum { max_size_ = 3 };
		int elements_[max_size_];
		int size_;
};

int main()
{
	try
	{
		IntStack s;
		s.push(1);
		s.push(2);
		s.push(3);
		//s.push(4);
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		cout << s.pop() << endl;
	}
	catch (CheckingException& c)
	{
		cerr << c.what() << endl;
	}
	return 0;
}
