#include <iostream>
#include <exception>
using namespace std;

class IntStack
{
	public:
		IntStack():size_(0)
		{}
		void push(const int& i)
		{
			elements_[size_++] = i;
		}
		int pop()
		{
			return elements_[--size_];
		}
		const int& size() const
		{
			return size_;
		}
		int capacity() const
		{
			return max_size_;
		}
	private:
		enum { max_size_ = 3 };
		int elements_[max_size_];
		int size_;
};

class CheckingException: public exception
{
	public:
		CheckingException(const char* msg):msg_(msg)
		{}
		const char* what() const throw()
		{	
			return msg_;
		}
	private:
		const char* msg_;
};

class IntStackWithChecking: public IntStack
{
	public:
		void push(const int& i)
		{
			if (size() == capacity())
				throw CheckingException("stack overflow");
			IntStack::push(i);
		}
		int pop()
		{
			if (size() == 0)
				throw CheckingException("stack underflow");
			return IntStack::pop();
		}
};

int main()
{
	try
	{
		IntStackWithChecking s;
		s.push(1);
		s.push(2);
		s.push(3);
		//s.push(4);
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		cout << s.pop() << endl;
		cout << s.pop() << endl;
	}
	catch (CheckingException& c)
	{
		cerr << c.what() << endl;
	}
	return 0;
}
