#include <iostream>
using namespace std;

namespace original
{
	class IntStack
	{
		public:
			IntStack():size_(0)
			{}
			void push(const int& i)
			{
				elements_[size_++] = i;
			}
			int pop()
			{
				return elements_[--size_];
			}
			const int& size() const
			{
				return size_;
			}
			int capacity() const
			{
				return max_size_;
			}
		protected:
			enum { max_size_ = 3 };
			int elements_[max_size_];
			int size_;
	};
}

namespace aspects
{
	typedef original::IntStack IntStack;

	class IntStackWithDisplaying: public IntStack
	{
		protected:
			void display() const
			{
				for (int i=0; i < size(); ++i)
					cout	<< i << ": " 
							<< elements_[i] << endl;
				cout	<< "elements: " << size()
						<< ", capacity: " << capacity() 
						<< ", free: " << capacity() - size() 
						<< endl;
			}
		public:
			~IntStackWithDisplaying()
			{
				display();
			}
	};
}


namespace composed
{
	typedef aspects::IntStackWithDisplaying IntStack; // IntStack with Displaying
}

int main()
{
	using namespace composed;

	IntStack s;
	s.push(1);
	s.push(2);
	s.push(3);
	//s.push(4);
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	cout << s.pop() << endl;
	//cout << s.pop() << endl;

	return 0;
}
